/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import me.mrnavastar.protoweaver.libs.org.apache.fury.reflect.TypeParameter;
import me.mrnavastar.protoweaver.libs.org.apache.fury.type.TypeUtils;

public class TypeRef<T> {
    private final Type type;
    private final Object extInfo;
    private transient Class<? super T> rawType;
    private transient Map<TypeVariableKey, Type> typeMappings;

    protected TypeRef() {
        this.type = this.capture();
        this.extInfo = null;
    }

    protected TypeRef(Object extInfo) {
        this.type = this.capture();
        this.extInfo = extInfo;
    }

    private TypeRef(Class<T> declaringClass) {
        this.type = declaringClass;
        this.extInfo = null;
    }

    private TypeRef(Class<T> declaringClass, Object extInfo) {
        this.type = declaringClass;
        this.extInfo = extInfo;
    }

    private TypeRef(Type type) {
        this.type = type;
        this.extInfo = null;
    }

    public static <T> TypeRef<T> of(Class<T> clazz) {
        return new TypeRef<T>(clazz);
    }

    public static <T> TypeRef<T> of(Class<T> clazz, Object extInfo) {
        return new TypeRef<T>(clazz, extInfo);
    }

    public static <T> TypeRef<T> of(Type type) {
        return new TypeRef<T>(type);
    }

    private Type capture() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new IllegalArgumentException(superclass + " isn't parameterized");
        }
        return ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    public Type getType() {
        return this.type;
    }

    public Class<? super T> getRawType() {
        Class<? super T> cachedRawType = this.rawType;
        if (cachedRawType != null) {
            return cachedRawType;
        }
        Class<?> rawType = TypeUtils.getRawType(this.type);
        this.rawType = rawType;
        return rawType;
    }

    private static Stream<Class<?>> getRawTypes(Type ... types) {
        return Arrays.stream(types).flatMap(type -> {
            if (type instanceof TypeVariable) {
                return TypeRef.getRawTypes(((TypeVariable)type).getBounds());
            }
            if (type instanceof WildcardType) {
                return TypeRef.getRawTypes(((WildcardType)type).getUpperBounds());
            }
            if (type instanceof ParameterizedType) {
                return Stream.of((Class)((ParameterizedType)type).getRawType());
            }
            if (type instanceof Class) {
                return Stream.of((Class)type);
            }
            if (type instanceof GenericArrayType) {
                Class rawType = TypeRef.getArrayClass(TypeRef.of(((GenericArrayType)type).getGenericComponentType()).getRawType());
                return Stream.of(rawType);
            }
            throw new AssertionError((Object)("Unknown type: " + type));
        });
    }

    public Object getExtInfo() {
        return this.extInfo;
    }

    public boolean isPrimitive() {
        return this.type instanceof Class && ((Class)this.type).isPrimitive();
    }

    public boolean isArray() {
        return TypeRef.getComponentType(this.type) != null;
    }

    public TypeRef<?> getComponentType() {
        return TypeRef.of(TypeRef.getComponentType(this.type));
    }

    private static Type getComponentType(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof TypeVariable) {
            return TypeRef.subtypeOfComponentType(((TypeVariable)type).getBounds());
        }
        if (type instanceof WildcardType) {
            return TypeRef.subtypeOfComponentType(((WildcardType)type).getUpperBounds());
        }
        if (type instanceof Class) {
            return ((Class)type).getComponentType();
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        return null;
    }

    private static Type subtypeOfComponentType(Type[] bounds) {
        for (Type bound : bounds) {
            Class componentClass;
            Type componentType = TypeRef.getComponentType(bound);
            if (componentType == null) continue;
            if (componentType instanceof Class && (componentClass = (Class)componentType).isPrimitive()) {
                return componentClass;
            }
            return componentType;
        }
        return null;
    }

    public TypeRef<?> resolveType(Type iteratorReturnType) {
        if (iteratorReturnType instanceof WildcardType) {
            return TypeRef.of(iteratorReturnType);
        }
        Type invariantContext = WildcardCapturer.capture(this.type);
        Map<TypeVariableKey, Type> mappings = TypeRef.resolveTypeMappings(invariantContext);
        return this.resolveType0(iteratorReturnType, mappings);
    }

    private TypeRef<?> resolveType0(Type iteratorReturnType, Map<TypeVariableKey, Type> mappings) {
        if (iteratorReturnType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)iteratorReturnType;
            Type type = mappings.get(new TypeVariableKey(typeVariable));
            if (type == null) {
                return TypeRef.of(typeVariable);
            }
            return this.resolveType0(type, mappings);
        }
        if (iteratorReturnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)iteratorReturnType;
            Type owner = parameterizedType.getOwnerType();
            Type resolvedOwner = owner == null ? null : this.resolveType0((Type)owner, mappings).type;
            Type resolvedRawType = this.resolveType0((Type)parameterizedType.getRawType(), mappings).type;
            Type[] args = parameterizedType.getActualTypeArguments();
            Type[] resolvedArgs = new Type[args.length];
            for (int i = 0; i < args.length; ++i) {
                resolvedArgs[i] = this.resolveType0((Type)args[i], mappings).type;
            }
            return TypeRef.of(new ParameterizedTypeImpl(resolvedOwner, resolvedRawType, resolvedArgs));
        }
        if (iteratorReturnType instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)iteratorReturnType).getGenericComponentType();
            Type resolvedComponentType = this.resolveType0((Type)componentType, mappings).type;
            return TypeRef.of(TypeRef.newArrayType(resolvedComponentType));
        }
        return TypeRef.of(iteratorReturnType);
    }

    private Map<TypeVariableKey, Type> resolveTypeMappings() {
        Map<TypeVariableKey, Type> cachedMappings = this.typeMappings;
        if (cachedMappings != null) {
            return cachedMappings;
        }
        Map<TypeVariableKey, Type> typeMappings = TypeRef.resolveTypeMappings(this.type);
        this.typeMappings = typeMappings;
        return typeMappings;
    }

    private static Map<TypeVariableKey, Type> resolveTypeMappings(Type contextType) {
        HashMap<TypeVariableKey, Type> result = new HashMap<TypeVariableKey, Type>();
        TypeRef.populateTypeMapping(result, contextType);
        return result;
    }

    private static void populateTypeMapping(Map<TypeVariableKey, Type> storage, Type ... types) {
        for (Type type : types) {
            if (type == null) continue;
            if (type instanceof TypeVariable) {
                TypeRef.populateTypeMapping(storage, ((TypeVariable)type).getBounds());
                continue;
            }
            if (type instanceof WildcardType) {
                TypeRef.populateTypeMapping(storage, ((WildcardType)type).getUpperBounds());
                continue;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class rawClass = (Class)parameterizedType.getRawType();
                TypeVariable<Class<T>>[] vars = rawClass.getTypeParameters();
                Type[] typeArgs = parameterizedType.getActualTypeArguments();
                block1: for (int i = 0; i < vars.length; ++i) {
                    Type arg;
                    TypeVariable typeVariable = vars[i];
                    TypeVariableKey key = new TypeVariableKey(typeVariable);
                    if (storage.containsKey(key)) continue;
                    Type t2 = arg = typeArgs[i];
                    while (t2 != null) {
                        if (TypeRef.typeVariablesEquals(typeVariable, t2)) {
                            Type x = arg;
                            while (x != null) {
                                x = storage.remove(TypeRef.asTypeVariableKeyOrNull(x));
                            }
                            break block1;
                        }
                        t2 = storage.get(TypeRef.asTypeVariableKeyOrNull(t2));
                    }
                    storage.put(key, arg);
                }
                TypeRef.populateTypeMapping(storage, rawClass);
                TypeRef.populateTypeMapping(storage, parameterizedType.getOwnerType());
                continue;
            }
            if (type instanceof Class) {
                Class clazz = (Class)type;
                TypeRef.populateTypeMapping(storage, clazz.getGenericSuperclass());
                TypeRef.populateTypeMapping(storage, clazz.getGenericInterfaces());
                continue;
            }
            throw new AssertionError((Object)("Unknown type: " + type));
        }
    }

    public TypeRef<? super T> getSupertype(Class<? super T> superclass) {
        if (this.type instanceof TypeVariable) {
            return this.getSupertypeFromBounds(superclass, ((TypeVariable)this.type).getBounds());
        }
        if (this.type instanceof WildcardType) {
            return this.getSupertypeFromBounds(superclass, ((WildcardType)this.type).getUpperBounds());
        }
        if (superclass.isArray()) {
            Type componentType;
            if (this.type instanceof Class) {
                componentType = ((Class)this.type).getComponentType();
            } else if (this.type instanceof GenericArrayType) {
                componentType = ((GenericArrayType)this.type).getGenericComponentType();
            } else {
                throw new AssertionError((Object)("Unknown type: " + this.type));
            }
            if (componentType == null) {
                throw new IllegalArgumentException(superclass + " isn't a super type of " + this);
            }
            TypeRef<?> componentTypeRef = TypeRef.of(componentType);
            TypeRef<T> componentSupertype = componentTypeRef.getSupertype(superclass.getComponentType());
            return TypeRef.of(TypeRef.newArrayType(componentSupertype.type));
        }
        Map<TypeVariableKey, Type> mappings = this.resolveTypeMappings();
        TypeRef<?> supertype = this.resolveType0(TypeRef.toGenericType(superclass), mappings);
        return supertype;
    }

    private static <T> Type toGenericType(Class<T> cls) {
        Type ownerType;
        if (cls.isArray()) {
            return TypeRef.newArrayType(TypeRef.toGenericType(cls.getComponentType()));
        }
        Type[] typeParams = cls.getTypeParameters();
        Type type = ownerType = cls.isMemberClass() && !Modifier.isStatic(cls.getModifiers()) ? TypeRef.toGenericType(cls.getEnclosingClass()) : null;
        if (typeParams.length > 0 || ownerType != null && ownerType != cls.getEnclosingClass()) {
            return new ParameterizedTypeImpl(ownerType, cls, typeParams);
        }
        return cls;
    }

    private TypeRef<? super T> getSupertypeFromBounds(Class<? super T> superclass, Type[] bounds) {
        for (Type upperBound : bounds) {
            TypeRef<? super T> bound = TypeRef.of(upperBound);
            if (!bound.isSubtypeOf(superclass)) continue;
            TypeRef<? super T> result = bound.getSupertype(superclass);
            return result;
        }
        throw new IllegalArgumentException(superclass + " isn't a super type of " + this);
    }

    public final TypeRef<? extends T> getSubtype(Class<?> subclass) {
        if (this.type instanceof WildcardType) {
            Type[] lowerBounds = ((WildcardType)this.type).getLowerBounds();
            if (lowerBounds.length > 0) {
                TypeRef<T> bound = TypeRef.of(lowerBounds[0]);
                return bound.getSubtype(subclass);
            }
            throw new IllegalArgumentException(subclass + " isn't a subclass of " + this);
        }
        Type componentType = TypeRef.getComponentType(this.type);
        if (componentType != null) {
            Class<?> subclassComponentType = subclass.getComponentType();
            if (subclassComponentType == null) {
                throw new IllegalArgumentException(subclass + " does not appear to be a subtype of " + this);
            }
            TypeRef<T> componentSubtype = TypeRef.of(componentType).getSubtype(subclassComponentType);
            return TypeRef.of(TypeRef.newArrayType(componentSubtype.type));
        }
        Class<T> rawType = this.getRawType();
        if (!rawType.isAssignableFrom(subclass)) {
            throw new IllegalArgumentException(subclass + " isn't a subclass of " + this);
        }
        if (this.type instanceof Class && (subclass.getTypeParameters().length == 0 || rawType.getTypeParameters().length != 0)) {
            TypeRef<?> result = TypeRef.of(subclass);
            return result;
        }
        TypeRef<T> genericSubtype = TypeRef.of(TypeRef.toGenericType(subclass));
        Type supertypeWithArgsFromSubtype = genericSubtype.getSupertype(rawType).type;
        if (genericSubtype.type instanceof WildcardType) {
            TypeRef<T> result = genericSubtype;
            return result;
        }
        HashMap<TypeVariableKey, Type> mappings = new HashMap<TypeVariableKey, Type>();
        this.populateTypeMappings(mappings, supertypeWithArgsFromSubtype, this.type);
        return this.resolveType0(genericSubtype.type, mappings);
    }

    private void populateTypeMappings(Map<TypeVariableKey, Type> mappings, Type supertypeWithArgsFromSubtype, Type toType) {
        if (supertypeWithArgsFromSubtype instanceof TypeVariable) {
            TypeVariableKey typeVariableKey = new TypeVariableKey((TypeVariable)supertypeWithArgsFromSubtype);
            mappings.put(typeVariableKey, toType);
        } else if (supertypeWithArgsFromSubtype instanceof WildcardType) {
            int i;
            if (!(toType instanceof WildcardType)) {
                return;
            }
            WildcardType supertypeWildcard = (WildcardType)supertypeWithArgsFromSubtype;
            WildcardType toWildcardType = (WildcardType)toType;
            Type[] fromUpperBounds = supertypeWildcard.getUpperBounds();
            Type[] toUpperBounds = toWildcardType.getUpperBounds();
            Type[] fromLowerBounds = supertypeWildcard.getLowerBounds();
            Type[] toLowerBounds = toWildcardType.getLowerBounds();
            for (i = 0; i < fromUpperBounds.length; ++i) {
                this.populateTypeMappings(mappings, fromUpperBounds[i], toUpperBounds[i]);
            }
            for (i = 0; i < fromLowerBounds.length; ++i) {
                this.populateTypeMappings(mappings, fromLowerBounds[i], toLowerBounds[i]);
            }
        } else if (supertypeWithArgsFromSubtype instanceof ParameterizedType) {
            if (toType instanceof WildcardType) {
                return;
            }
            ParameterizedType toParameterizedType = (ParameterizedType)toType;
            ParameterizedType supertypeParameterized = (ParameterizedType)supertypeWithArgsFromSubtype;
            if (supertypeParameterized.getOwnerType() != null && toParameterizedType.getOwnerType() != null) {
                this.populateTypeMappings(mappings, supertypeParameterized.getOwnerType(), toParameterizedType.getOwnerType());
            }
            Type[] fromArgs = supertypeParameterized.getActualTypeArguments();
            Type[] toArgs = toParameterizedType.getActualTypeArguments();
            for (int i = 0; i < fromArgs.length; ++i) {
                this.populateTypeMappings(mappings, fromArgs[i], toArgs[i]);
            }
        } else if (supertypeWithArgsFromSubtype instanceof GenericArrayType) {
            if (toType instanceof WildcardType) {
                return;
            }
            Type componentType = TypeRef.getComponentType(toType);
            Type fromComponentType = ((GenericArrayType)supertypeWithArgsFromSubtype).getGenericComponentType();
            this.populateTypeMappings(mappings, fromComponentType, componentType);
        } else if (!(supertypeWithArgsFromSubtype instanceof Class)) {
            throw new AssertionError((Object)("Unknown type: " + toType));
        }
    }

    public boolean isSubtypeOf(TypeRef<?> type) {
        return this.isSubtypeOf(type.getType());
    }

    public final boolean isSubtypeOf(Type supertype) {
        if (supertype instanceof WildcardType) {
            for (Type bound : ((WildcardType)supertype).getLowerBounds()) {
                if (!this.isSubtypeOf(bound)) continue;
                return true;
            }
            return false;
        }
        if (this.type instanceof WildcardType) {
            return TypeRef.anyTypeIsSubTypeOf(this.type, ((WildcardType)this.type).getUpperBounds());
        }
        if (this.type instanceof TypeVariable) {
            if (this.type.equals(supertype)) {
                return true;
            }
            return TypeRef.anyTypeIsSubTypeOf(this.type, ((TypeVariable)this.type).getBounds());
        }
        if (supertype instanceof Class) {
            return this.anyRawTypeIsSubclassOf((Class)supertype);
        }
        if (supertype instanceof ParameterizedType) {
            ParameterizedType parameterizedSuperType = (ParameterizedType)supertype;
            Class<T> matchedClass = TypeRef.of(parameterizedSuperType).getRawType();
            if (!this.anyRawTypeIsSubclassOf(matchedClass)) {
                return false;
            }
            TypeVariable<Class<T>>[] typeParameters = matchedClass.getTypeParameters();
            Type[] supertypeArgs = parameterizedSuperType.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                TypeVariable<Class<T>> typeParameter = typeParameters[i];
                Map<TypeVariableKey, Type> mappings = this.resolveTypeMappings();
                TypeRef<?> subtypeParam = this.resolveType0(typeParameter, mappings);
                if (super.is(supertypeArgs[i], typeParameter)) continue;
                return false;
            }
            if (Modifier.isStatic(((Class)parameterizedSuperType.getRawType()).getModifiers()) || parameterizedSuperType.getOwnerType() == null) {
                return true;
            }
            return this.collectTypes(this).anyMatch(type -> {
                if (type.type instanceof ParameterizedType) {
                    return TypeRef.of(((ParameterizedType)type.type).getOwnerType()).isSubtypeOf(supertype);
                }
                if (type.type instanceof Class) {
                    return TypeRef.of(((Class)type.type).getEnclosingClass()).isSubtypeOf(supertype);
                }
                return false;
            });
        }
        if (supertype instanceof GenericArrayType) {
            if (this.type instanceof Class) {
                Class fromClass = (Class)this.type;
                if (!fromClass.isArray()) {
                    return false;
                }
                return TypeRef.of(fromClass.getComponentType()).isSubtypeOf(((GenericArrayType)supertype).getGenericComponentType());
            }
            if (this.type instanceof GenericArrayType) {
                return TypeRef.of(((GenericArrayType)this.type).getGenericComponentType()).isSubtypeOf(((GenericArrayType)supertype).getGenericComponentType());
            }
            return false;
        }
        return false;
    }

    private Stream<TypeRef<?>> collectTypes(TypeRef<?> type) {
        return Stream.of(type).flatMap(t2 -> {
            Stream genericInterfacesTypeRefs = t2.getGenericInterfaces().flatMap(this::collectTypes);
            TypeRef<T> superclass = t2.getGenericSuperclass();
            return superclass == null ? genericInterfacesTypeRefs : Stream.concat(genericInterfacesTypeRefs, this.collectTypes(superclass));
        });
    }

    private Stream<? extends TypeRef<?>> getGenericInterfaces() {
        if (this.type instanceof TypeVariable) {
            return this.boundsAsInterfaces(((TypeVariable)this.type).getBounds());
        }
        if (this.type instanceof WildcardType) {
            return this.boundsAsInterfaces(((WildcardType)this.type).getUpperBounds());
        }
        Map<TypeVariableKey, Type> mappings = this.resolveTypeMappings();
        return Arrays.stream(this.getRawType().getGenericInterfaces()).map(interfaceType -> {
            TypeRef<?> resolvedInterface = this.resolveType0((Type)interfaceType, mappings);
            return resolvedInterface;
        });
    }

    private TypeRef<? super T> getGenericSuperclass() {
        if (this.type instanceof TypeVariable) {
            return this.boundAsSuperclass(((TypeVariable)this.type).getBounds()[0]);
        }
        if (this.type instanceof WildcardType) {
            return this.boundAsSuperclass(((WildcardType)this.type).getUpperBounds()[0]);
        }
        Type superclass = this.getRawType().getGenericSuperclass();
        if (superclass == null) {
            return null;
        }
        Map<TypeVariableKey, Type> mappings = this.resolveTypeMappings();
        TypeRef<?> superToken = this.resolveType0(superclass, mappings);
        return superToken;
    }

    private TypeRef<? super T> boundAsSuperclass(Type bound) {
        TypeRef<T> token = TypeRef.of(bound);
        if (token.getRawType().isInterface()) {
            return null;
        }
        TypeRef<T> superclass = token;
        return superclass;
    }

    private Stream<? extends TypeRef<?>> boundsAsInterfaces(Type[] bounds) {
        return Arrays.stream(bounds).map(TypeRef::of).filter(boundType -> boundType.getRawType().isInterface());
    }

    private boolean is(Type formalType, TypeVariable<?> declaration) {
        if (this.type.equals(formalType)) {
            return true;
        }
        if (formalType instanceof WildcardType) {
            WildcardType your = TypeRef.canonicalizeWildcardType(declaration, (WildcardType)formalType);
            for (Type bound : your.getUpperBounds()) {
                if (TypeRef.of(bound).isSupertypeOf(this.type)) continue;
                return false;
            }
            for (Type bound : your.getLowerBounds()) {
                if (TypeRef.of(bound).isSupertypeOf(this.type)) continue;
                return false;
            }
            return true;
        }
        return TypeRef.canonicalizeWildcardsInType(this.type).equals(TypeRef.canonicalizeWildcardsInType(formalType));
    }

    private static WildcardType canonicalizeWildcardType(TypeVariable<?> declaration, WildcardType type) {
        Type[] declared = declaration.getBounds();
        ArrayList<Type> upperBounds = new ArrayList<Type>();
        block0: for (Type bound : type.getUpperBounds()) {
            for (Type declaredType : declared) {
                if (TypeRef.of(declaredType).isSubtypeOf(bound)) continue block0;
            }
            upperBounds.add(TypeRef.canonicalizeWildcardsInType(bound));
        }
        return new WildcardTypeImpl(type.getLowerBounds(), upperBounds.toArray(new Type[0]));
    }

    private static Type canonicalizeWildcardsInType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeVars = rawType.getTypeParameters();
            Type[] typeArgs = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeArgs.length; ++i) {
                Type typeArg = typeArgs[i];
                typeArgs[i] = typeArg instanceof WildcardType ? TypeRef.canonicalizeWildcardType(typeVars[i], (WildcardType)typeArg) : TypeRef.canonicalizeWildcardsInType(typeArg);
            }
            return new ParameterizedTypeImpl(parameterizedType.getOwnerType(), rawType, typeArgs);
        }
        if (type instanceof GenericArrayType) {
            return TypeRef.newArrayType(TypeRef.canonicalizeWildcardsInType(((GenericArrayType)type).getGenericComponentType()));
        }
        return type;
    }

    private static boolean anyTypeIsSubTypeOf(Type upperBound, Type[] declared) {
        for (Type declaredType : declared) {
            if (!TypeRef.of(declaredType).isSubtypeOf(upperBound)) continue;
            return true;
        }
        return false;
    }

    private boolean anyRawTypeIsSubclassOf(Class<?> supertype) {
        return TypeRef.getRawTypes(this.type).anyMatch(supertype::isAssignableFrom);
    }

    public final boolean isSupertypeOf(Type type) {
        return this.isSupertypeOf(TypeRef.of(type));
    }

    public final boolean isSupertypeOf(TypeRef<?> type) {
        return type.isSubtypeOf(this.getType());
    }

    public final TypeRef<T> wrap() {
        if (this.isPrimitive()) {
            Class clazz = (Class)this.type;
            Class<?> wrapped = TypeUtils.wrap(clazz);
            return TypeRef.of(wrapped);
        }
        return this;
    }

    public final TypeRef<T> unwrap() {
        if (this.isWrapper()) {
            Class clazz = (Class)this.type;
            Class<?> unwrapped = TypeUtils.unwrap(clazz);
            return TypeRef.of(unwrapped);
        }
        return this;
    }

    public <X> TypeRef<T> where(TypeParameter<X> typeParam, Class<X> typeArg) {
        return this.where(typeParam, TypeRef.of(typeArg));
    }

    public final <X> TypeRef<T> where(TypeParameter<X> typeParam, TypeRef<X> typeArg) {
        if (this.type instanceof WildcardType) {
            return TypeRef.of(this.type);
        }
        TypeVariableKey typeVariableKey = new TypeVariableKey(typeParam.typeVariable);
        TypeRef<?> result = this.resolveType0(this.type, Collections.singletonMap(typeVariableKey, typeArg.type));
        return result;
    }

    private boolean isWrapper() {
        if (this.type instanceof Class) {
            return TypeUtils.isBoxed((Class)this.type);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof TypeRef) {
            TypeRef that = (TypeRef)o;
            return this.type.equals(that.type);
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return this.type instanceof Class ? ((Class)this.type).getName() : this.type.toString();
    }

    private static Class<?> getArrayClass(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    static Type newArrayType(Type componentType) {
        if (componentType instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)componentType;
            Type[] lowerBounds = wildcard.getLowerBounds();
            if (lowerBounds.length == 1) {
                return new WildcardTypeImpl(new Type[]{lowerBounds[0]}, new Type[]{Object.class});
            }
            Type[] upperBounds = wildcard.getUpperBounds();
            return new WildcardTypeImpl(new Type[0], new Type[]{upperBounds[0]});
        }
        return componentType instanceof Class ? Array.newInstance((Class)componentType, 0).getClass() : new GenericArrayTypeImpl(componentType);
    }

    static boolean typeVariablesEquals(TypeVariable<?> a, Object bobj) {
        if (bobj instanceof TypeVariable) {
            TypeVariable b = (TypeVariable)bobj;
            return a.getGenericDeclaration().equals(b.getGenericDeclaration()) && a.getName().equals(b.getName());
        }
        return false;
    }

    static TypeVariableKey asTypeVariableKeyOrNull(Type t2) {
        if (t2 instanceof TypeVariable) {
            return new TypeVariableKey((TypeVariable)t2);
        }
        return null;
    }

    private static Type getOwnerTypeFromRawType(Class<?> rawType) {
        return ClassOwnership.JVM_BEHAVIOR.getOwnerType(rawType);
    }

    private static String resolveTypeName(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    static String typeName(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    static class TypeVariableKey {
        private final TypeVariable<?> typeVariable;

        public TypeVariableKey(TypeVariable<?> typeVariable) {
            this.typeVariable = typeVariable;
        }

        public boolean equals(Object o) {
            return o instanceof TypeVariableKey && TypeRef.typeVariablesEquals(this.typeVariable, ((TypeVariableKey)o).typeVariable);
        }

        public int hashCode() {
            Object[] declaredAnnotations = this.typeVariable.getDeclaredAnnotations();
            String name = this.typeVariable.getName();
            int result = 1;
            result = 31 * result + (declaredAnnotations != null ? Arrays.hashCode(declaredAnnotations) : 0);
            result = 31 * result + (name != null ? name.hashCode() : 0);
            return result;
        }
    }

    static class TypeVariableImpl<D extends GenericDeclaration>
    implements TypeVariable<D> {
        private final D genericDeclaration;
        private final String name;
        private final Type[] upperBounds;

        TypeVariableImpl(D genericDeclaration, String name, Type[] upperBounds) {
            this.genericDeclaration = genericDeclaration;
            this.name = name;
            this.upperBounds = upperBounds;
        }

        @Override
        public Type[] getBounds() {
            return this.upperBounds;
        }

        @Override
        public D getGenericDeclaration() {
            return this.genericDeclaration;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public AnnotatedType[] getAnnotatedBounds() {
            return new AnnotatedType[0];
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return new Annotation[0];
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return new Annotation[0];
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TypeVariable)) {
                return false;
            }
            TypeVariable that = (TypeVariable)o;
            return Objects.equals(this.genericDeclaration, that.getGenericDeclaration()) && Objects.equals(this.name, that.getName()) && Arrays.equals(this.upperBounds, that.getBounds());
        }

        public int hashCode() {
            int result = this.genericDeclaration != null ? this.genericDeclaration.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + Arrays.hashCode(this.upperBounds);
            return result;
        }
    }

    static class WildcardTypeImpl
    implements WildcardType {
        private final Type[] upperBounds;
        private final Type[] lowerBounds;

        public WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            this.upperBounds = upperBounds;
            this.lowerBounds = lowerBounds;
        }

        @Override
        public Type[] getUpperBounds() {
            return this.upperBounds;
        }

        @Override
        public Type[] getLowerBounds() {
            return this.lowerBounds;
        }

        public boolean equals(@CheckForNull Object obj) {
            if (obj instanceof WildcardType) {
                WildcardType that = (WildcardType)obj;
                return Arrays.equals(this.lowerBounds, that.getLowerBounds()) && Arrays.equals(this.upperBounds, that.getUpperBounds());
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.lowerBounds) ^ Arrays.hashCode(this.upperBounds);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("?");
            for (Type lowerBound : this.lowerBounds) {
                builder.append(" super ").append(TypeRef.resolveTypeName(lowerBound));
            }
            for (Type upperBound : this.upperBounds) {
                if (upperBound.equals(Object.class)) continue;
                builder.append(" extends ").append(TypeRef.resolveTypeName(upperBound));
            }
            return builder.toString();
        }
    }

    static class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type genericComponentType;

        public GenericArrayTypeImpl(Type genericComponentType) {
            this.genericComponentType = genericComponentType;
        }

        @Override
        public Type getGenericComponentType() {
            return this.genericComponentType;
        }

        public String toString() {
            return TypeRef.resolveTypeName(this.genericComponentType) + "[]";
        }

        public int hashCode() {
            return this.genericComponentType.hashCode();
        }

        public boolean equals(@CheckForNull Object obj) {
            if (obj instanceof GenericArrayType) {
                GenericArrayType that = (GenericArrayType)obj;
                return Objects.equals(this.getGenericComponentType(), that.getGenericComponentType());
            }
            return false;
        }
    }

    static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type[] actualTypeArguments;
        private final Type rawType;
        private final Type ownerType;

        public ParameterizedTypeImpl(Type ownerType, Type rawType, Type[] actualTypeArguments) {
            this.ownerType = ownerType == null ? TypeRef.getOwnerTypeFromRawType((Class)rawType) : ownerType;
            this.rawType = rawType;
            this.actualTypeArguments = actualTypeArguments;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType that = (ParameterizedType)o;
            if (!Arrays.equals(this.actualTypeArguments, that.getActualTypeArguments())) {
                return false;
            }
            if (!Objects.equals(this.rawType, that.getRawType())) {
                return false;
            }
            return Objects.equals(this.ownerType, that.getOwnerType());
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.actualTypeArguments);
            result = 31 * result + (this.rawType != null ? this.rawType.hashCode() : 0);
            result = 31 * result + (this.ownerType != null ? this.ownerType.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(TypeRef.typeName(this.rawType)).append('<');
            int i = 0;
            for (Type typeArgument : this.actualTypeArguments) {
                if (i++ != 0) {
                    builder.append(", ");
                }
                builder.append(TypeRef.typeName(typeArgument));
            }
            return builder.append('>').toString();
        }
    }

    private static enum ClassOwnership {
        OWNED_BY_ENCLOSING_CLASS{

            @Override
            Class<?> getOwnerType(Class<?> rawType) {
                return rawType.getEnclosingClass();
            }
        }
        ,
        LOCAL_CLASS_HAS_NO_OWNER{

            @Override
            Class<?> getOwnerType(Class<?> rawType) {
                return rawType.isLocalClass() ? null : rawType.getEnclosingClass();
            }
        };

        static final ClassOwnership JVM_BEHAVIOR;

        abstract Class<?> getOwnerType(Class<?> var1);

        private static ClassOwnership detectJvmBehaviour() {
            class LocalClass<T> {
                LocalClass() {
                }
            }
            LocalClass<String> localClassInstance = new LocalClass<String>(){
                {
                }
            };
            Class<?> subclass = localClassInstance.getClass();
            ParameterizedType parameterizedType = (ParameterizedType)subclass.getGenericSuperclass();
            for (ClassOwnership behavior : ClassOwnership.values()) {
                if (behavior.getOwnerType(LocalClass.class) != parameterizedType.getOwnerType()) continue;
                return behavior;
            }
            throw new AssertionError();
        }

        static {
            JVM_BEHAVIOR = ClassOwnership.detectJvmBehaviour();
        }
    }

    private static class WildcardCapturer {
        private static final WildcardCapturer INSTANCE = new WildcardCapturer();

        private WildcardCapturer() {
        }

        static Type capture(Type type) {
            return INSTANCE.capture0(type);
        }

        final Type capture0(Type type) {
            if (type instanceof Class) {
                return type;
            }
            if (type instanceof TypeVariable) {
                return type;
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)((Object)type);
                return TypeRef.newArrayType(this.capture0(arrayType.getGenericComponentType()));
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)((Object)type);
                Class rawType = (Class)parameterizedType.getRawType();
                TypeVariable<Class<T>>[] typeVars = rawType.getTypeParameters();
                Type[] typeArgs = parameterizedType.getActualTypeArguments();
                for (int i = 0; i < typeArgs.length; ++i) {
                    typeArgs[i] = this.forTypeVariable(typeVars[i]).capture0(typeArgs[i]);
                }
                Type ownerType = parameterizedType.getOwnerType();
                return new ParameterizedTypeImpl(ownerType == null ? null : this.capture0(ownerType), rawType, typeArgs);
            }
            if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)((Object)type);
                Type[] lowerBounds = wildcardType.getLowerBounds();
                return lowerBounds.length == 0 ? this.captureAsTypeVariable(wildcardType.getUpperBounds()) : type;
            }
            throw new AssertionError((Object)"must have been one of the known types");
        }

        TypeVariable<?> captureAsTypeVariable(Type[] upperBounds) {
            String name = "capture of ? extends " + Stream.of(upperBounds).map(Object::toString).collect(Collectors.joining("&"));
            return new TypeVariableImpl<Class<WildcardCapturer>>(WildcardCapturer.class, name, upperBounds);
        }

        private WildcardCapturer forTypeVariable(final TypeVariable<?> typeParam) {
            return new WildcardCapturer(){

                @Override
                TypeVariable<?> captureAsTypeVariable(Type[] upperBounds) {
                    Type[] typeParamBounds = typeParam.getBounds();
                    Type[] combinedUpperBounds = upperBounds;
                    if (typeParamBounds.length > 0) {
                        int i;
                        int upperBoundsLength = upperBounds.length;
                        combinedUpperBounds = new Type[typeParamBounds.length + upperBoundsLength];
                        for (i = 0; i < upperBoundsLength; ++i) {
                            combinedUpperBounds[i] = upperBounds[i];
                        }
                        int skipCount = 0;
                        while (i < combinedUpperBounds.length) {
                            block6: {
                                Type typeParamBound = typeParamBounds[i - upperBoundsLength];
                                for (Type upperBound : upperBounds) {
                                    if (!upperBound.equals(typeParamBound)) continue;
                                    ++skipCount;
                                    break block6;
                                }
                                combinedUpperBounds[i] = typeParamBound;
                            }
                            ++i;
                        }
                        if (skipCount > 0) {
                            i = upperBoundsLength;
                            while (combinedUpperBounds[i] == null && i != combinedUpperBounds.length - 1) {
                                combinedUpperBounds[i] = combinedUpperBounds[i++];
                            }
                            combinedUpperBounds = Arrays.copyOf(combinedUpperBounds, combinedUpperBounds.length - skipCount);
                        }
                    }
                    return super.captureAsTypeVariable(combinedUpperBounds);
                }
            };
        }
    }
}

