/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.resolver;

import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Tuple2;
import me.mrnavastar.protoweaver.libs.org.apache.fury.config.Language;
import me.mrnavastar.protoweaver.libs.org.apache.fury.meta.ClassDef;
import me.mrnavastar.protoweaver.libs.org.apache.fury.meta.Encoders;
import me.mrnavastar.protoweaver.libs.org.apache.fury.meta.MetaString;
import me.mrnavastar.protoweaver.libs.org.apache.fury.reflect.ReflectionUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.ClassResolver;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.MetaStringBytes;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.MetaStringResolver;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.function.Functions;

public class ClassInfo {
    final Class<?> cls;
    final MetaStringBytes fullClassNameBytes;
    final MetaStringBytes packageNameBytes;
    final MetaStringBytes classNameBytes;
    final boolean isDynamicGeneratedClass;
    final MetaStringBytes typeTagBytes;
    Serializer<?> serializer;
    short classId;
    ClassDef classDef;
    boolean needToWriteClassDef;

    ClassInfo(Class<?> cls, MetaStringBytes fullClassNameBytes, MetaStringBytes packageNameBytes, MetaStringBytes classNameBytes, boolean isDynamicGeneratedClass, MetaStringBytes typeTagBytes, Serializer<?> serializer, short classId) {
        this.cls = cls;
        this.fullClassNameBytes = fullClassNameBytes;
        this.packageNameBytes = packageNameBytes;
        this.classNameBytes = classNameBytes;
        this.isDynamicGeneratedClass = isDynamicGeneratedClass;
        this.typeTagBytes = typeTagBytes;
        this.serializer = serializer;
        this.classId = classId;
        if (cls != null && classId == 0) {
            Preconditions.checkArgument(classNameBytes != null);
        }
    }

    ClassInfo(ClassResolver classResolver, Class<?> cls, String tag, Serializer<?> serializer, short classId) {
        this.cls = cls;
        this.serializer = serializer;
        this.needToWriteClassDef = serializer != null && classResolver.needToWriteClassDef(serializer);
        MetaStringResolver metaStringResolver = classResolver.getMetaStringResolver();
        this.fullClassNameBytes = cls != null && classResolver.getFury().getLanguage() != Language.JAVA ? metaStringResolver.getOrCreateMetaStringBytes(Encoders.GENERIC_ENCODER.encode(cls.getName(), MetaString.Encoding.UTF_8)) : null;
        if (cls != null && (classId == 0 || classId == 3)) {
            Tuple2<String, String> tuple2 = Encoders.encodePkgAndClass(cls);
            this.packageNameBytes = metaStringResolver.getOrCreateMetaStringBytes(Encoders.encodePackage((String)tuple2.f0));
            this.classNameBytes = metaStringResolver.getOrCreateMetaStringBytes(Encoders.encodeTypeName((String)tuple2.f1));
        } else {
            this.packageNameBytes = null;
            this.classNameBytes = null;
        }
        this.typeTagBytes = tag != null ? metaStringResolver.getOrCreateMetaStringBytes(Encoders.PACKAGE_ENCODER.encode(tag, MetaString.Encoding.UTF_8)) : null;
        this.classId = classId;
        if (cls != null) {
            boolean isLambda = Functions.isLambda(cls);
            boolean isProxy = classId != 3 && ReflectionUtils.isJdkProxy(cls);
            boolean bl = this.isDynamicGeneratedClass = isLambda || isProxy;
            if (isLambda) {
                this.classId = 1;
            }
            if (isProxy) {
                this.classId = (short)2;
            }
        } else {
            this.isDynamicGeneratedClass = false;
        }
    }

    public Class<?> getCls() {
        return this.cls;
    }

    public short getClassId() {
        return this.classId;
    }

    public MetaStringBytes getPackageNameBytes() {
        return this.packageNameBytes;
    }

    public MetaStringBytes getClassNameBytes() {
        return this.classNameBytes;
    }

    public <T> Serializer<T> getSerializer() {
        return this.serializer;
    }

    void setSerializer(ClassResolver resolver, Serializer<?> serializer) {
        this.serializer = serializer;
        this.needToWriteClassDef = serializer != null && resolver.needToWriteClassDef(serializer);
    }

    public String toString() {
        return "ClassInfo{cls=" + this.cls + ", fullClassNameBytes=" + this.fullClassNameBytes + ", isDynamicGeneratedClass=" + this.isDynamicGeneratedClass + ", serializer=" + this.serializer + ", classId=" + this.classId + '}';
    }
}

