/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.resolver;

import java.util.IdentityHashMap;
import me.mrnavastar.protoweaver.libs.org.apache.fury.config.Config;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.MetaContext;

public final class SerializationContext {
    private final IdentityHashMap<Object, Object> objects = new IdentityHashMap();
    private final boolean scopedMetaShareEnabled;
    private MetaContext metaContext;

    public SerializationContext(Config config) {
        this.scopedMetaShareEnabled = config.isScopedMetaShareEnabled();
        if (this.scopedMetaShareEnabled) {
            this.metaContext = new MetaContext();
        }
    }

    public Object add(Object key, Object value) {
        return this.objects.put(key, value);
    }

    public boolean containsKey(Object key) {
        return this.objects.containsKey(key);
    }

    public Object get(Object key) {
        return this.objects.get(key);
    }

    public MetaContext getMetaContext() {
        return this.metaContext;
    }

    public void setMetaContext(MetaContext metaContext) {
        assert (!this.scopedMetaShareEnabled);
        this.metaContext = metaContext;
    }

    public void resetWrite() {
        if (!this.objects.isEmpty()) {
            this.objects.clear();
        }
        if (this.scopedMetaShareEnabled) {
            this.metaContext.classMap.clear();
            this.metaContext.writingClassDefs.size = 0;
        } else {
            this.metaContext = null;
        }
    }

    public void resetRead() {
        if (!this.objects.isEmpty()) {
            this.objects.clear();
        }
        if (this.scopedMetaShareEnabled) {
            this.metaContext.readClassInfos.size = 0;
            this.metaContext.readClassDefs.size = 0;
        } else {
            this.metaContext = null;
        }
    }

    public void reset() {
        if (!this.objects.isEmpty()) {
            this.objects.clear();
        }
        if (this.scopedMetaShareEnabled) {
            this.metaContext.classMap.clear();
            this.metaContext.writingClassDefs.size = 0;
            this.metaContext.readClassInfos.size = 0;
            this.metaContext.readClassDefs.size = 0;
        } else {
            this.metaContext = null;
        }
    }
}

