/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.serializer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.MemoryBuffer;

public interface BufferObject {
    public int totalBytes();

    public void writeTo(MemoryBuffer var1);

    public MemoryBuffer toBuffer();

    public static final class ByteBufferBufferObject
    implements BufferObject {
        private final ByteBuffer buffer;

        public ByteBufferBufferObject(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public int totalBytes() {
            return this.buffer.remaining() + 1;
        }

        @Override
        public void writeTo(MemoryBuffer buffer) {
            buffer.write(this.buffer.duplicate());
            buffer.writeByte(this.buffer.order() == ByteOrder.BIG_ENDIAN ? (byte)1 : 0);
        }

        @Override
        public MemoryBuffer toBuffer() {
            MemoryBuffer buffer = MemoryBuffer.newHeapBuffer(this.totalBytes());
            this.writeTo(buffer);
            return buffer.slice(0, buffer.writerIndex());
        }
    }
}

