/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.serializer;

import java.lang.reflect.Modifier;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.builder.CodecUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.builder.Generated;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.MemoryBuffer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.AbstractObjectSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializers;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;

public final class CodegenSerializer {
    public static boolean supportCodegenForJavaSerialization(Class<?> cls) {
        try {
            return cls.getEnclosingClass() == null || Modifier.isStatic(cls.getModifiers());
        }
        catch (Throwable t2) {
            throw new RuntimeException(t2);
        }
    }

    public static <T> Class<Serializer<T>> loadCodegenSerializer(Fury fury, Class<T> cls) {
        try {
            return CodecUtils.loadOrGenObjectCodecClass(cls, fury);
        }
        catch (Exception e) {
            String msg = String.format("Create sequential serializer failed, \nclass: %s", cls);
            throw new RuntimeException(msg, e);
        }
    }

    public static <T> Class<Serializer<T>> loadCompatibleCodegenSerializer(Fury fury, Class<T> cls) {
        try {
            return CodecUtils.loadOrGenCompatibleCodecClass(cls, fury);
        }
        catch (Exception e) {
            String msg = String.format("Create compatible serializer failed, \nclass: %s", cls);
            throw new RuntimeException(msg, e);
        }
    }

    public static final class LazyInitBeanSerializer<T>
    extends AbstractObjectSerializer<T> {
        private Serializer<T> serializer;
        private Serializer<T> interpreterSerializer;

        public LazyInitBeanSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.getOrCreateGeneratedSerializer().write(buffer, value);
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return this.getOrCreateGeneratedSerializer().read(buffer);
        }

        private Serializer<T> getOrCreateGeneratedSerializer() {
            if (this.serializer == null) {
                Serializer jitSerializer = this.fury.getClassResolver().getSerializer(this.type);
                if (jitSerializer instanceof LazyInitBeanSerializer) {
                    if (this.interpreterSerializer != null) {
                        return this.interpreterSerializer;
                    }
                    if (this.fury.getConfig().isAsyncCompilationEnabled()) {
                        Class<? extends Serializer> sc = this.fury.getClassResolver().getSerializerClass(this.type, false);
                        this.interpreterSerializer = Serializers.newSerializer(this.fury, this.type, sc);
                        return this.interpreterSerializer;
                    }
                    Class<? extends Serializer> sc = this.fury.getClassResolver().getSerializerClass(this.type);
                    Preconditions.checkArgument(Generated.GeneratedSerializer.class.isAssignableFrom(sc), "Expect jit serializer but got %s for class %s", sc, this.type);
                    this.serializer = Serializers.newSerializer(this.fury, this.type, sc);
                    this.fury.getClassResolver().setSerializer(this.type, this.serializer);
                    return this.serializer;
                }
                this.serializer = jitSerializer;
            }
            return this.serializer;
        }
    }
}

