/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.serializer;

import java.io.Externalizable;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.io.MemoryBufferObjectInput;
import me.mrnavastar.protoweaver.libs.org.apache.fury.io.MemoryBufferObjectOutput;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.MemoryBuffer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.Platform;
import me.mrnavastar.protoweaver.libs.org.apache.fury.reflect.ReflectionUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.AbstractObjectSerializer;

public class ExternalizableSerializer<T extends Externalizable>
extends AbstractObjectSerializer<T> {
    private final MethodHandle constructor;
    private final MemoryBufferObjectInput objectInput;
    private final MemoryBufferObjectOutput objectOutput;

    public ExternalizableSerializer(Fury fury, Class<T> cls) {
        super(fury, cls);
        this.constructor = ReflectionUtils.getCtrHandle(cls, false);
        this.objectInput = new MemoryBufferObjectInput(fury, null);
        this.objectOutput = new MemoryBufferObjectOutput(fury, null);
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        this.objectOutput.setBuffer(buffer);
        try {
            value.writeExternal(this.objectOutput);
        }
        catch (IOException e) {
            Platform.throwException(e);
        }
    }

    @Override
    public void xwrite(MemoryBuffer buffer, T value) {
        throw new UnsupportedOperationException("Externalizable can only be used in java");
    }

    @Override
    public T read(MemoryBuffer buffer) {
        Externalizable t2;
        if (this.constructor != null) {
            try {
                t2 = this.constructor.invoke();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        } else {
            t2 = (Externalizable)Platform.newInstance(this.type);
        }
        this.objectInput.setBuffer(buffer);
        try {
            t2.readExternal(this.objectInput);
        }
        catch (IOException | ClassNotFoundException e) {
            Platform.throwException(e);
        }
        return (T)t2;
    }
}

