/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.serializer;

import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Objects;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.MemoryBuffer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.reflect.ReflectionUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.CodegenSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.JavaSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.ObjectSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializers;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;

public class LambdaSerializer
extends Serializer {
    private static final Class<SerializedLambda> SERIALIZED_LAMBDA = SerializedLambda.class;
    private static final Method READ_RESOLVE_METHOD = (Method)Objects.requireNonNull(ReflectionUtils.getObjectFieldValue((Object)ObjectStreamClass.lookup(SERIALIZED_LAMBDA), "readResolveMethod"));
    private static final boolean SERIALIZED_LAMBDA_HAS_JDK_WRITE = JavaSerializer.getWriteObjectMethod(SERIALIZED_LAMBDA) != null;
    private static final boolean SERIALIZED_LAMBDA_HAS_JDK_READ = JavaSerializer.getReadObjectMethod(SERIALIZED_LAMBDA) != null;
    private final Method writeReplaceMethod;
    private Serializer dataSerializer;

    public LambdaSerializer(Fury fury, Class cls) {
        super(fury, cls);
        if (cls != ReplaceStub.class) {
            if (!Serializable.class.isAssignableFrom(cls)) {
                String msg = String.format("Lambda %s needs to implement %s for serialization", cls, Serializable.class.getName());
                throw new UnsupportedOperationException(msg);
            }
            this.writeReplaceMethod = (Method)ReflectionUtils.getObjectFieldValue((Object)ObjectStreamClass.lookup(cls), "writeReplaceMethod");
        } else {
            this.writeReplaceMethod = null;
        }
    }

    public void write(MemoryBuffer buffer, Object value) {
        assert (value.getClass() != ReplaceStub.class);
        try {
            Object replacement = this.writeReplaceMethod.invoke(value, new Object[0]);
            Preconditions.checkArgument(SERIALIZED_LAMBDA.isInstance(replacement));
            this.getDataSerializer().write(buffer, replacement);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't serialize lambda " + value, e);
        }
    }

    public Object copy(Object value) {
        try {
            Object replacement = this.writeReplaceMethod.invoke(value, new Object[0]);
            Object newReplacement = this.getDataSerializer().copy(replacement);
            return READ_RESOLVE_METHOD.invoke(newReplacement, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't copy lambda " + value, e);
        }
    }

    public Object read(MemoryBuffer buffer) {
        try {
            Object replacement = this.getDataSerializer().read(buffer);
            return READ_RESOLVE_METHOD.invoke(replacement, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't deserialize lambda", e);
        }
    }

    private Serializer getDataSerializer() {
        Serializer dataSerializer = this.dataSerializer;
        if (dataSerializer == null) {
            Class sc = SERIALIZED_LAMBDA_HAS_JDK_WRITE || SERIALIZED_LAMBDA_HAS_JDK_READ ? this.fury.getDefaultJDKStreamSerializerType() : this.fury.getJITContext().registerSerializerJITCallback(() -> ObjectSerializer.class, () -> CodegenSerializer.loadCodegenSerializer(this.fury, SERIALIZED_LAMBDA), c -> {
                this.dataSerializer = Serializers.newSerializer(this.fury, SERIALIZED_LAMBDA, c);
                this.fury.getClassResolver().clearSerializer(SERIALIZED_LAMBDA);
            });
            this.dataSerializer = dataSerializer = Serializers.newSerializer(this.fury, SERIALIZED_LAMBDA, sc);
            this.fury.getClassResolver().clearSerializer(SERIALIZED_LAMBDA);
        }
        return dataSerializer;
    }

    public static class ReplaceStub {
    }
}

