/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.serializer;

import java.util.ArrayList;
import java.util.Collection;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.IdentityObjectIntMap;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.LongMap;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.MapEntry;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Tuple2;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Tuple3;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.MemoryBuffer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.meta.ClassDef;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.ClassInfo;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.ClassInfoHolder;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.ClassResolver;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.MetaContext;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.MetaStringResolver;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.RefResolver;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.AbstractObjectSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.ArraySerializers;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.CompatibleSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.MetaSharedSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.NonexistentClass;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.ObjectSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.type.Descriptor;
import me.mrnavastar.protoweaver.libs.org.apache.fury.type.DescriptorGrouper;
import me.mrnavastar.protoweaver.libs.org.apache.fury.type.Generics;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;

public final class NonexistentClassSerializers {
    public static Serializer getSerializer(Fury fury, String className, Class<?> cls) {
        if (cls.isArray()) {
            return new ArraySerializers.NonexistentArrayClassSerializer(fury, className, cls);
        }
        if (cls.isEnum()) {
            return new NonexistentEnumClassSerializer(fury);
        }
        if (fury.getConfig().isMetaShareEnabled()) {
            throw new IllegalStateException(String.format("Serializer of class %s should be set in ClassResolver#getMetaSharedClassInfo", className));
        }
        return new CompatibleSerializer(fury, cls);
    }

    public static final class NonexistentEnumClassSerializer
    extends Serializer {
        private final NonexistentClass.NonexistentEnum[] enumConstants;
        private final MetaStringResolver metaStringResolver;

        public NonexistentEnumClassSerializer(Fury fury) {
            super(fury, NonexistentClass.NonexistentEnum.class);
            this.metaStringResolver = fury.getMetaStringResolver();
            this.enumConstants = (NonexistentClass.NonexistentEnum[])NonexistentClass.NonexistentEnum.class.getEnumConstants();
        }

        public Object read(MemoryBuffer buffer) {
            if (this.fury.getConfig().serializeEnumByName()) {
                this.metaStringResolver.readMetaStringBytes(buffer);
                return NonexistentClass.NonexistentEnum.UNKNOWN;
            }
            int ordinal = buffer.readVarUint32Small7();
            if (ordinal >= this.enumConstants.length) {
                ordinal = this.enumConstants.length - 1;
            }
            return this.enumConstants[ordinal];
        }
    }

    public static final class NonexistentClassSerializer
    extends Serializer {
        private final ClassDef classDef;
        private final ClassInfoHolder classInfoHolder;
        private final LongMap<ClassFieldsInfo> fieldsInfoMap;

        public NonexistentClassSerializer(Fury fury, ClassDef classDef) {
            super(fury, NonexistentClass.NonexistentMetaShared.class);
            this.classDef = classDef;
            this.classInfoHolder = fury.getClassResolver().nilClassInfoHolder();
            this.fieldsInfoMap = new LongMap();
            Preconditions.checkArgument(fury.getConfig().isMetaShareEnabled());
        }

        private void writeClassDef(MemoryBuffer buffer, NonexistentClass.NonexistentMetaShared value) {
            buffer.increaseWriterIndex(-2);
            MetaContext metaContext = this.fury.getSerializationContext().getMetaContext();
            IdentityObjectIntMap<Class<?>> classMap = metaContext.classMap;
            int newId = classMap.size;
            int id = classMap.putOrGet((Class<?>)value.classDef.getId(), newId);
            if (id >= 0) {
                buffer.writeVarUint32(id << 1 | 1);
            } else {
                buffer.writeVarUint32(newId << 1 | 1);
                metaContext.writingClassDefs.add(value.classDef);
            }
        }

        public void write(MemoryBuffer buffer, Object v) {
            NonexistentClass.NonexistentMetaShared value = (NonexistentClass.NonexistentMetaShared)v;
            this.writeClassDef(buffer, value);
            ClassDef classDef = value.classDef;
            ClassFieldsInfo fieldsInfo = this.getClassFieldsInfo(classDef);
            Fury fury = this.fury;
            RefResolver refResolver = fury.getRefResolver();
            ClassResolver classResolver = fury.getClassResolver();
            if (fury.checkClassVersion()) {
                buffer.writeInt32(fieldsInfo.classVersionHash);
            }
            AbstractObjectSerializer.FinalTypeField[] finalFields = fieldsInfo.finalFields;
            boolean[] isFinal = fieldsInfo.isFinal;
            for (int i = 0; i < finalFields.length; ++i) {
                AbstractObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
                Object fieldValue = value.get(fieldInfo.qualifiedFieldName);
                ClassInfo classInfo = fieldInfo.classInfo;
                if (classResolver.isPrimitive(fieldInfo.classId)) {
                    classInfo.getSerializer().write(buffer, fieldValue);
                    continue;
                }
                if (isFinal[i]) {
                    Serializer serializer = classInfo.getSerializer();
                    fury.writeRef(buffer, fieldValue, serializer);
                    continue;
                }
                fury.writeRef(buffer, fieldValue, classInfo);
            }
            for (AbstractObjectSerializer.GenericTypeField fieldInfo : fieldsInfo.otherFields) {
                Object fieldValue = value.get(fieldInfo.qualifiedFieldName);
                if (fieldInfo.trackingRef) {
                    fury.writeRef(buffer, fieldValue, fieldInfo.classInfoHolder);
                    continue;
                }
                fury.writeNullable(buffer, fieldValue, fieldInfo.classInfoHolder);
            }
            Generics generics = fury.getGenerics();
            for (AbstractObjectSerializer.GenericTypeField fieldInfo : fieldsInfo.containerFields) {
                Object fieldValue = value.get(fieldInfo.qualifiedFieldName);
                ObjectSerializer.writeContainerFieldValue(fury, refResolver, classResolver, generics, fieldInfo, buffer, fieldValue);
            }
        }

        private ClassFieldsInfo getClassFieldsInfo(ClassDef classDef) {
            ClassFieldsInfo fieldsInfo = this.fieldsInfoMap.get(classDef.getId());
            if (fieldsInfo == null) {
                Collection<Descriptor> descriptors = MetaSharedSerializer.consolidateFields(this.fury.getClassResolver(), NonexistentClass.NonexistentSkip.class, classDef);
                DescriptorGrouper descriptorGrouper = DescriptorGrouper.createDescriptorGrouper(this.fury.getClassResolver()::isMonomorphic, descriptors, false, this.fury.compressInt(), this.fury.compressLong());
                Tuple3<Tuple2<AbstractObjectSerializer.FinalTypeField[], boolean[]>, AbstractObjectSerializer.GenericTypeField[], AbstractObjectSerializer.GenericTypeField[]> tuple = AbstractObjectSerializer.buildFieldInfos(this.fury, descriptorGrouper);
                int classVersionHash = 0;
                if (this.fury.checkClassVersion()) {
                    classVersionHash = ObjectSerializer.computeVersionHash(descriptors);
                }
                fieldsInfo = new ClassFieldsInfo((AbstractObjectSerializer.FinalTypeField[])((Tuple2)tuple.f0).f0, (boolean[])((Tuple2)tuple.f0).f1, (AbstractObjectSerializer.GenericTypeField[])tuple.f1, (AbstractObjectSerializer.GenericTypeField[])tuple.f2, classVersionHash);
                this.fieldsInfoMap.put(classDef.getId(), fieldsInfo);
            }
            return fieldsInfo;
        }

        public Object read(MemoryBuffer buffer) {
            NonexistentClass.NonexistentMetaShared obj = new NonexistentClass.NonexistentMetaShared(this.classDef);
            Fury fury = this.fury;
            RefResolver refResolver = fury.getRefResolver();
            ClassResolver classResolver = fury.getClassResolver();
            refResolver.reference(obj);
            ArrayList entries = new ArrayList();
            ClassFieldsInfo fieldsInfo = this.getClassFieldsInfo(this.classDef);
            AbstractObjectSerializer.FinalTypeField[] finalFields = fieldsInfo.finalFields;
            boolean[] isFinal = fieldsInfo.isFinal;
            for (int i = 0; i < finalFields.length; ++i) {
                AbstractObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
                Object fieldValue = fieldInfo.classInfo == null ? fury.readRef(buffer, this.classInfoHolder) : (classResolver.isPrimitive(fieldInfo.classId) ? fieldInfo.classInfo.getSerializer().read(buffer) : ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal[i], buffer));
                entries.add(new MapEntry<String, Object>(fieldInfo.qualifiedFieldName, fieldValue));
            }
            for (AbstractObjectSerializer.GenericTypeField fieldInfo : fieldsInfo.otherFields) {
                Object fieldValue = ObjectSerializer.readOtherFieldValue(fury, fieldInfo, buffer);
                entries.add(new MapEntry<String, Object>(fieldInfo.qualifiedFieldName, fieldValue));
            }
            Generics generics = fury.getGenerics();
            for (AbstractObjectSerializer.GenericTypeField fieldInfo : fieldsInfo.containerFields) {
                Object fieldValue = ObjectSerializer.readContainerFieldValue(fury, generics, fieldInfo, buffer);
                entries.add(new MapEntry<String, Object>(fieldInfo.qualifiedFieldName, fieldValue));
            }
            obj.setEntries(entries);
            return obj;
        }
    }

    private static final class ClassFieldsInfo {
        private final AbstractObjectSerializer.FinalTypeField[] finalFields;
        private final boolean[] isFinal;
        private final AbstractObjectSerializer.GenericTypeField[] otherFields;
        private final AbstractObjectSerializer.GenericTypeField[] containerFields;
        private final int classVersionHash;

        private ClassFieldsInfo(AbstractObjectSerializer.FinalTypeField[] finalFields, boolean[] isFinal, AbstractObjectSerializer.GenericTypeField[] otherFields, AbstractObjectSerializer.GenericTypeField[] containerFields, int classVersionHash) {
            this.finalFields = finalFields;
            this.isFinal = isFinal;
            this.otherFields = otherFields;
            this.containerFields = containerFields;
            this.classVersionHash = classVersionHash;
        }
    }
}

