/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.serializer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Tuple2;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Tuple3;
import me.mrnavastar.protoweaver.libs.org.apache.fury.exception.FuryException;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.MemoryBuffer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.Platform;
import me.mrnavastar.protoweaver.libs.org.apache.fury.meta.ClassDef;
import me.mrnavastar.protoweaver.libs.org.apache.fury.reflect.FieldAccessor;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.ClassInfo;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.ClassResolver;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.RefResolver;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.AbstractObjectSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializers;
import me.mrnavastar.protoweaver.libs.org.apache.fury.type.Descriptor;
import me.mrnavastar.protoweaver.libs.org.apache.fury.type.DescriptorGrouper;
import me.mrnavastar.protoweaver.libs.org.apache.fury.type.Generics;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.record.RecordInfo;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.record.RecordUtils;

public final class ObjectSerializer<T>
extends AbstractObjectSerializer<T> {
    private final RecordInfo recordInfo;
    private final AbstractObjectSerializer.FinalTypeField[] finalFields;
    private final boolean[] isFinal;
    private final AbstractObjectSerializer.GenericTypeField[] otherFields;
    private final AbstractObjectSerializer.GenericTypeField[] containerFields;
    private final int classVersionHash;

    public ObjectSerializer(Fury fury, Class<T> cls) {
        this(fury, cls, true);
    }

    public ObjectSerializer(Fury fury, Class<T> cls, boolean resolveParent) {
        super(fury, cls);
        Collection<Descriptor> descriptors;
        boolean shareMeta;
        if (resolveParent) {
            this.classResolver.setSerializerIfAbsent(cls, this);
        }
        if (shareMeta = fury.getConfig().isMetaShareEnabled()) {
            ClassDef classDef = this.classResolver.getClassDef(cls, resolveParent);
            descriptors = classDef.getDescriptors(this.classResolver, cls);
        } else {
            descriptors = fury.getClassResolver().getAllDescriptorsMap(cls, resolveParent).values();
        }
        DescriptorGrouper descriptorGrouper = DescriptorGrouper.createDescriptorGrouper(fury.getClassResolver()::isMonomorphic, descriptors, false, fury.compressInt(), fury.compressLong());
        if (this.isRecord) {
            List<String> fieldNames = descriptorGrouper.getSortedDescriptors().stream().map(Descriptor::getName).collect(Collectors.toList());
            this.recordInfo = new RecordInfo(cls, fieldNames);
        } else {
            this.recordInfo = null;
        }
        this.classVersionHash = fury.checkClassVersion() ? ObjectSerializer.computeVersionHash(descriptors) : 0;
        Tuple3<Tuple2<AbstractObjectSerializer.FinalTypeField[], boolean[]>, AbstractObjectSerializer.GenericTypeField[], AbstractObjectSerializer.GenericTypeField[]> infos = ObjectSerializer.buildFieldInfos(fury, descriptorGrouper);
        this.finalFields = (AbstractObjectSerializer.FinalTypeField[])((Tuple2)infos.f0).f0;
        this.isFinal = (boolean[])((Tuple2)infos.f0).f1;
        this.otherFields = (AbstractObjectSerializer.GenericTypeField[])infos.f1;
        this.containerFields = (AbstractObjectSerializer.GenericTypeField[])infos.f2;
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        Fury fury = this.fury;
        RefResolver refResolver = this.refResolver;
        ClassResolver classResolver = this.classResolver;
        if (fury.checkClassVersion()) {
            buffer.writeInt32(this.classVersionHash);
        }
        this.writeFinalFields(buffer, value, fury, refResolver, classResolver);
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.otherFields) {
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            Object fieldValue = fieldAccessor.getObject(value);
            if (fieldInfo.trackingRef) {
                fury.writeRef(buffer, fieldValue, fieldInfo.classInfoHolder);
                continue;
            }
            fury.writeNullable(buffer, fieldValue, fieldInfo.classInfoHolder);
        }
        this.writeContainerFields(buffer, value, fury, refResolver, classResolver);
    }

    private void writeFinalFields(MemoryBuffer buffer, T value, Fury fury, RefResolver refResolver, ClassResolver classResolver) {
        AbstractObjectSerializer.FinalTypeField[] finalFields = this.finalFields;
        boolean metaShareEnabled = fury.getConfig().isMetaShareEnabled();
        for (int i = 0; i < finalFields.length; ++i) {
            Object fieldValue;
            AbstractObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            short classId = fieldInfo.classId;
            if (!ObjectSerializer.writePrimitiveFieldValueFailed(fury, buffer, value, fieldAccessor, classId) || !ObjectSerializer.writeBasicObjectFieldValueFailed(fury, buffer, fieldValue = fieldAccessor.getObject(value), classId)) continue;
            Serializer<Object> serializer = fieldInfo.classInfo.getSerializer();
            if (!metaShareEnabled || this.isFinal[i]) {
                if (!fieldInfo.trackingRef) {
                    fury.writeNullable(buffer, fieldValue, serializer);
                    continue;
                }
                fury.writeRef(buffer, fieldValue, serializer);
                continue;
            }
            if (fieldInfo.trackingRef && serializer.needToWriteRef()) {
                if (refResolver.writeRefOrNull(buffer, fieldValue)) continue;
                classResolver.writeClass(buffer, fieldInfo.classInfo);
                serializer.write(buffer, fieldValue);
                continue;
            }
            fury.writeNullable(buffer, fieldValue, fieldInfo.classInfo);
        }
    }

    private void writeContainerFields(MemoryBuffer buffer, T value, Fury fury, RefResolver refResolver, ClassResolver classResolver) {
        Generics generics = fury.getGenerics();
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.containerFields) {
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            Object fieldValue = fieldAccessor.getObject(value);
            ObjectSerializer.writeContainerFieldValue(fury, refResolver, classResolver, generics, fieldInfo, buffer, fieldValue);
        }
    }

    static void writeContainerFieldValue(Fury fury, RefResolver refResolver, ClassResolver classResolver, Generics generics, AbstractObjectSerializer.GenericTypeField fieldInfo, MemoryBuffer buffer, Object fieldValue) {
        if (fieldInfo.trackingRef) {
            if (!refResolver.writeRefOrNull(buffer, fieldValue)) {
                ClassInfo classInfo = classResolver.getClassInfo(fieldValue.getClass(), fieldInfo.classInfoHolder);
                generics.pushGenericType(fieldInfo.genericType);
                fury.writeNonRef(buffer, fieldValue, classInfo);
                generics.popGenericType();
            }
        } else if (fieldValue == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            generics.pushGenericType(fieldInfo.genericType);
            fury.writeNonRef(buffer, fieldValue, classResolver.getClassInfo(fieldValue.getClass(), fieldInfo.classInfoHolder));
            generics.popGenericType();
        }
    }

    @Override
    public T read(MemoryBuffer buffer) {
        if (this.isRecord) {
            Object[] fields = this.readFields(buffer);
            fields = RecordUtils.remapping(this.recordInfo, fields);
            try {
                Object obj = this.constructor.invokeWithArguments(fields);
                Arrays.fill(this.recordInfo.getRecordComponents(), null);
                return (T)obj;
            }
            catch (Throwable e) {
                Platform.throwException(e);
            }
        }
        Object obj = this.newBean();
        this.refResolver.reference(obj);
        return this.readAndSetFields(buffer, obj);
    }

    public Object[] readFields(MemoryBuffer buffer) {
        Object fieldValue;
        Fury fury = this.fury;
        RefResolver refResolver = this.refResolver;
        ClassResolver classResolver = this.classResolver;
        if (fury.checkClassVersion()) {
            int hash = buffer.readInt32();
            ObjectSerializer.checkClassVersion(fury, hash, this.classVersionHash);
        }
        Object[] fieldValues = new Object[this.finalFields.length + this.otherFields.length + this.containerFields.length];
        int counter = 0;
        AbstractObjectSerializer.FinalTypeField[] finalFields = this.finalFields;
        boolean metaShareEnabled = fury.getConfig().isMetaShareEnabled();
        for (int i = 0; i < finalFields.length; ++i) {
            AbstractObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
            boolean isFinal = !metaShareEnabled || this.isFinal[i];
            short classId = fieldInfo.classId;
            if (classId >= 5 && classId <= 12) {
                fieldValues[counter++] = Serializers.readPrimitiveValue(fury, buffer, classId);
                continue;
            }
            fieldValue = ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal, buffer);
            fieldValues[counter++] = fieldValue;
        }
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.otherFields) {
            fieldValue = ObjectSerializer.readOtherFieldValue(fury, fieldInfo, buffer);
            fieldValues[counter++] = fieldValue;
        }
        Generics generics = fury.getGenerics();
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.containerFields) {
            Object fieldValue2 = ObjectSerializer.readContainerFieldValue(fury, generics, fieldInfo, buffer);
            fieldValues[counter++] = fieldValue2;
        }
        return fieldValues;
    }

    public T readAndSetFields(MemoryBuffer buffer, T obj) {
        Object fieldValue;
        Fury fury = this.fury;
        RefResolver refResolver = this.refResolver;
        ClassResolver classResolver = this.classResolver;
        if (fury.checkClassVersion()) {
            int hash = buffer.readInt32();
            ObjectSerializer.checkClassVersion(fury, hash, this.classVersionHash);
        }
        AbstractObjectSerializer.FinalTypeField[] finalFields = this.finalFields;
        boolean metaShareEnabled = fury.getConfig().isMetaShareEnabled();
        for (int i = 0; i < finalFields.length; ++i) {
            AbstractObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
            boolean isFinal = !metaShareEnabled || this.isFinal[i];
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            short classId = fieldInfo.classId;
            if (!ObjectSerializer.readPrimitiveFieldValueFailed(fury, buffer, obj, fieldAccessor, classId) || !ObjectSerializer.readBasicObjectFieldValueFailed(fury, buffer, obj, fieldAccessor, classId)) continue;
            fieldValue = ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal, buffer);
            fieldAccessor.putObject(obj, fieldValue);
        }
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.otherFields) {
            Object fieldValue2 = ObjectSerializer.readOtherFieldValue(fury, fieldInfo, buffer);
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            fieldAccessor.putObject(obj, fieldValue2);
        }
        Generics generics = fury.getGenerics();
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.containerFields) {
            fieldValue = ObjectSerializer.readContainerFieldValue(fury, generics, fieldInfo, buffer);
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            fieldAccessor.putObject(obj, fieldValue);
        }
        return obj;
    }

    static Object readFinalObjectFieldValue(Fury fury, RefResolver refResolver, ClassResolver classResolver, AbstractObjectSerializer.FinalTypeField fieldInfo, boolean isFinal, MemoryBuffer buffer) {
        Object fieldValue;
        Serializer serializer = fieldInfo.classInfo.getSerializer();
        if (isFinal) {
            if (!fieldInfo.trackingRef) {
                return fury.readNullable(buffer, serializer);
            }
            fieldValue = fury.readRef(buffer, serializer);
        } else if (serializer.needToWriteRef()) {
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                classResolver.readClassInfo(buffer, fieldInfo.classInfo);
                fieldValue = serializer.read(buffer);
                refResolver.setReadObject(nextReadRefId, fieldValue);
            } else {
                fieldValue = refResolver.getReadObject();
            }
        } else {
            byte headFlag = buffer.readByte();
            if (headFlag == -3) {
                fieldValue = null;
            } else {
                classResolver.readClassInfo(buffer, fieldInfo.classInfo);
                fieldValue = serializer.read(buffer);
            }
        }
        return fieldValue;
    }

    static Object readOtherFieldValue(Fury fury, AbstractObjectSerializer.GenericTypeField fieldInfo, MemoryBuffer buffer) {
        byte headFlag;
        Object fieldValue = fieldInfo.trackingRef ? fury.readRef(buffer, fieldInfo.classInfoHolder) : ((headFlag = buffer.readByte()) == -3 ? null : fury.readNonRef(buffer, fieldInfo.classInfoHolder));
        return fieldValue;
    }

    static Object readContainerFieldValue(Fury fury, Generics generics, AbstractObjectSerializer.GenericTypeField fieldInfo, MemoryBuffer buffer) {
        Object fieldValue;
        if (fieldInfo.trackingRef) {
            generics.pushGenericType(fieldInfo.genericType);
            fieldValue = fury.readRef(buffer, fieldInfo.classInfoHolder);
            generics.popGenericType();
        } else {
            byte headFlag = buffer.readByte();
            if (headFlag == -3) {
                fieldValue = null;
            } else {
                generics.pushGenericType(fieldInfo.genericType);
                fieldValue = fury.readNonRef(buffer, fieldInfo.classInfoHolder);
                generics.popGenericType();
            }
        }
        return fieldValue;
    }

    static boolean writePrimitiveFieldValueFailed(Fury fury, MemoryBuffer buffer, Object targetObject, FieldAccessor fieldAccessor, short classId) {
        long fieldOffset = fieldAccessor.getFieldOffset();
        if (fieldOffset != -1L) {
            return ObjectSerializer.writePrimitiveFieldValueFailed(fury, buffer, targetObject, fieldOffset, classId);
        }
        switch (classId) {
            case 5: {
                buffer.writeBoolean((Boolean)fieldAccessor.get(targetObject));
                return false;
            }
            case 6: {
                buffer.writeByte((Byte)fieldAccessor.get(targetObject));
                return false;
            }
            case 7: {
                buffer.writeChar(((Character)fieldAccessor.get(targetObject)).charValue());
                return false;
            }
            case 8: {
                buffer.writeInt16((Short)fieldAccessor.get(targetObject));
                return false;
            }
            case 9: {
                int fieldValue = (Integer)fieldAccessor.get(targetObject);
                if (fury.compressInt()) {
                    buffer.writeVarInt32(fieldValue);
                } else {
                    buffer.writeInt32(fieldValue);
                }
                return false;
            }
            case 10: {
                buffer.writeFloat32(((Float)fieldAccessor.get(targetObject)).floatValue());
                return false;
            }
            case 11: {
                long fieldValue = (Long)fieldAccessor.get(targetObject);
                fury.writeInt64(buffer, fieldValue);
                return false;
            }
            case 12: {
                buffer.writeFloat64((Double)fieldAccessor.get(targetObject));
                return false;
            }
        }
        return true;
    }

    static boolean writePrimitiveFieldValueFailed(Fury fury, MemoryBuffer buffer, Object targetObject, long fieldOffset, short classId) {
        switch (classId) {
            case 5: {
                buffer.writeBoolean(Platform.getBoolean(targetObject, fieldOffset));
                return false;
            }
            case 6: {
                buffer.writeByte(Platform.getByte(targetObject, fieldOffset));
                return false;
            }
            case 7: {
                buffer.writeChar(Platform.getChar(targetObject, fieldOffset));
                return false;
            }
            case 8: {
                buffer.writeInt16(Platform.getShort(targetObject, fieldOffset));
                return false;
            }
            case 9: {
                int fieldValue = Platform.getInt(targetObject, fieldOffset);
                if (fury.compressInt()) {
                    buffer.writeVarInt32(fieldValue);
                } else {
                    buffer.writeInt32(fieldValue);
                }
                return false;
            }
            case 10: {
                buffer.writeFloat32(Platform.getFloat(targetObject, fieldOffset));
                return false;
            }
            case 11: {
                long fieldValue = Platform.getLong(targetObject, fieldOffset);
                fury.writeInt64(buffer, fieldValue);
                return false;
            }
            case 12: {
                buffer.writeFloat64(Platform.getDouble(targetObject, fieldOffset));
                return false;
            }
        }
        return true;
    }

    static boolean writeBasicObjectFieldValueFailed(Fury fury, MemoryBuffer buffer, Object fieldValue, short classId) {
        if (!fury.isBasicTypesRefIgnored()) {
            return true;
        }
        switch (classId) {
            case 22: {
                fury.writeJavaStringRef(buffer, (String)fieldValue);
                return false;
            }
            case 14: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeBoolean((Boolean)fieldValue);
                }
                return false;
            }
            case 15: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeByte((Byte)fieldValue);
                }
                return false;
            }
            case 16: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeChar(((Character)fieldValue).charValue());
                }
                return false;
            }
            case 17: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeInt16((Short)fieldValue);
                }
                return false;
            }
            case 18: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    if (fury.compressInt()) {
                        buffer.writeVarInt32((Integer)fieldValue);
                    } else {
                        buffer.writeInt32((Integer)fieldValue);
                    }
                }
                return false;
            }
            case 19: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeFloat32(((Float)fieldValue).floatValue());
                }
                return false;
            }
            case 20: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    fury.writeInt64(buffer, (Long)fieldValue);
                }
                return false;
            }
            case 21: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeFloat64((Double)fieldValue);
                }
                return false;
            }
        }
        return true;
    }

    static boolean readPrimitiveFieldValueFailed(Fury fury, MemoryBuffer buffer, Object targetObject, FieldAccessor fieldAccessor, short classId) {
        long fieldOffset = fieldAccessor.getFieldOffset();
        if (fieldOffset != -1L) {
            return ObjectSerializer.readPrimitiveFieldValueFailed(fury, buffer, targetObject, fieldOffset, classId);
        }
        switch (classId) {
            case 5: {
                fieldAccessor.set(targetObject, buffer.readBoolean());
                return false;
            }
            case 6: {
                fieldAccessor.set(targetObject, buffer.readByte());
                return false;
            }
            case 7: {
                fieldAccessor.set(targetObject, Character.valueOf(buffer.readChar()));
                return false;
            }
            case 8: {
                fieldAccessor.set(targetObject, buffer.readInt16());
                return false;
            }
            case 9: {
                if (fury.compressInt()) {
                    fieldAccessor.set(targetObject, buffer.readVarInt32());
                } else {
                    fieldAccessor.set(targetObject, buffer.readInt32());
                }
                return false;
            }
            case 10: {
                fieldAccessor.set(targetObject, Float.valueOf(buffer.readFloat32()));
                return false;
            }
            case 11: {
                fieldAccessor.set(targetObject, fury.readInt64(buffer));
                return false;
            }
            case 12: {
                fieldAccessor.set(targetObject, buffer.readFloat64());
                return false;
            }
            case 22: {
                fieldAccessor.putObject(targetObject, fury.readJavaStringRef(buffer));
                return false;
            }
        }
        return true;
    }

    private static boolean readPrimitiveFieldValueFailed(Fury fury, MemoryBuffer buffer, Object targetObject, long fieldOffset, short classId) {
        switch (classId) {
            case 5: {
                Platform.putBoolean(targetObject, fieldOffset, buffer.readBoolean());
                return false;
            }
            case 6: {
                Platform.putByte(targetObject, fieldOffset, buffer.readByte());
                return false;
            }
            case 7: {
                Platform.putChar(targetObject, fieldOffset, buffer.readChar());
                return false;
            }
            case 8: {
                Platform.putShort(targetObject, fieldOffset, buffer.readInt16());
                return false;
            }
            case 9: {
                if (fury.compressInt()) {
                    Platform.putInt(targetObject, fieldOffset, buffer.readVarInt32());
                } else {
                    Platform.putInt(targetObject, fieldOffset, buffer.readInt32());
                }
                return false;
            }
            case 10: {
                Platform.putFloat(targetObject, fieldOffset, buffer.readFloat32());
                return false;
            }
            case 11: {
                Platform.putLong(targetObject, fieldOffset, fury.readInt64(buffer));
                return false;
            }
            case 12: {
                Platform.putDouble(targetObject, fieldOffset, buffer.readFloat64());
                return false;
            }
            case 22: {
                Platform.putObject(targetObject, fieldOffset, fury.readJavaStringRef(buffer));
                return false;
            }
        }
        return true;
    }

    static boolean readBasicObjectFieldValueFailed(Fury fury, MemoryBuffer buffer, Object targetObject, FieldAccessor fieldAccessor, short classId) {
        if (!fury.isBasicTypesRefIgnored()) {
            return true;
        }
        switch (classId) {
            case 22: {
                fieldAccessor.putObject(targetObject, fury.readJavaStringRef(buffer));
                return false;
            }
            case 14: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readBoolean());
                }
                return false;
            }
            case 15: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readByte());
                }
                return false;
            }
            case 16: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, Character.valueOf(buffer.readChar()));
                }
                return false;
            }
            case 17: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readInt16());
                }
                return false;
            }
            case 18: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else if (fury.compressInt()) {
                    fieldAccessor.putObject(targetObject, buffer.readVarInt32());
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readInt32());
                }
                return false;
            }
            case 19: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, Float.valueOf(buffer.readFloat32()));
                }
                return false;
            }
            case 20: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, fury.readInt64(buffer));
                }
                return false;
            }
            case 21: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readFloat64());
                }
                return false;
            }
        }
        return true;
    }

    public static int computeVersionHash(Collection<Descriptor> descriptors) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Descriptor d : descriptors) {
            Integer integer = Objects.hash(d.getName(), d.getRawType().getName(), d.getDeclaringClass());
            list.add(integer);
        }
        return list.hashCode();
    }

    public static void checkClassVersion(Fury fury, int readHash, int classVersionHash) {
        if (readHash != classVersionHash) {
            throw new FuryException(String.format("Read class %s version %s is not consistent with %s", fury.getClassResolver().getCurrentReadClass(), readHash, classVersionHash));
        }
    }
}

