/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.serializer;

import java.io.Externalizable;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.logging.Logger;
import me.mrnavastar.protoweaver.libs.org.apache.fury.logging.LoggerFactory;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.MemoryBuffer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.Platform;
import me.mrnavastar.protoweaver.libs.org.apache.fury.reflect.ReflectionUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.ClassInfo;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.ClassResolver;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.RefResolver;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.ExternalizableSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.JavaSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializers;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.unsafe._JDKAccess;

public class ReplaceResolveSerializer
extends Serializer {
    private static final Logger LOG = LoggerFactory.getLogger(ReplaceResolveSerializer.class);
    private static final byte ORIGINAL = 0;
    private static final byte REPLACED_NEW_TYPE = 1;
    private static final byte REPLACED_SAME_TYPE = 2;
    private static final ClassValue<ReplaceResolveInfo> REPLACE_RESOLVE_INFO_CACHE = new ClassValue<ReplaceResolveInfo>(){

        @Override
        protected ReplaceResolveInfo computeValue(Class<?> type) {
            return new ReplaceResolveInfo(type);
        }
    };
    private final RefResolver refResolver;
    private final ClassResolver classResolver;
    private final MethodInfoCache jdkMethodInfoWriteCache;
    private final ClassInfo writeClassInfo;
    private final Map<Class<?>, MethodInfoCache> classClassInfoHolderMap = new HashMap();

    static MethodInfoCache newJDKMethodInfoCache(Class<?> cls, Fury fury) {
        ReplaceResolveInfo replaceResolveInfo = REPLACE_RESOLVE_INFO_CACHE.get(cls);
        MethodInfoCache methodInfoCache = new MethodInfoCache(replaceResolveInfo);
        Class serializerClass = Externalizable.class.isAssignableFrom(cls) ? ExternalizableSerializer.class : (JavaSerializer.getReadObjectMethod(cls, true) == null && JavaSerializer.getWriteObjectMethod(cls, true) == null ? fury.getClassResolver().getObjectSerializerClass(cls, sc -> methodInfoCache.setObjectSerializer(ReplaceResolveSerializer.createDataSerializer(fury, cls, sc))) : fury.getDefaultJDKStreamSerializerType());
        methodInfoCache.setObjectSerializer(ReplaceResolveSerializer.createDataSerializer(fury, cls, serializerClass));
        return methodInfoCache;
    }

    private static Serializer createDataSerializer(Fury fury, Class<?> cls, Class<? extends Serializer> sc) {
        Serializer<?> prev = fury.getClassResolver().getSerializer(cls, false);
        Serializer serializer = Serializers.newSerializer(fury, cls, sc);
        fury.getClassResolver().resetSerializer(cls, prev);
        return serializer;
    }

    public ReplaceResolveSerializer(Fury fury, Class type) {
        super(fury, type);
        this.refResolver = fury.getRefResolver();
        this.classResolver = fury.getClassResolver();
        this.classResolver.setSerializerIfAbsent(type, this);
        if (type != ReplaceStub.class) {
            this.jdkMethodInfoWriteCache = ReplaceResolveSerializer.newJDKMethodInfoCache(type, fury);
            this.classClassInfoHolderMap.put(type, this.jdkMethodInfoWriteCache);
            this.writeClassInfo = this.classResolver.newClassInfo(type, this, (short)0);
        } else {
            this.jdkMethodInfoWriteCache = null;
            this.writeClassInfo = null;
        }
    }

    public void write(MemoryBuffer buffer, Object value) {
        MethodInfoCache jdkMethodInfoCache = this.jdkMethodInfoWriteCache;
        ReplaceResolveInfo replaceResolveInfo = jdkMethodInfoCache.info;
        Method writeReplaceMethod = replaceResolveInfo.writeReplaceMethod;
        if (writeReplaceMethod != null) {
            Object original = value;
            if ((value = replaceResolveInfo.writeReplace(value)) == null || value.getClass() != this.type) {
                buffer.writeByte((byte)1);
                if (!this.refResolver.writeRefOrNull(buffer, value)) {
                    this.refResolver.replaceRef(original, value);
                    this.fury.writeNonRef(buffer, value);
                }
            } else if (value != original) {
                buffer.writeByte((byte)2);
                if (!this.refResolver.writeRefOrNull(buffer, value)) {
                    this.refResolver.replaceRef(original, value);
                    this.writeObject(buffer, value, jdkMethodInfoCache);
                }
            } else {
                buffer.writeByte((byte)0);
                this.writeObject(buffer, value, jdkMethodInfoCache);
            }
        } else {
            buffer.writeByte((byte)0);
            this.writeObject(buffer, value, jdkMethodInfoCache);
        }
    }

    private void writeObject(MemoryBuffer buffer, Object value, MethodInfoCache jdkMethodInfoCache) {
        this.classResolver.writeClassInternal(buffer, this.writeClassInfo);
        jdkMethodInfoCache.objectSerializer.write(buffer, value);
    }

    public Object read(MemoryBuffer buffer) {
        byte flag = buffer.readByte();
        RefResolver refResolver = this.refResolver;
        if (flag == 1) {
            int outerRefId = refResolver.lastPreservedRefId();
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                Object o = this.fury.readData(buffer, this.classResolver.readClassInfo(buffer));
                refResolver.setReadObject(nextReadRefId, o);
                refResolver.setReadObject(outerRefId, o);
                return o;
            }
            return refResolver.getReadObject();
        }
        if (flag == 2) {
            int outerRefId = refResolver.lastPreservedRefId();
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                Object o = this.readObject(buffer);
                refResolver.setReadObject(nextReadRefId, o);
                refResolver.setReadObject(outerRefId, o);
                return o;
            }
            return refResolver.getReadObject();
        }
        Preconditions.checkArgument(flag == 0);
        return this.readObject(buffer);
    }

    private Object readObject(MemoryBuffer buffer) {
        Class<?> cls = this.classResolver.readClassInternal(buffer);
        MethodInfoCache jdkMethodInfoCache = this.getMethodInfoCache(cls);
        Object o = jdkMethodInfoCache.objectSerializer.read(buffer);
        ReplaceResolveInfo replaceResolveInfo = jdkMethodInfoCache.info;
        if (replaceResolveInfo.readResolveMethod == null) {
            return o;
        }
        return replaceResolveInfo.readResolve(o);
    }

    public Object copy(Object originObj) {
        ReplaceResolveInfo replaceResolveInfo = this.jdkMethodInfoWriteCache.info;
        if (replaceResolveInfo.writeReplaceMethod == null) {
            return this.jdkMethodInfoWriteCache.objectSerializer.copy(originObj);
        }
        Object newObj = originObj;
        newObj = replaceResolveInfo.writeReplace(newObj);
        if (this.needToCopyRef) {
            this.fury.reference(originObj, newObj);
        }
        MethodInfoCache jdkMethodInfoCache = this.getMethodInfoCache(newObj.getClass());
        newObj = jdkMethodInfoCache.objectSerializer.copy(newObj);
        replaceResolveInfo = jdkMethodInfoCache.info;
        if (replaceResolveInfo.readResolveMethod != null) {
            newObj = replaceResolveInfo.readResolve(newObj);
        }
        return newObj;
    }

    private MethodInfoCache getMethodInfoCache(Class<?> cls) {
        MethodInfoCache jdkMethodInfoCache = this.classClassInfoHolderMap.get(cls);
        if (jdkMethodInfoCache == null) {
            jdkMethodInfoCache = ReplaceResolveSerializer.newJDKMethodInfoCache(cls, this.fury);
            this.classClassInfoHolderMap.put(cls, jdkMethodInfoCache);
        }
        return jdkMethodInfoCache;
    }

    private static class MethodInfoCache {
        private final ReplaceResolveInfo info;
        private Serializer objectSerializer;

        public MethodInfoCache(ReplaceResolveInfo info) {
            this.info = info;
        }

        public void setObjectSerializer(Serializer objectSerializer) {
            this.objectSerializer = objectSerializer;
        }
    }

    private static class ReplaceResolveInfo {
        private final Method writeReplaceMethod;
        private final Method readResolveMethod;
        private final Function writeReplaceFunc;
        private final Function readResolveFunc;

        private ReplaceResolveInfo(Class<?> cls) {
            Function readResolveFunc;
            Function writeReplaceFunc;
            block10: {
                Method readResolveMethod;
                Method writeReplaceMethod;
                if (Serializable.class.isAssignableFrom(cls)) {
                    ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(cls);
                    writeReplaceMethod = (Method)ReflectionUtils.getObjectFieldValue((Object)objectStreamClass, "writeReplaceMethod");
                    readResolveMethod = (Method)ReflectionUtils.getObjectFieldValue((Object)objectStreamClass, "readResolveMethod");
                } else {
                    writeReplaceMethod = JavaSerializer.getWriteReplaceMethod(cls);
                    readResolveMethod = JavaSerializer.getReadResolveMethod(cls);
                    if (writeReplaceMethod != null) {
                        LOG.warn("{} doesn't implement {}, but defined writeReplace method {}", cls, Serializable.class, writeReplaceMethod);
                    }
                    if (readResolveMethod != null) {
                        LOG.warn("{} doesn't implement {}, but defined readResolve method {}", cls, Serializable.class, readResolveMethod);
                    }
                }
                this.writeReplaceMethod = writeReplaceMethod;
                this.readResolveMethod = readResolveMethod;
                Class<?> declaringClass = writeReplaceMethod != null ? writeReplaceMethod.getDeclaringClass() : (readResolveMethod != null ? readResolveMethod.getDeclaringClass() : null);
                writeReplaceFunc = null;
                readResolveFunc = null;
                if (declaringClass != null) {
                    MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(declaringClass);
                    try {
                        if (writeReplaceMethod != null) {
                            writeReplaceFunc = _JDKAccess.makeJDKFunction(lookup, lookup.unreflect(writeReplaceMethod));
                        }
                        if (readResolveMethod != null) {
                            readResolveFunc = _JDKAccess.makeJDKFunction(lookup, lookup.unreflect(readResolveMethod));
                        }
                    }
                    catch (Exception e) {
                        if (writeReplaceMethod != null && !writeReplaceMethod.isAccessible()) {
                            writeReplaceMethod.setAccessible(true);
                        }
                        if (readResolveMethod == null || readResolveMethod.isAccessible()) break block10;
                        readResolveMethod.setAccessible(true);
                    }
                }
            }
            this.writeReplaceFunc = writeReplaceFunc;
            this.readResolveFunc = readResolveFunc;
        }

        Object writeReplace(Object o) {
            if (this.writeReplaceFunc != null) {
                return this.writeReplaceFunc.apply(o);
            }
            try {
                return this.writeReplaceMethod.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                Platform.throwException(e);
                throw new IllegalStateException(e);
            }
        }

        Object readResolve(Object o) {
            if (this.readResolveFunc != null) {
                return this.readResolveFunc.apply(o);
            }
            try {
                return this.readResolveMethod.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                Platform.throwException(e);
                throw new IllegalStateException(e);
            }
        }
    }

    public static class ReplaceStub {
    }
}

