/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.collection;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.config.CompatibleMode;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.MemoryBuffer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.reflect.ReflectionUtils;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.ClassResolver;
import me.mrnavastar.protoweaver.libs.org.apache.fury.resolver.FieldResolver;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.AbstractObjectSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.CompatibleSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.JavaSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.ObjectSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.collection.CollectionSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.collection.MapSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;

public class ChildContainerSerializers {
    public static Class<? extends Serializer> getCollectionSerializerClass(Class<?> cls) {
        if (ChildCollectionSerializer.superClasses.contains(cls)) {
            return null;
        }
        if (ClassResolver.useReplaceResolveSerializer(cls)) {
            return null;
        }
        if (!ReflectionUtils.hasNoArgConstructor(cls)) {
            return null;
        }
        while (cls != Object.class) {
            if (ChildCollectionSerializer.superClasses.contains(cls)) {
                if (cls == ArrayList.class) {
                    return ChildArrayListSerializer.class;
                }
                return ChildCollectionSerializer.class;
            }
            if (JavaSerializer.getReadObjectMethod(cls, false) != null || JavaSerializer.getWriteObjectMethod(cls, false) != null) {
                return null;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public static Class<? extends Serializer> getMapSerializerClass(Class<?> cls) {
        if (ChildMapSerializer.superClasses.contains(cls)) {
            return null;
        }
        if (ClassResolver.useReplaceResolveSerializer(cls)) {
            return null;
        }
        if (!ReflectionUtils.hasNoArgConstructor(cls)) {
            return null;
        }
        while (cls != Object.class) {
            if (ChildMapSerializer.superClasses.contains(cls)) {
                return ChildMapSerializer.class;
            }
            if (JavaSerializer.getReadObjectMethod(cls, false) != null || JavaSerializer.getWriteObjectMethod(cls, false) != null) {
                return null;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    private static <T> Serializer[] buildSlotsSerializers(Fury fury, Set<Class<?>> superClasses, Class<T> cls) {
        Preconditions.checkArgument(!superClasses.contains(cls));
        ArrayList<ObjectSerializer<T>> serializers = new ArrayList<ObjectSerializer<T>>();
        while (!superClasses.contains(cls)) {
            AbstractObjectSerializer slotsSerializer = fury.getConfig().getCompatibleMode() == CompatibleMode.COMPATIBLE ? new CompatibleSerializer<T>(fury, cls, FieldResolver.of(fury, cls, false, false)) : new ObjectSerializer<T>(fury, cls, false);
            serializers.add((ObjectSerializer<T>)slotsSerializer);
            cls = cls.getSuperclass();
        }
        Collections.reverse(serializers);
        return serializers.toArray(new Serializer[0]);
    }

    private static void readAndSetFields(MemoryBuffer buffer, Object collection, Serializer[] slotsSerializers) {
        for (Serializer slotsSerializer : slotsSerializers) {
            if (slotsSerializer.getClass() == CompatibleSerializer.class) {
                ((CompatibleSerializer)slotsSerializer).readAndSetFields(buffer, collection);
                continue;
            }
            ((ObjectSerializer)slotsSerializer).readAndSetFields(buffer, collection);
        }
    }

    public static class ChildMapSerializer<T extends Map>
    extends MapSerializer<T> {
        public static Set<Class<?>> superClasses = me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(HashMap.class, LinkedHashMap.class, ConcurrentHashMap.class);
        private final Serializer[] slotsSerializers;
        private AbstractObjectSerializer.InternalFieldInfo[] fieldInfos;

        public ChildMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            this.slotsSerializers = ChildContainerSerializers.buildSlotsSerializers(fury, ChildMapSerializer.superClasses, cls);
        }

        @Override
        public Map onMapWrite(MemoryBuffer buffer, T value) {
            buffer.writeVarUint32Small7(value.size());
            for (Serializer slotsSerializer : this.slotsSerializers) {
                slotsSerializer.write(buffer, value);
            }
            return value;
        }

        @Override
        public Map newMap(MemoryBuffer buffer) {
            Map map = super.newMap(buffer);
            ChildContainerSerializers.readAndSetFields(buffer, map, this.slotsSerializers);
            return map;
        }

        @Override
        public Map newMap(Map originMap) {
            Map newMap = super.newMap(originMap);
            if (this.fieldInfos == null || this.fieldInfos.length == 0) {
                List<Field> fields = ReflectionUtils.getFieldsWithoutSuperClasses(this.type, superClasses);
                this.fieldInfos = AbstractObjectSerializer.buildFieldsInfo(this.fury, fields);
            }
            AbstractObjectSerializer.copyFields(this.fury, this.fieldInfos, originMap, newMap);
            return newMap;
        }
    }

    public static final class ChildArrayListSerializer<T extends ArrayList>
    extends ChildCollectionSerializer<T> {
        public ChildArrayListSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
        }

        public T newCollection(MemoryBuffer buffer) {
            ArrayList collection = (ArrayList)super.newCollection(buffer);
            int numElements = this.getAndClearNumElements();
            this.setNumElements(numElements);
            collection.ensureCapacity(numElements);
            return (T)collection;
        }
    }

    public static class ChildCollectionSerializer<T extends Collection>
    extends CollectionSerializer<T> {
        public static Set<Class<?>> superClasses = me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Collections.ofHashSet(ArrayList.class, LinkedList.class, ArrayDeque.class, Vector.class, HashSet.class);
        protected AbstractObjectSerializer.InternalFieldInfo[] fieldInfos;
        protected final Serializer[] slotsSerializers;

        public ChildCollectionSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            this.slotsSerializers = ChildContainerSerializers.buildSlotsSerializers(fury, ChildCollectionSerializer.superClasses, cls);
        }

        @Override
        public Collection onCollectionWrite(MemoryBuffer buffer, T value) {
            buffer.writeVarUint32Small7(value.size());
            for (Serializer slotsSerializer : this.slotsSerializers) {
                slotsSerializer.write(buffer, value);
            }
            return value;
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer) {
            Collection collection = super.newCollection(buffer);
            ChildContainerSerializers.readAndSetFields(buffer, collection, this.slotsSerializers);
            return collection;
        }

        @Override
        public Collection newCollection(Collection originCollection) {
            Collection newCollection = super.newCollection(originCollection);
            if (this.fieldInfos == null) {
                List<Field> fields = ReflectionUtils.getFieldsWithoutSuperClasses(this.type, superClasses);
                this.fieldInfos = AbstractObjectSerializer.buildFieldsInfo(this.fury, fields);
            }
            AbstractObjectSerializer.copyFields(this.fury, this.fieldInfos, originCollection, newCollection);
            return newCollection;
        }
    }
}

