/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.collection;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.RandomAccess;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.annotation.Internal;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.MemoryBuffer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.collection.CollectionSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.type.Type;

@Internal
public final class FuryArrayAsListSerializer
extends CollectionSerializer<ArrayAsList> {
    public FuryArrayAsListSerializer(Fury fury) {
        super(fury, ArrayAsList.class, true);
    }

    @Override
    public short getXtypeId() {
        return -Type.LIST.getId();
    }

    @Override
    public Collection newCollection(MemoryBuffer buffer) {
        int numElements = buffer.readVarUint32Small7();
        this.setNumElements(numElements);
        return new ArrayAsList(numElements);
    }

    @Internal
    public static class ArrayAsList
    extends AbstractList<Object>
    implements RandomAccess,
    Serializable {
        private static final Object[] EMPTY = new Object[0];
        private Object[] array;
        private int size;

        public ArrayAsList(int size) {
            this.array = new Object[size];
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean add(Object e) {
            this.array[this.size++] = e;
            return true;
        }

        @Override
        public Object get(int index) {
            return this.array[index];
        }

        public void clearArray() {
            this.size = 0;
            this.array = EMPTY;
        }

        public void setArray(Object[] a) {
            this.array = a;
            this.size = a.length;
        }

        public Object[] getArray() {
            return this.array;
        }

        @Override
        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            return this.array;
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                private int index;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Object next() {
                    return array[this.index++];
                }
            };
        }
    }
}

