/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.Tuple2;
import me.mrnavastar.protoweaver.libs.org.apache.fury.logging.Logger;
import me.mrnavastar.protoweaver.libs.org.apache.fury.logging.LoggerFactory;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.MemoryBuffer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.Platform;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.collection.CollectionSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.collection.MapSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.ExceptionUtils;

public class SynchronizedSerializers {
    private static final Logger LOG = LoggerFactory.getLogger(SynchronizedSerializers.class);

    static Serializer createSerializer(Fury fury, Class<?> cls) {
        for (Tuple2<Class<?>, Function> factory : SynchronizedSerializers.synchronizedFactories()) {
            if (factory.f0 != cls) continue;
            return SynchronizedSerializers.createSerializer(fury, factory);
        }
        throw new IllegalArgumentException("Unsupported type " + cls);
    }

    private static Serializer<?> createSerializer(Fury fury, Tuple2<Class<?>, Function> factory) {
        if (Collection.class.isAssignableFrom((Class)factory.f0)) {
            return new SynchronizedCollectionSerializer(fury, (Class)factory.f0, (Function)factory.f1, Offset.SOURCE_COLLECTION_FIELD_OFFSET);
        }
        return new SynchronizedMapSerializer(fury, (Class)factory.f0, (Function)factory.f1, Offset.SOURCE_MAP_FIELD_OFFSET);
    }

    static Tuple2<Class<?>, Function>[] synchronizedFactories() {
        Tuple2<Class<?>, Function<Object, Object>> collectionFactory = Tuple2.of(Collections.synchronizedCollection(Arrays.asList("")).getClass(), o -> Collections.synchronizedCollection((Collection)o));
        Tuple2<Class<?>, Function<Object, Object>> randomListFactory = Tuple2.of(Collections.synchronizedList(new ArrayList()).getClass(), o -> Collections.synchronizedList((List)o));
        Tuple2<Class<?>, Function<Object, Object>> listFactory = Tuple2.of(Collections.synchronizedList(new LinkedList()).getClass(), o -> Collections.synchronizedList((List)o));
        Tuple2<Class<?>, Function<Object, Object>> setFactory = Tuple2.of(Collections.synchronizedSet(new HashSet()).getClass(), o -> Collections.synchronizedSet((Set)o));
        Tuple2<Class<?>, Function<Object, Object>> sortedsetFactory = Tuple2.of(Collections.synchronizedSortedSet(new TreeSet()).getClass(), o -> Collections.synchronizedSortedSet((TreeSet)o));
        Tuple2<Class<?>, Function<Object, Object>> mapFactory = Tuple2.of(Collections.synchronizedMap(new HashMap()).getClass(), o -> Collections.synchronizedMap((Map)o));
        Tuple2<Class<?>, Function<Object, Object>> sortedmapFactory = Tuple2.of(Collections.synchronizedSortedMap(new TreeMap()).getClass(), o -> Collections.synchronizedSortedMap((SortedMap)o));
        return new Tuple2[]{collectionFactory, randomListFactory, listFactory, setFactory, sortedsetFactory, mapFactory, sortedmapFactory};
    }

    public static void registerSerializers(Fury fury) {
        try {
            for (Tuple2<Class<?>, Function> factory : SynchronizedSerializers.synchronizedFactories()) {
                fury.registerSerializer((Class)factory.f0, SynchronizedSerializers.createSerializer(fury, factory));
            }
        }
        catch (Throwable e) {
            ExceptionUtils.ignore(e);
        }
    }

    public static final class SynchronizedMapSerializer
    extends MapSerializer<Map> {
        private final Function factory;
        private final long offset;

        public SynchronizedMapSerializer(Fury fury, Class cls, Function factory, long offset) {
            super(fury, cls, false);
            this.factory = factory;
            this.offset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(MemoryBuffer buffer, Map object) {
            Object unwrapped = Platform.getObject(object, this.offset);
            Map map = object;
            synchronized (map) {
                this.fury.writeRef(buffer, unwrapped);
            }
        }

        @Override
        public Map copy(Map originMap) {
            Object unwrappedMap = Platform.getObject(originMap, this.offset);
            return (Map)this.factory.apply(this.fury.copyObject(unwrappedMap));
        }

        @Override
        public Map read(MemoryBuffer buffer) {
            Object sourceCollection = this.fury.readRef(buffer);
            return (Map)this.factory.apply(sourceCollection);
        }
    }

    public static final class SynchronizedCollectionSerializer
    extends CollectionSerializer<Collection> {
        private final Function factory;
        private final long offset;

        public SynchronizedCollectionSerializer(Fury fury, Class cls, Function factory, long offset) {
            super(fury, cls, false);
            this.factory = factory;
            this.offset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(MemoryBuffer buffer, Collection object) {
            Object unwrapped = Platform.getObject(object, this.offset);
            Collection collection = object;
            synchronized (collection) {
                this.fury.writeRef(buffer, unwrapped);
            }
        }

        @Override
        public Collection read(MemoryBuffer buffer) {
            Object sourceCollection = this.fury.readRef(buffer);
            return (Collection)this.factory.apply(sourceCollection);
        }

        @Override
        public Collection copy(Collection object) {
            Object collection = Platform.getObject(object, this.offset);
            return (Collection)this.factory.apply(this.fury.copyObject(collection));
        }
    }

    private static class Offset {
        private static final long SOURCE_COLLECTION_FIELD_OFFSET;
        private static final long SOURCE_MAP_FIELD_OFFSET;

        private Offset() {
        }

        static {
            String clsName = "java.util.Collections$SynchronizedCollection";
            try {
                SOURCE_COLLECTION_FIELD_OFFSET = Platform.UNSAFE.objectFieldOffset(Class.forName(clsName).getDeclaredField("c"));
            }
            catch (Exception e) {
                LOG.info("Could not access source collection field in {}", (Object)clsName);
                throw new RuntimeException(e);
            }
            clsName = "java.util.Collections$SynchronizedMap";
            try {
                SOURCE_MAP_FIELD_OFFSET = Platform.UNSAFE.objectFieldOffset(Class.forName(clsName).getDeclaredField("m"));
            }
            catch (Exception e) {
                LOG.info("Could not access source map field in {}", (Object)clsName);
                throw new RuntimeException(e);
            }
        }
    }
}

