/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.scala;

import java.lang.reflect.Field;
import java.util.Map;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.MemoryBuffer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.Platform;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.collection.AbstractMapSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.GraalvmSupport;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;

public class SingletonMapSerializer
extends AbstractMapSerializer {
    private final Field field;
    private Object base = null;
    private long offset = -1L;

    public SingletonMapSerializer(Fury fury, Class cls) {
        super(fury, cls, false);
        try {
            this.field = this.type.getDeclaredField("MODULE$");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(this.type + " doesn't have `MODULE$` field", e);
        }
    }

    public Map onMapWrite(MemoryBuffer buffer, Object value) {
        throw new IllegalStateException("unreachable");
    }

    @Override
    public void write(MemoryBuffer buffer, Object value) {
    }

    @Override
    public Object read(MemoryBuffer buffer) {
        long offset = this.offset;
        if (offset == -1L) {
            Preconditions.checkArgument(!GraalvmSupport.isGraalBuildtime());
            offset = this.offset = Platform.UNSAFE.staticFieldOffset(this.field);
            this.base = Platform.UNSAFE.staticFieldBase(this.field);
        }
        return Platform.getObject(this.base, offset);
    }

    public Object onMapCopy(Map map) {
        throw new IllegalStateException("unreachable");
    }

    public Object onMapRead(Map map) {
        throw new IllegalStateException("unreachable");
    }
}

