/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.scala;

import java.lang.reflect.Field;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.MemoryBuffer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.memory.Platform;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.GraalvmSupport;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;

public class SingletonObjectSerializer
extends Serializer {
    private final Field field;
    private Object base = null;
    private long offset = -1L;

    public SingletonObjectSerializer(Fury fury, Class type) {
        super(fury, type);
        try {
            this.field = type.getDeclaredField("MODULE$");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(type + " doesn't have `MODULE$` field", e);
        }
    }

    public void write(MemoryBuffer buffer, Object value) {
    }

    public Object read(MemoryBuffer buffer) {
        long offset = this.offset;
        if (offset == -1L) {
            Preconditions.checkArgument(!GraalvmSupport.isGraalBuildtime());
            offset = this.offset = Platform.UNSAFE.staticFieldOffset(this.field);
            this.base = Platform.UNSAFE.staticFieldBase(this.field);
        }
        return Platform.getObject(this.base, offset);
    }
}

