/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.shim;

import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.FuryObjectMap;
import me.mrnavastar.protoweaver.libs.org.apache.fury.collection.ObjectMap;
import me.mrnavastar.protoweaver.libs.org.apache.fury.logging.Logger;
import me.mrnavastar.protoweaver.libs.org.apache.fury.logging.LoggerFactory;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.Serializers;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.collection.CollectionSerializer;
import me.mrnavastar.protoweaver.libs.org.apache.fury.serializer.collection.MapSerializers;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;

public class ShimDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(ShimDispatcher.class);
    private final FuryObjectMap<String, Class<? extends Serializer>> className2ShimSerializerClass = new ObjectMap<String, Class<? extends Serializer>>(4, 0.75f);
    private final Fury fury;

    public ShimDispatcher(Fury fury) {
        this.fury = fury;
    }

    public void initialize() {
        this.register("com.alibaba.fastjson.JSONObject", MapSerializers.StringKeyMapSerializer.class);
        this.register("com.alibaba.fastjson.JSONArray", CollectionSerializer.class);
    }

    public boolean contains(Class<?> clazz) {
        return this.className2ShimSerializerClass.containsKey(clazz.getName());
    }

    public void register(String className, Class<? extends Serializer> serializerClass) {
        Preconditions.checkArgument(className != null, "Class name cannot be null");
        Preconditions.checkArgument(serializerClass != null, "Serializer class cannot be null");
        if (this.className2ShimSerializerClass.containsKey(className)) {
            throw new IllegalArgumentException("Class " + className + " has already been registered with serializer:" + serializerClass.getName());
        }
        this.className2ShimSerializerClass.put(className, serializerClass);
    }

    public Serializer<?> getSerializer(Class<?> clazz) {
        String className = clazz.getName();
        if (!this.className2ShimSerializerClass.containsKey(className)) {
            return null;
        }
        Class<? extends Serializer> serializerClass = this.className2ShimSerializerClass.get(className);
        try {
            return Serializers.newSerializer(this.fury, clazz, serializerClass);
        }
        catch (Throwable e) {
            LOG.warn("Construct shim serializer failed for class [{}] with serializer class [{}]", (Object)className, (Object)serializerClass);
            return null;
        }
    }
}

