/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.libs.org.apache.fury.util;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import me.mrnavastar.protoweaver.libs.org.apache.fury.Fury;
import me.mrnavastar.protoweaver.libs.org.apache.fury.annotation.Internal;
import me.mrnavastar.protoweaver.libs.org.apache.fury.util.Preconditions;

@Internal
public final class LoaderBinding {
    private final Function<ClassLoader, Fury> furyFactory;
    private final HashMap<ClassLoader, Fury> furyMap = new HashMap();
    private final WeakHashMap<ClassLoader, SoftReference<Fury>> furySoftMap = new WeakHashMap();
    private Consumer<Fury> bindingCallback = f -> {};
    private ClassLoader loader;
    private Fury fury;

    public LoaderBinding(Function<ClassLoader, Fury> furyFactory) {
        this.furyFactory = furyFactory;
    }

    public Fury get() {
        return this.fury;
    }

    public void visitAllFury(Consumer<Fury> consumer) {
        if (this.furySoftMap.isEmpty()) {
            for (Fury f : this.furyMap.values()) {
                consumer.accept(f);
            }
        } else if (this.furyMap.isEmpty()) {
            for (SoftReference<Fury> ref : this.furySoftMap.values()) {
                Fury f = ref.get();
                if (f == null) continue;
                consumer.accept(f);
            }
        } else {
            HashSet<Fury> furySet = new HashSet<Fury>(this.furyMap.size());
            furySet.addAll(this.furyMap.values());
            for (SoftReference<Fury> ref : this.furySoftMap.values()) {
                Fury f = ref.get();
                if (f == null) continue;
                furySet.add(f);
            }
            for (Fury f : furySet) {
                consumer.accept(f);
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.setClassLoader(classLoader, StagingType.STRONG_STAGING);
    }

    public void setClassLoader(ClassLoader classLoader, StagingType stagingType) {
        if (this.loader != classLoader) {
            if (classLoader == null) {
                classLoader = Fury.class.getClassLoader();
            }
            this.loader = classLoader;
            switch (stagingType) {
                case NO_STAGING: {
                    this.fury = this.furyFactory.apply(classLoader);
                    this.bindingCallback.accept(this.fury);
                    break;
                }
                case SOFT_STAGING: {
                    Fury fury;
                    SoftReference<Fury> furySoftReference = this.furySoftMap.get(classLoader);
                    Fury fury2 = fury = furySoftReference == null ? null : furySoftReference.get();
                    if (fury == null) {
                        fury = this.furyFactory.apply(classLoader);
                        this.bindingCallback.accept(fury);
                        this.furySoftMap.put(classLoader, new SoftReference<Fury>(fury));
                    }
                    this.fury = fury;
                    break;
                }
                case STRONG_STAGING: {
                    Fury fury = this.furyMap.get(classLoader);
                    if (fury == null) {
                        fury = this.furyFactory.apply(classLoader);
                        this.bindingCallback.accept(fury);
                        this.furyMap.put(classLoader, fury);
                    }
                    this.fury = fury;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    public void clearClassLoader(ClassLoader classLoader) {
        this.furyMap.remove(classLoader);
        SoftReference<Fury> softReference = this.furySoftMap.remove(classLoader);
        if (softReference != null) {
            softReference.clear();
        }
        if (this.loader == classLoader) {
            this.loader = null;
            this.fury = null;
        }
    }

    public void register(Class<?> clz) {
        this.furyMap.values().forEach(fury -> fury.register(clz));
        this.bindingCallback = this.bindingCallback.andThen(fury -> fury.register(clz));
    }

    public void register(Class<?> clz, int id) {
        Preconditions.checkArgument(id < Short.MAX_VALUE);
        this.furyMap.values().forEach(fury -> fury.register(clz, (short)id));
        this.bindingCallback = this.bindingCallback.andThen(fury -> fury.register(clz, (short)id));
    }

    public void setBindingCallback(Consumer<Fury> bindingCallback) {
        this.bindingCallback = bindingCallback;
    }

    public static enum StagingType {
        NO_STAGING,
        SOFT_STAGING,
        STRONG_STAGING;

    }
}

