/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.proxy;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.event.proxy.server.ServerRegisteredEvent;
import com.velocitypowered.api.event.proxy.server.ServerUnregisteredEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import java.nio.file.Path;
import java.util.List;
import me.mrnavastar.protoweaver.core.util.ProtoLogger;
import me.mrnavastar.protoweaver.proxy.ServerSupplier;
import me.mrnavastar.protoweaver.proxy.api.ProtoProxy;
import me.mrnavastar.protoweaver.proxy.api.ProtoServer;
import org.slf4j.Logger;

@Plugin(id="protoweaver", name="ProtoWeaver", version="1.4.9", authors={"MrNavaStar"})
public class Velocity
implements ServerSupplier,
ProtoLogger.IProtoLogger {
    private final ProxyServer proxy;
    private final Logger logger;
    private final ProtoProxy protoProxy;

    @Inject
    public Velocity(ProxyServer proxyServer, Logger logger, @DataDirectory Path dir) {
        this.proxy = proxyServer;
        this.logger = logger;
        this.protoProxy = new ProtoProxy(this, dir);
        ProtoLogger.setLogger(this);
    }

    @Subscribe
    public void onRegister(ServerRegisteredEvent event) {
        ServerInfo server = event.registeredServer().getServerInfo();
        this.protoProxy.register(new ProtoServer(server.getName(), server.getAddress()));
    }

    @Subscribe
    public void onUnregister(ServerUnregisteredEvent event) {
        ServerInfo server = event.unregisteredServer().getServerInfo();
        this.protoProxy.unregister(new ProtoServer(server.getName(), server.getAddress()));
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.protoProxy.shutdown();
    }

    @Override
    public List<ProtoServer> getServers() {
        return this.proxy.getAllServers().stream().map(server -> new ProtoServer(server.getServerInfo().getName(), server.getServerInfo().getAddress())).toList();
    }

    @Override
    public void info(String message) {
        this.logger.info(message);
    }

    @Override
    public void warn(String message) {
        this.logger.warn(message);
    }

    @Override
    public void err(String message) {
        this.logger.error(message);
    }
}

