/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.proxy.api;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import me.mrnavastar.protoweaver.api.ProtoWeaver;
import me.mrnavastar.protoweaver.api.netty.ProtoConnection;
import me.mrnavastar.protoweaver.api.protocol.Protocol;
import me.mrnavastar.protoweaver.api.protocol.Side;
import me.mrnavastar.protoweaver.client.ProtoClient;
import me.mrnavastar.protoweaver.libs.me.mrnavastar.r.R;
import me.mrnavastar.protoweaver.proxy.ServerSupplier;
import me.mrnavastar.protoweaver.proxy.api.ProtoServer;
import org.jetbrains.annotations.ApiStatus;

public class ProtoProxy {
    private static final ConcurrentHashMap<ProtoServer, ArrayList<ProtoClient>> servers = new ConcurrentHashMap();
    private static int serverPollRate = 5000;
    private final String hostsFile;

    @ApiStatus.Internal
    public ProtoProxy(ServerSupplier serverSupplier, Path dir) {
        this.hostsFile = dir.toAbsolutePath().toString();
        serverSupplier.getServers().forEach(server -> servers.put((ProtoServer)server, new ArrayList()));
        ProtoWeaver.PROTOCOL_LOADED.register(this::startProtocol);
        ProtoWeaver.getLoadedProtocols().forEach(this::startProtocol);
    }

    private void startProtocol(Protocol protocol) {
        if (protocol.toString().equals("protoweaver:internal")) {
            return;
        }
        servers.forEach((server, clients) -> {
            for (ProtoClient client : clients) {
                if (!client.getCurrentProtocol().toString().equals(protocol.toString())) continue;
                return;
            }
            R.of(server).set("clients", clients);
            this.connectClient(protocol, (ProtoServer)server, (ArrayList<ProtoClient>)clients);
        });
    }

    private void connectClient(Protocol protocol, ProtoServer server, ArrayList<ProtoClient> clients) {
        ProtoClient client = new ProtoClient((InetSocketAddress)server.getAddress(), this.hostsFile);
        client.connect(protocol).onConnectionLost(connection -> {
            clients.remove(client);
            if (connection.getDisconnecter().equals((Object)Side.CLIENT)) {
                return;
            }
            Thread.sleep(serverPollRate);
            this.connectClient(protocol, server, clients);
        });
        clients.add(client);
    }

    @ApiStatus.Internal
    public void shutdown() {
        servers.values().forEach(clients -> clients.forEach(ProtoClient::disconnect));
        servers.clear();
    }

    @ApiStatus.Internal
    public void register(ProtoServer server) {
        if (servers.putIfAbsent(server, new ArrayList()) == null) {
            ProtoWeaver.getLoadedProtocols().forEach(this::startProtocol);
        }
    }

    @ApiStatus.Internal
    public void unregister(ProtoServer server) {
        Optional.ofNullable(servers.remove(server)).ifPresent(clients -> clients.forEach(ProtoClient::disconnect));
    }

    public static List<ProtoServer> getRegisteredServers() {
        return servers.keySet().stream().toList();
    }

    public static Optional<ProtoServer> getRegisteredServer(String name) {
        return ProtoProxy.getRegisteredServers().stream().filter(s2 -> s2.getName().equals(name)).findFirst();
    }

    public static Optional<ProtoServer> getRegisteredServer(SocketAddress address) {
        return ProtoProxy.getRegisteredServers().stream().filter(s2 -> s2.getAddress().equals(address)).findFirst();
    }

    public static List<ProtoServer> getConnectedServers(@NonNull Protocol protocol) {
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
        ArrayList<ProtoServer> connected = new ArrayList<ProtoServer>();
        servers.forEach((server, clients) -> clients.stream().filter(c -> protocol.equals(c.getCurrentProtocol()) || c.isConnected()).findFirst().ifPresent(c -> connected.add((ProtoServer)server)));
        return connected;
    }

    public static Optional<ProtoServer> getConnectedServer(ProtoConnection connection) {
        return ProtoProxy.getConnectedServers(connection.getProtocol()).stream().filter(server -> server.getConnection(connection.getProtocol()).map(con -> Objects.equals(con, connection)).orElse(false)).findFirst();
    }

    public static Optional<ProtoServer> getConnectedServer(@NonNull Protocol protocol, String name) {
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
        return ProtoProxy.getConnectedServers(protocol).stream().filter(s2 -> s2.getName().equals(name)).findFirst();
    }

    public static Optional<ProtoServer> getConnectedServer(@NonNull Protocol protocol, SocketAddress address) {
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
        return ProtoProxy.getConnectedServers(protocol).stream().filter(s2 -> s2.getAddress().equals(address)).findFirst();
    }

    @Generated
    public static void setServerPollRate(int serverPollRate) {
        ProtoProxy.serverPollRate = serverPollRate;
    }
}

