/*
 * Decompiled with CFR 0.152.
 */
package me.mrnavastar.protoweaver.proxy.api;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import me.mrnavastar.protoweaver.api.netty.ProtoConnection;
import me.mrnavastar.protoweaver.api.protocol.Protocol;
import me.mrnavastar.protoweaver.client.ProtoClient;

public class ProtoServer {
    private final String name;
    private final SocketAddress address;
    private ArrayList<ProtoClient> clients = new ArrayList();

    public ProtoServer(String name, SocketAddress address) {
        this.name = name;
        this.address = address;
    }

    public boolean isConnected(Protocol protocol) {
        for (ProtoClient client : this.clients) {
            if (!client.isConnected() || !client.getCurrentProtocol().equals(protocol)) continue;
            return true;
        }
        return false;
    }

    public Optional<ProtoConnection> getConnection(Protocol protocol) {
        for (ProtoClient client : this.clients) {
            if (!client.isConnected() || !client.getCurrentProtocol().equals(protocol)) continue;
            return Optional.ofNullable(client.getConnection());
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ProtoServer)) return false;
        ProtoServer server = (ProtoServer)obj;
        if (!Objects.equals(server.name, this.name)) return false;
        return true;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name + " : " + String.valueOf(this.address);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public SocketAddress getAddress() {
        return this.address;
    }
}

