/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.fury.BaseFury;
import org.apache.fury.builder.JITContext;
import org.apache.fury.collection.IdentityMap;
import org.apache.fury.config.CompatibleMode;
import org.apache.fury.config.Config;
import org.apache.fury.config.FuryBuilder;
import org.apache.fury.config.Language;
import org.apache.fury.config.LongEncoding;
import org.apache.fury.io.FuryInputStream;
import org.apache.fury.io.FuryReadableChannel;
import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.MemoryUtils;
import org.apache.fury.resolver.ClassInfo;
import org.apache.fury.resolver.ClassInfoHolder;
import org.apache.fury.resolver.ClassResolver;
import org.apache.fury.resolver.MapRefResolver;
import org.apache.fury.resolver.MetaContext;
import org.apache.fury.resolver.MetaStringResolver;
import org.apache.fury.resolver.NoRefResolver;
import org.apache.fury.resolver.RefResolver;
import org.apache.fury.resolver.SerializationContext;
import org.apache.fury.serializer.ArraySerializers;
import org.apache.fury.serializer.BufferCallback;
import org.apache.fury.serializer.BufferObject;
import org.apache.fury.serializer.OpaqueObjects;
import org.apache.fury.serializer.PrimitiveSerializers;
import org.apache.fury.serializer.Serializer;
import org.apache.fury.serializer.SerializerFactory;
import org.apache.fury.serializer.StringSerializer;
import org.apache.fury.serializer.collection.CollectionSerializers;
import org.apache.fury.serializer.collection.MapSerializers;
import org.apache.fury.type.Generics;
import org.apache.fury.type.Type;
import org.apache.fury.util.ExceptionUtils;
import org.apache.fury.util.Preconditions;
import org.apache.fury.util.StringUtils;

@NotThreadSafe
public final class Fury
implements BaseFury {
    private static final Logger LOG = LoggerFactory.getLogger(Fury.class);
    public static final byte NULL_FLAG = -3;
    public static final byte REF_FLAG = -2;
    public static final byte NOT_NULL_VALUE_FLAG = -1;
    public static final byte REF_VALUE_FLAG = 0;
    public static final byte NOT_SUPPORT_CROSS_LANGUAGE = 0;
    public static final short FURY_TYPE_TAG_ID = Type.FURY_TYPE_TAG.getId();
    private static final byte isNilFlag = 1;
    private static final byte isLittleEndianFlag = 2;
    private static final byte isCrossLanguageFlag = 4;
    private static final byte isOutOfBandFlag = 8;
    private static final boolean isLittleEndian = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final byte BITMAP = (byte)(isLittleEndian ? 2 : 0);
    private static final short MAGIC_NUMBER = 25300;
    private final Config config;
    private final boolean refTracking;
    private final boolean shareMeta;
    private final RefResolver refResolver;
    private final ClassResolver classResolver;
    private final MetaStringResolver metaStringResolver;
    private final SerializationContext serializationContext;
    private final ClassLoader classLoader;
    private final JITContext jitContext;
    private MemoryBuffer buffer;
    private final List<Object> nativeObjects;
    private final StringSerializer stringSerializer;
    private final CollectionSerializers.ArrayListSerializer arrayListSerializer;
    private final MapSerializers.HashMapSerializer hashMapSerializer;
    private final Language language;
    private final boolean compressInt;
    private final LongEncoding longEncoding;
    private final Generics generics;
    private Language peerLanguage;
    private BufferCallback bufferCallback;
    private Iterator<MemoryBuffer> outOfBandBuffers;
    private boolean peerOutOfBandEnabled;
    private int depth;
    private int copyDepth;
    private final boolean copyRefTracking;
    private final IdentityMap<Object, Object> originToCopyMap;
    private int classDefEndOffset;

    public Fury(FuryBuilder builder, ClassLoader classLoader) {
        this.config = new Config(builder);
        this.language = this.config.getLanguage();
        this.refTracking = this.config.trackingRef();
        this.copyRefTracking = this.config.copyRef();
        this.shareMeta = this.config.isMetaShareEnabled();
        this.compressInt = this.config.compressInt();
        this.longEncoding = this.config.longEncoding();
        this.refResolver = this.refTracking ? new MapRefResolver() : new NoRefResolver();
        this.jitContext = new JITContext(this);
        this.metaStringResolver = new MetaStringResolver();
        this.classResolver = new ClassResolver(this);
        this.classResolver.initialize();
        this.serializationContext = new SerializationContext(this.config);
        this.classLoader = classLoader;
        this.nativeObjects = new ArrayList<Object>();
        this.generics = new Generics(this);
        this.stringSerializer = new StringSerializer(this);
        this.arrayListSerializer = new CollectionSerializers.ArrayListSerializer(this);
        this.hashMapSerializer = new MapSerializers.HashMapSerializer(this);
        this.originToCopyMap = new IdentityMap();
        this.classDefEndOffset = -1;
        LOG.info("Created new fury {}", (Object)this);
    }

    @Override
    public void register(Class<?> cls) {
        this.classResolver.register(cls);
    }

    @Override
    public void register(Class<?> cls, boolean createSerializer) {
        this.classResolver.register(cls, createSerializer);
    }

    @Override
    public void register(Class<?> cls, Short id) {
        this.classResolver.register(cls, (int)id.shortValue());
    }

    @Override
    public void register(Class<?> cls, Short id, boolean createSerializer) {
        this.classResolver.register(cls, id, createSerializer);
    }

    public void register(Class<?> cls, String typeTag) {
        this.classResolver.register(cls, typeTag);
    }

    @Override
    public <T> void registerSerializer(Class<T> type, Class<? extends Serializer> serializerClass) {
        this.classResolver.registerSerializer(type, serializerClass);
    }

    @Override
    public void registerSerializer(Class<?> type, Serializer<?> serializer) {
        this.classResolver.registerSerializer(type, serializer);
    }

    @Override
    public void registerSerializer(Class<?> type, Function<Fury, Serializer<?>> serializerCreator) {
        this.classResolver.registerSerializer(type, serializerCreator.apply(this));
    }

    @Override
    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.classResolver.setSerializerFactory(serializerFactory);
    }

    public SerializerFactory getSerializerFactory() {
        return this.classResolver.getSerializerFactory();
    }

    public <T> Serializer<T> getSerializer(Class<T> cls) {
        Preconditions.checkNotNull(cls);
        return this.classResolver.getSerializer(cls);
    }

    @Override
    public MemoryBuffer serialize(Object obj, long address, int size) {
        MemoryBuffer buffer = MemoryUtils.buffer(address, size);
        this.serialize(buffer, obj, null);
        return buffer;
    }

    @Override
    public byte[] serialize(Object obj) {
        MemoryBuffer buf = this.getBuffer();
        buf.writerIndex(0);
        this.serialize(buf, obj, null);
        byte[] bytes = buf.getBytes(0, buf.writerIndex());
        this.resetBuffer();
        return bytes;
    }

    @Override
    public byte[] serialize(Object obj, BufferCallback callback) {
        MemoryBuffer buf = this.getBuffer();
        buf.writerIndex(0);
        this.serialize(buf, obj, callback);
        byte[] bytes = buf.getBytes(0, buf.writerIndex());
        this.resetBuffer();
        return bytes;
    }

    @Override
    public MemoryBuffer serialize(MemoryBuffer buffer, Object obj) {
        return this.serialize(buffer, obj, null);
    }

    @Override
    public MemoryBuffer serialize(MemoryBuffer buffer, Object obj, BufferCallback callback) {
        if (this.language == Language.XLANG) {
            buffer.writeInt16((short)25300);
        }
        byte bitmap = BITMAP;
        if (this.language != Language.JAVA) {
            bitmap = (byte)(bitmap | 4);
        }
        if (obj == null) {
            bitmap = (byte)(bitmap | 1);
            buffer.writeByte(bitmap);
            return buffer;
        }
        if (callback != null) {
            bitmap = (byte)(bitmap | 8);
            this.bufferCallback = callback;
        }
        buffer.writeByte(bitmap);
        try {
            this.jitContext.lock();
            if (this.depth != 0) {
                this.throwDepthSerializationException();
            }
            if (this.language == Language.JAVA) {
                this.write(buffer, obj);
            } else {
                buffer.writeByte((byte)Language.JAVA.ordinal());
                this.xserializeInternal(buffer, obj);
            }
            MemoryBuffer memoryBuffer = buffer;
            return memoryBuffer;
        }
        catch (StackOverflowError t2) {
            throw this.processStackOverflowError(t2);
        }
        finally {
            this.resetWrite();
            this.jitContext.unlock();
        }
    }

    @Override
    public void serialize(OutputStream outputStream, Object obj) {
        this.serializeToStream(outputStream, buf -> this.serialize((MemoryBuffer)buf, obj, null));
    }

    @Override
    public void serialize(OutputStream outputStream, Object obj, BufferCallback callback) {
        this.serializeToStream(outputStream, buf -> this.serialize((MemoryBuffer)buf, obj, callback));
    }

    private StackOverflowError processStackOverflowError(StackOverflowError e) {
        if (!this.refTracking) {
            StackOverflowError t1;
            String msg = "Object may contain circular references, please enable ref tracking by `FuryBuilder#withRefTracking(true)`";
            String rawMessage = e.getMessage();
            if (StringUtils.isNotBlank(rawMessage)) {
                msg = msg + ": " + rawMessage;
            }
            if ((t1 = ExceptionUtils.trySetStackOverflowErrorMessage(e, msg)) != null) {
                return t1;
            }
        }
        throw e;
    }

    private StackOverflowError processCopyStackOverflowError(StackOverflowError e) {
        String msg;
        StackOverflowError t1;
        if (!this.copyRefTracking && (t1 = ExceptionUtils.trySetStackOverflowErrorMessage(e, msg = "Object may contain circular references, please enable ref tracking by `FuryBuilder#withRefCopy(true)`")) != null) {
            return t1;
        }
        throw e;
    }

    public MemoryBuffer getBuffer() {
        MemoryBuffer buf = this.buffer;
        if (buf == null) {
            buf = this.buffer = MemoryBuffer.newHeapBuffer(64);
        }
        return buf;
    }

    public void resetBuffer() {
        MemoryBuffer buf = this.buffer;
        if (buf != null && buf.size() > this.config.bufferSizeLimitBytes()) {
            this.buffer = MemoryBuffer.newHeapBuffer(this.config.bufferSizeLimitBytes());
        }
    }

    private void write(MemoryBuffer buffer, Object obj) {
        int startOffset = buffer.writerIndex();
        if (this.shareMeta) {
            buffer.writeInt32(-1);
        }
        if (!this.refResolver.writeRefOrNull(buffer, obj)) {
            ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
            this.classResolver.writeClass(buffer, classInfo);
            this.writeData(buffer, classInfo, obj);
        }
        MetaContext metaContext = this.serializationContext.getMetaContext();
        if (this.shareMeta && metaContext != null && !metaContext.writingClassDefs.isEmpty()) {
            buffer.putInt32(startOffset, buffer.writerIndex() - startOffset - 4);
            this.classResolver.writeClassDefs(buffer);
        }
    }

    private void xserializeInternal(MemoryBuffer buffer, Object obj) {
        int startOffset = buffer.writerIndex();
        buffer.writeInt32(-1);
        buffer.writeInt32(-1);
        this.xwriteRef(buffer, obj);
        buffer.putInt32(startOffset, buffer.writerIndex());
        buffer.putInt32(startOffset + 4, this.nativeObjects.size());
        this.refResolver.resetWrite();
        this.classResolver.resetWrite();
        this.metaStringResolver.resetWrite();
        for (Object nativeObject : this.nativeObjects) {
            this.writeRef(buffer, nativeObject);
        }
    }

    public void writeRef(MemoryBuffer buffer, Object obj) {
        if (!this.refResolver.writeRefOrNull(buffer, obj)) {
            ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
            this.classResolver.writeClass(buffer, classInfo);
            this.writeData(buffer, classInfo, obj);
        }
    }

    public void writeRef(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
        if (!this.refResolver.writeRefOrNull(buffer, obj)) {
            ClassInfo classInfo = this.classResolver.getClassInfo(obj.getClass(), classInfoHolder);
            this.classResolver.writeClass(buffer, classInfo);
            this.writeData(buffer, classInfo, obj);
        }
    }

    public void writeRef(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
        Serializer<Object> serializer = classInfo.getSerializer();
        if (serializer.needToWriteRef()) {
            if (!this.refResolver.writeRefOrNull(buffer, obj)) {
                this.classResolver.writeClass(buffer, classInfo);
                ++this.depth;
                serializer.write(buffer, obj);
                --this.depth;
            }
        } else if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.classResolver.writeClass(buffer, classInfo);
            ++this.depth;
            serializer.write(buffer, obj);
            --this.depth;
        }
    }

    public <T> void writeRef(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
        if (serializer.needToWriteRef()) {
            if (!this.refResolver.writeRefOrNull(buffer, obj)) {
                ++this.depth;
                serializer.write(buffer, obj);
                --this.depth;
            }
        } else if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            ++this.depth;
            serializer.write(buffer, obj);
            --this.depth;
        }
    }

    public void writeNullable(MemoryBuffer buffer, Object obj) {
        if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.writeNonRef(buffer, obj);
        }
    }

    public void writeNullable(MemoryBuffer buffer, Object obj, Serializer serializer) {
        if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            serializer.write(buffer, obj);
        }
    }

    public void writeNullable(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
        if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.writeNonRef(buffer, obj, this.classResolver.getClassInfo(obj.getClass(), classInfoHolder));
        }
    }

    public void writeNullable(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
        if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.writeNonRef(buffer, obj, classInfo);
        }
    }

    public void writeNonRef(MemoryBuffer buffer, Object obj) {
        ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
        this.classResolver.writeClass(buffer, classInfo);
        this.writeData(buffer, classInfo, obj);
    }

    public void writeNonRef(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
        this.classResolver.writeClass(buffer, classInfo);
        Serializer<Object> serializer = classInfo.getSerializer();
        ++this.depth;
        serializer.write(buffer, obj);
        --this.depth;
    }

    public <T> void writeNonRef(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
        ++this.depth;
        serializer.write(buffer, obj);
        --this.depth;
    }

    public void xwriteRef(MemoryBuffer buffer, Object obj) {
        if (!this.refResolver.writeRefOrNull(buffer, obj)) {
            this.xwriteNonRef(buffer, obj, null);
        }
    }

    public <T> void xwriteRef(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
        if (serializer.needToWriteRef()) {
            if (!this.refResolver.writeRefOrNull(buffer, obj)) {
                this.xwriteNonRef(buffer, obj, serializer);
            }
        } else if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.xwriteNonRef(buffer, obj, serializer);
        }
    }

    public <T> void xwriteRefByNullableSerializer(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
        if (serializer == null) {
            this.xwriteRef(buffer, obj);
        } else {
            this.xwriteRef(buffer, obj, serializer);
        }
    }

    public <T> void xwriteNonRef(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
        ++this.depth;
        Class<?> cls = obj.getClass();
        if (serializer == null) {
            serializer = this.classResolver.getSerializer(cls);
        }
        short typeId = serializer.getXtypeId();
        buffer.writeInt16(typeId);
        if (typeId != 0) {
            if (typeId == FURY_TYPE_TAG_ID) {
                this.classResolver.xwriteTypeTag(buffer, cls);
            }
            if (typeId < 0) {
                this.classResolver.xwriteClass(buffer, cls);
            }
            serializer.xwrite(buffer, obj);
        } else {
            this.classResolver.xwriteClass(buffer, cls);
            buffer.writeVarUint32(this.nativeObjects.size());
            this.nativeObjects.add(obj);
        }
        --this.depth;
    }

    private void writeData(MemoryBuffer buffer, ClassInfo classInfo, Object obj) {
        switch (classInfo.getClassId()) {
            case 14: {
                buffer.writeBoolean((Boolean)obj);
                break;
            }
            case 15: {
                buffer.writeByte((Byte)obj);
                break;
            }
            case 16: {
                buffer.writeChar(((Character)obj).charValue());
                break;
            }
            case 17: {
                buffer.writeInt16((Short)obj);
                break;
            }
            case 18: {
                if (this.compressInt) {
                    buffer.writeVarInt32((Integer)obj);
                    break;
                }
                buffer.writeInt32((Integer)obj);
                break;
            }
            case 19: {
                buffer.writeFloat32(((Float)obj).floatValue());
                break;
            }
            case 20: {
                PrimitiveSerializers.LongSerializer.writeInt64(buffer, (Long)obj, this.longEncoding);
                break;
            }
            case 21: {
                buffer.writeFloat64((Double)obj);
                break;
            }
            case 22: {
                this.stringSerializer.writeJavaString(buffer, (String)obj);
                break;
            }
            default: {
                ++this.depth;
                classInfo.getSerializer().write(buffer, obj);
                --this.depth;
            }
        }
    }

    public void writeBufferObject(MemoryBuffer buffer, BufferObject bufferObject) {
        if (this.bufferCallback == null || this.bufferCallback.apply(bufferObject)) {
            buffer.writeBoolean(true);
            int totalBytes = bufferObject.totalBytes();
            if (this.language == Language.JAVA) {
                buffer.writeVarUint32Aligned(totalBytes);
            } else {
                buffer.writeVarUint32(totalBytes);
            }
            int writerIndex = buffer.writerIndex();
            buffer.ensure(writerIndex + bufferObject.totalBytes());
            bufferObject.writeTo(buffer);
            int size = buffer.writerIndex() - writerIndex;
            Preconditions.checkArgument(size == totalBytes);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public void writeBufferObject(MemoryBuffer buffer, ArraySerializers.PrimitiveArrayBufferObject bufferObject) {
        if (this.bufferCallback == null || this.bufferCallback.apply(bufferObject)) {
            buffer.writeBoolean(true);
            int totalBytes = bufferObject.totalBytes();
            if (this.language == Language.JAVA) {
                buffer.writeVarUint32Aligned(totalBytes);
            } else {
                buffer.writeVarUint32(totalBytes);
            }
            bufferObject.writeTo(buffer);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public MemoryBuffer readBufferObject(MemoryBuffer buffer) {
        boolean inBand = buffer.readBoolean();
        if (inBand) {
            int size = this.language == Language.JAVA ? buffer.readAlignedVarUint() : buffer.readVarUint32();
            MemoryBuffer slice = buffer.slice(buffer.readerIndex(), size);
            buffer.readerIndex(buffer.readerIndex() + size);
            return slice;
        }
        Preconditions.checkArgument(this.outOfBandBuffers.hasNext());
        return this.outOfBandBuffers.next();
    }

    public void writeString(MemoryBuffer buffer, String str) {
        this.stringSerializer.writeString(buffer, str);
    }

    public String readString(MemoryBuffer buffer) {
        return this.stringSerializer.readString(buffer);
    }

    public void writeJavaStringRef(MemoryBuffer buffer, String str) {
        if (this.stringSerializer.needToWriteRef()) {
            if (!this.refResolver.writeRefOrNull(buffer, str)) {
                this.stringSerializer.writeJavaString(buffer, str);
            }
        } else if (str == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.stringSerializer.write(buffer, str);
        }
    }

    public String readJavaStringRef(MemoryBuffer buffer) {
        RefResolver refResolver = this.refResolver;
        if (this.stringSerializer.needToWriteRef()) {
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                String obj = this.stringSerializer.read(buffer);
                refResolver.setReadObject(nextReadRefId, obj);
                return obj;
            }
            return (String)refResolver.getReadObject();
        }
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return this.stringSerializer.read(buffer);
    }

    public void writeJavaString(MemoryBuffer buffer, String str) {
        this.stringSerializer.writeJavaString(buffer, str);
    }

    public String readJavaString(MemoryBuffer buffer) {
        return this.stringSerializer.readJavaString(buffer);
    }

    public void writeInt64(MemoryBuffer buffer, long value) {
        PrimitiveSerializers.LongSerializer.writeInt64(buffer, value, this.longEncoding);
    }

    public long readInt64(MemoryBuffer buffer) {
        return PrimitiveSerializers.LongSerializer.readInt64(buffer, this.longEncoding);
    }

    @Override
    public Object deserialize(byte[] bytes) {
        return this.deserialize(MemoryUtils.wrap(bytes), null);
    }

    @Override
    public Object deserialize(byte[] bytes, Iterable<MemoryBuffer> outOfBandBuffers) {
        return this.deserialize(MemoryUtils.wrap(bytes), outOfBandBuffers);
    }

    @Override
    public Object deserialize(long address, int size) {
        return this.deserialize(MemoryUtils.buffer(address, size), null);
    }

    @Override
    public Object deserialize(MemoryBuffer buffer) {
        return this.deserialize(buffer, null);
    }

    @Override
    public Object deserialize(MemoryBuffer buffer, Iterable<MemoryBuffer> outOfBandBuffers) {
        try {
            Object obj;
            byte bitmap;
            this.jitContext.lock();
            if (this.depth != 0) {
                this.throwDepthDeserializationException();
            }
            if (this.language == Language.XLANG) {
                short magicNumber = buffer.readInt16();
                assert (magicNumber == 25300) : String.format("The fury xlang serialization must start with magic number 0x%x. Please check whether the serialization is based on the xlang protocol and the data didn't corrupt.", (short)25300);
            }
            if (((bitmap = buffer.readByte()) & 1) == 1) {
                Object var4_5 = null;
                return var4_5;
            }
            Preconditions.checkArgument(isLittleEndian, "Non-Little-Endian format detected. Only Little-Endian is supported.");
            boolean isTargetXLang = (bitmap & 4) == 4;
            this.peerLanguage = isTargetXLang ? Language.values()[buffer.readByte()] : Language.JAVA;
            boolean bl = this.peerOutOfBandEnabled = (bitmap & 8) == 8;
            if (this.peerOutOfBandEnabled) {
                Preconditions.checkNotNull(outOfBandBuffers, "outOfBandBuffers shouldn't be null when the serialized stream is produced with bufferCallback not null.");
                this.outOfBandBuffers = outOfBandBuffers.iterator();
            } else {
                Preconditions.checkArgument(outOfBandBuffers == null, "outOfBandBuffers should be null when the serialized stream is produced with bufferCallback null.");
            }
            if (isTargetXLang) {
                obj = this.xdeserializeInternal(buffer);
            } else {
                if (this.shareMeta) {
                    this.readClassDefs(buffer);
                }
                obj = this.readRef(buffer);
            }
            Object object = obj;
            return object;
        }
        catch (Throwable t2) {
            throw ExceptionUtils.handleReadFailed(this, t2);
        }
        finally {
            if (this.classDefEndOffset != -1) {
                buffer.readerIndex(this.classDefEndOffset);
            }
            this.resetRead();
            this.jitContext.unlock();
        }
    }

    @Override
    public Object deserialize(FuryInputStream inputStream) {
        return this.deserialize(inputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object deserialize(FuryInputStream inputStream, Iterable<MemoryBuffer> outOfBandBuffers) {
        try {
            MemoryBuffer buf = inputStream.getBuffer();
            Object object = this.deserialize(buf, outOfBandBuffers);
            return object;
        }
        finally {
            inputStream.shrinkBuffer();
        }
    }

    @Override
    public Object deserialize(FuryReadableChannel channel) {
        return this.deserialize(channel, null);
    }

    @Override
    public Object deserialize(FuryReadableChannel channel, Iterable<MemoryBuffer> outOfBandBuffers) {
        MemoryBuffer buf = channel.getBuffer();
        return this.deserialize(buf, outOfBandBuffers);
    }

    private Object xdeserializeInternal(MemoryBuffer buffer) {
        int nativeObjectsStartOffset = buffer.readInt32();
        int nativeObjectsSize = buffer.readInt32();
        int endReaderIndex = nativeObjectsStartOffset;
        if (this.peerLanguage == Language.JAVA) {
            int readerIndex = buffer.readerIndex();
            buffer.readerIndex(nativeObjectsStartOffset);
            for (int i = 0; i < nativeObjectsSize; ++i) {
                this.nativeObjects.add(this.readRef(buffer));
            }
            endReaderIndex = buffer.readerIndex();
            buffer.readerIndex(readerIndex);
            this.refResolver.resetRead();
            this.classResolver.resetRead();
            this.metaStringResolver.resetRead();
        }
        Object obj = this.xreadRef(buffer);
        buffer.readerIndex(endReaderIndex);
        return obj;
    }

    public Object readRef(MemoryBuffer buffer) {
        RefResolver refResolver = this.refResolver;
        int nextReadRefId = refResolver.tryPreserveRefId(buffer);
        if (nextReadRefId >= -1) {
            Object o = this.readDataInternal(buffer, this.classResolver.readClassInfo(buffer));
            refResolver.setReadObject(nextReadRefId, o);
            return o;
        }
        return refResolver.getReadObject();
    }

    public Object readRef(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        RefResolver refResolver = this.refResolver;
        int nextReadRefId = refResolver.tryPreserveRefId(buffer);
        if (nextReadRefId >= -1) {
            Object o = this.readDataInternal(buffer, this.classResolver.readClassInfo(buffer, classInfoHolder));
            refResolver.setReadObject(nextReadRefId, o);
            return o;
        }
        return refResolver.getReadObject();
    }

    public <T> T readRef(MemoryBuffer buffer, Serializer<T> serializer) {
        if (serializer.needToWriteRef()) {
            int nextReadRefId = this.refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                T obj = serializer.read(buffer);
                this.refResolver.setReadObject(nextReadRefId, obj);
                return obj;
            }
            return (T)this.refResolver.getReadObject();
        }
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return serializer.read(buffer);
    }

    public Object readNonRef(MemoryBuffer buffer) {
        return this.readDataInternal(buffer, this.classResolver.readClassInfo(buffer));
    }

    public Object readNonRef(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        return this.readDataInternal(buffer, this.classResolver.readClassInfo(buffer, classInfoHolder));
    }

    public Object readNullable(MemoryBuffer buffer) {
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return this.readNonRef(buffer);
    }

    public Object readNullable(MemoryBuffer buffer, Serializer serializer) {
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return serializer.read(buffer);
    }

    public Object readNullable(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return this.readNonRef(buffer, classInfoHolder);
    }

    public Object readData(MemoryBuffer buffer, ClassInfo classInfo) {
        ++this.depth;
        Serializer serializer = classInfo.getSerializer();
        Object read = serializer.read(buffer);
        --this.depth;
        return read;
    }

    private Object readDataInternal(MemoryBuffer buffer, ClassInfo classInfo) {
        switch (classInfo.getClassId()) {
            case 14: {
                return buffer.readBoolean();
            }
            case 15: {
                return buffer.readByte();
            }
            case 16: {
                return Character.valueOf(buffer.readChar());
            }
            case 17: {
                return buffer.readInt16();
            }
            case 18: {
                if (this.compressInt) {
                    return buffer.readVarInt32();
                }
                return buffer.readInt32();
            }
            case 19: {
                return Float.valueOf(buffer.readFloat32());
            }
            case 20: {
                return PrimitiveSerializers.LongSerializer.readInt64(buffer, this.longEncoding);
            }
            case 21: {
                return buffer.readFloat64();
            }
            case 22: {
                return this.stringSerializer.readJavaString(buffer);
            }
        }
        ++this.depth;
        Object read = classInfo.getSerializer().read(buffer);
        --this.depth;
        return read;
    }

    public Object xreadRef(MemoryBuffer buffer) {
        RefResolver refResolver = this.refResolver;
        int nextReadRefId = refResolver.tryPreserveRefId(buffer);
        if (nextReadRefId >= -1) {
            Object o = this.xreadNonRef(buffer, null);
            refResolver.setReadObject(nextReadRefId, o);
            return o;
        }
        return refResolver.getReadObject();
    }

    public Object xreadRef(MemoryBuffer buffer, Serializer<?> serializer) {
        if (serializer.needToWriteRef()) {
            RefResolver refResolver = this.refResolver;
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                Object o = this.xreadNonRef(buffer, serializer);
                refResolver.setReadObject(nextReadRefId, o);
                return o;
            }
            return refResolver.getReadObject();
        }
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return this.xreadNonRef(buffer, serializer);
    }

    public Object xreadRefByNullableSerializer(MemoryBuffer buffer, Serializer<?> serializer) {
        if (serializer == null) {
            return this.xreadRef(buffer);
        }
        return this.xreadRef(buffer, serializer);
    }

    public Object xreadNonRef(MemoryBuffer buffer, Serializer<?> serializer) {
        ++this.depth;
        short typeId = buffer.readInt16();
        ClassResolver classResolver = this.classResolver;
        if (typeId != 0) {
            Class<?> cls = null;
            if (typeId == FURY_TYPE_TAG_ID) {
                cls = classResolver.readClassByTypeTag(buffer);
            }
            if (typeId < 0) {
                if (this.peerLanguage != Language.JAVA) {
                    classResolver.xreadClassName(buffer);
                    cls = classResolver.getClassByTypeId(-typeId);
                } else {
                    cls = classResolver.xreadClass(buffer);
                }
            } else if (typeId != FURY_TYPE_TAG_ID) {
                cls = classResolver.getClassByTypeId(typeId);
            }
            Preconditions.checkNotNull(cls);
            if (serializer == null) {
                serializer = classResolver.getSerializer(cls);
            }
            Object o = serializer.xread(buffer);
            --this.depth;
            return o;
        }
        String className = classResolver.xreadClassName(buffer);
        int ordinal = buffer.readVarUint32();
        if (this.peerLanguage != Language.JAVA) {
            return OpaqueObjects.of(this.peerLanguage, className, ordinal);
        }
        return this.nativeObjects.get(ordinal);
    }

    @Override
    public byte[] serializeJavaObject(Object obj) {
        MemoryBuffer buf = this.getBuffer();
        buf.writerIndex(0);
        this.serializeJavaObject(buf, obj);
        byte[] bytes = buf.getBytes(0, buf.writerIndex());
        this.resetBuffer();
        return bytes;
    }

    @Override
    public void serializeJavaObject(MemoryBuffer buffer, Object obj) {
        try {
            this.jitContext.lock();
            if (this.depth != 0) {
                this.throwDepthSerializationException();
            }
            if (this.config.isMetaShareEnabled()) {
                int startOffset = buffer.writerIndex();
                buffer.writeInt32(-1);
                if (!this.refResolver.writeRefOrNull(buffer, obj)) {
                    ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
                    this.classResolver.writeClass(buffer, classInfo);
                    this.writeData(buffer, classInfo, obj);
                    MetaContext metaContext = this.serializationContext.getMetaContext();
                    if (metaContext != null && !metaContext.writingClassDefs.isEmpty()) {
                        buffer.putInt32(startOffset, buffer.writerIndex() - startOffset - 4);
                        this.classResolver.writeClassDefs(buffer);
                    }
                }
            } else if (!this.refResolver.writeRefOrNull(buffer, obj)) {
                ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
                this.writeData(buffer, classInfo, obj);
            }
        }
        catch (StackOverflowError t2) {
            throw this.processStackOverflowError(t2);
        }
        finally {
            this.resetWrite();
            this.jitContext.unlock();
        }
    }

    @Override
    public void serializeJavaObject(OutputStream outputStream, Object obj) {
        this.serializeToStream(outputStream, buf -> this.serializeJavaObject((MemoryBuffer)buf, obj));
    }

    @Override
    public <T> T deserializeJavaObject(byte[] data, Class<T> cls) {
        return this.deserializeJavaObject(MemoryBuffer.fromByteArray(data), cls);
    }

    @Override
    public <T> T deserializeJavaObject(MemoryBuffer buffer, Class<T> cls) {
        try {
            int nextReadRefId;
            this.jitContext.lock();
            if (this.depth != 0) {
                this.throwDepthDeserializationException();
            }
            if (this.shareMeta) {
                this.readClassDefs(buffer);
            }
            if ((nextReadRefId = this.refResolver.tryPreserveRefId(buffer)) >= -1) {
                Object obj;
                ClassInfo classInfo = this.shareMeta ? this.classResolver.readClassInfoWithMetaShare(buffer, cls) : this.classResolver.getClassInfo(cls);
                Object object = obj = this.readDataInternal(buffer, classInfo);
                return (T)object;
            }
            T t2 = null;
            return t2;
        }
        catch (Throwable t3) {
            throw ExceptionUtils.handleReadFailed(this, t3);
        }
        finally {
            if (this.classDefEndOffset != -1) {
                buffer.readerIndex(this.classDefEndOffset);
            }
            this.resetRead();
            this.jitContext.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserializeJavaObject(FuryInputStream inputStream, Class<T> cls) {
        try {
            MemoryBuffer buf = inputStream.getBuffer();
            T t2 = this.deserializeJavaObject(buf, cls);
            return t2;
        }
        finally {
            inputStream.shrinkBuffer();
        }
    }

    @Override
    public <T> T deserializeJavaObject(FuryReadableChannel channel, Class<T> cls) {
        MemoryBuffer buf = channel.getBuffer();
        return this.deserializeJavaObject(buf, cls);
    }

    @Override
    public byte[] serializeJavaObjectAndClass(Object obj) {
        MemoryBuffer buf = this.getBuffer();
        buf.writerIndex(0);
        this.serializeJavaObjectAndClass(buf, obj);
        byte[] bytes = buf.getBytes(0, buf.writerIndex());
        this.resetBuffer();
        return bytes;
    }

    @Override
    public void serializeJavaObjectAndClass(MemoryBuffer buffer, Object obj) {
        try {
            this.jitContext.lock();
            if (this.depth != 0) {
                this.throwDepthSerializationException();
            }
            this.write(buffer, obj);
        }
        catch (StackOverflowError t2) {
            throw this.processStackOverflowError(t2);
        }
        finally {
            this.resetWrite();
            this.jitContext.unlock();
        }
    }

    @Override
    public void serializeJavaObjectAndClass(OutputStream outputStream, Object obj) {
        this.serializeToStream(outputStream, buf -> this.serializeJavaObjectAndClass((MemoryBuffer)buf, obj));
    }

    @Override
    public Object deserializeJavaObjectAndClass(byte[] data) {
        return this.deserializeJavaObjectAndClass(MemoryBuffer.fromByteArray(data));
    }

    @Override
    public Object deserializeJavaObjectAndClass(MemoryBuffer buffer) {
        try {
            this.jitContext.lock();
            if (this.depth != 0) {
                this.throwDepthDeserializationException();
            }
            if (this.shareMeta) {
                this.readClassDefs(buffer);
            }
            Object object = this.readRef(buffer);
            return object;
        }
        catch (Throwable t2) {
            throw ExceptionUtils.handleReadFailed(this, t2);
        }
        finally {
            if (this.classDefEndOffset != -1) {
                buffer.readerIndex(this.classDefEndOffset);
            }
            this.resetRead();
            this.jitContext.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object deserializeJavaObjectAndClass(FuryInputStream inputStream) {
        try {
            MemoryBuffer buf = inputStream.getBuffer();
            Object object = this.deserializeJavaObjectAndClass(buf);
            return object;
        }
        finally {
            inputStream.shrinkBuffer();
        }
    }

    @Override
    public Object deserializeJavaObjectAndClass(FuryReadableChannel channel) {
        MemoryBuffer buf = channel.getBuffer();
        return this.deserializeJavaObjectAndClass(buf);
    }

    @Override
    public <T> T copy(T obj) {
        try {
            T t2 = this.copyObject(obj);
            return t2;
        }
        catch (StackOverflowError e) {
            throw this.processCopyStackOverflowError(e);
        }
        finally {
            if (this.copyRefTracking) {
                this.resetCopy();
            }
        }
    }

    public <T> T copyObject(T obj) {
        Cloneable copy;
        if (obj == null) {
            return null;
        }
        ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
        switch (classInfo.getClassId()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return obj;
            }
            case 23: {
                boolean[] boolArr = (boolean[])obj;
                return (T)Arrays.copyOf(boolArr, boolArr.length);
            }
            case 24: {
                byte[] byteArr = (byte[])obj;
                return (T)Arrays.copyOf(byteArr, byteArr.length);
            }
            case 25: {
                char[] charArr = (char[])obj;
                return (T)Arrays.copyOf(charArr, charArr.length);
            }
            case 26: {
                short[] shortArr = (short[])obj;
                return (T)Arrays.copyOf(shortArr, shortArr.length);
            }
            case 27: {
                int[] intArr = (int[])obj;
                return (T)Arrays.copyOf(intArr, intArr.length);
            }
            case 28: {
                float[] floatArr = (float[])obj;
                return (T)Arrays.copyOf(floatArr, floatArr.length);
            }
            case 29: {
                long[] longArr = (long[])obj;
                return (T)Arrays.copyOf(longArr, longArr.length);
            }
            case 30: {
                double[] doubleArr = (double[])obj;
                return (T)Arrays.copyOf(doubleArr, doubleArr.length);
            }
            case 31: {
                String[] stringArr = (String[])obj;
                return (T)Arrays.copyOf(stringArr, stringArr.length);
            }
            case 33: {
                copy = this.arrayListSerializer.copy((ArrayList)obj);
                break;
            }
            case 34: {
                copy = this.hashMapSerializer.copy((HashMap)obj);
                break;
            }
            default: {
                copy = this.copyObject(obj, classInfo.getSerializer());
            }
        }
        return (T)copy;
    }

    public <T> T copyObject(T obj, int classId) {
        if (obj == null) {
            return null;
        }
        switch (classId) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return obj;
            }
        }
        return this.copyObject(obj, this.classResolver.getOrUpdateClassInfo(obj.getClass()).getSerializer());
    }

    public <T> T copyObject(T obj, Serializer<T> serializer) {
        T copyObject;
        ++this.copyDepth;
        if (serializer.needToCopyRef()) {
            copyObject = this.getCopyObject(obj);
            if (copyObject == null) {
                copyObject = serializer.copy(obj);
                this.originToCopyMap.put(obj, copyObject);
            }
        } else {
            copyObject = serializer.copy(obj);
        }
        --this.copyDepth;
        return copyObject;
    }

    public <T> void reference(T o1, T o2) {
        if (o1 != null) {
            this.originToCopyMap.put(o1, o2);
        }
    }

    public <T> T getCopyObject(T originObj) {
        return (T)this.originToCopyMap.get(originObj);
    }

    private void serializeToStream(OutputStream outputStream, Consumer<MemoryBuffer> function) {
        MemoryBuffer buf = this.getBuffer();
        if (outputStream.getClass() == ByteArrayOutputStream.class) {
            byte[] oldBytes = buf.getHeapMemory();
            assert (oldBytes != null);
            MemoryUtils.wrap((ByteArrayOutputStream)outputStream, buf);
            function.accept(buf);
            MemoryUtils.wrap(buf, (ByteArrayOutputStream)outputStream);
            buf.pointTo(oldBytes, 0, oldBytes.length);
        } else {
            buf.writerIndex(0);
            function.accept(buf);
            try {
                byte[] bytes = buf.getHeapMemory();
                if (bytes != null) {
                    outputStream.write(bytes, 0, buf.writerIndex());
                } else {
                    outputStream.write(buf.getBytes(0, buf.writerIndex()));
                }
                outputStream.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.resetBuffer();
            }
        }
    }

    private void readClassDefs(MemoryBuffer buffer) {
        int relativeClassDefOffset = buffer.readInt32();
        if (relativeClassDefOffset == -1) {
            return;
        }
        int readerIndex = buffer.readerIndex();
        buffer.readerIndex(readerIndex + relativeClassDefOffset);
        this.classResolver.readClassDefs(buffer);
        this.classDefEndOffset = buffer.readerIndex();
        buffer.readerIndex(readerIndex);
    }

    public void reset() {
        this.refResolver.reset();
        this.classResolver.reset();
        this.metaStringResolver.reset();
        this.serializationContext.reset();
        this.nativeObjects.clear();
        this.peerOutOfBandEnabled = false;
        this.bufferCallback = null;
        this.depth = 0;
        this.resetCopy();
    }

    public void resetWrite() {
        this.refResolver.resetWrite();
        this.classResolver.resetWrite();
        this.metaStringResolver.resetWrite();
        this.serializationContext.resetWrite();
        this.nativeObjects.clear();
        this.bufferCallback = null;
        this.depth = 0;
    }

    public void resetRead() {
        this.refResolver.resetRead();
        this.classResolver.resetRead();
        this.metaStringResolver.resetRead();
        this.serializationContext.resetRead();
        this.nativeObjects.clear();
        this.peerOutOfBandEnabled = false;
        this.depth = 0;
        this.classDefEndOffset = -1;
    }

    public void resetCopy() {
        this.originToCopyMap.clear();
        this.copyDepth = 0;
    }

    private void throwDepthSerializationException() {
        String method = "Fury#" + (this.language != Language.JAVA ? "x" : "") + "writeXXX";
        throw new IllegalStateException(String.format("Nested call Fury.serializeXXX is not allowed when serializing, Please use %s instead", method));
    }

    private void throwDepthDeserializationException() {
        String method = "Fury#" + (this.language != Language.JAVA ? "x" : "") + "readXXX";
        throw new IllegalStateException(String.format("Nested call Fury.deserializeXXX is not allowed when deserializing, Please use %s instead", method));
    }

    public JITContext getJITContext() {
        return this.jitContext;
    }

    public BufferCallback getBufferCallback() {
        return this.bufferCallback;
    }

    public boolean isPeerOutOfBandEnabled() {
        return this.peerOutOfBandEnabled;
    }

    public RefResolver getRefResolver() {
        return this.refResolver;
    }

    public ClassResolver getClassResolver() {
        return this.classResolver;
    }

    public MetaStringResolver getMetaStringResolver() {
        return this.metaStringResolver;
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    public Generics getGenerics() {
        return this.generics;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void incDepth(int diff) {
        this.depth += diff;
    }

    public void incCopyDepth(int diff) {
        this.copyDepth += diff;
    }

    public StringSerializer getStringSerializer() {
        return this.stringSerializer;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Language getLanguage() {
        return this.language;
    }

    public boolean trackingRef() {
        return this.refTracking;
    }

    public boolean copyTrackingRef() {
        return this.copyRefTracking;
    }

    public boolean isStringRefIgnored() {
        return this.config.isStringRefIgnored();
    }

    public boolean isBasicTypesRefIgnored() {
        return this.config.isBasicTypesRefIgnored();
    }

    public boolean checkClassVersion() {
        return this.config.checkClassVersion();
    }

    public CompatibleMode getCompatibleMode() {
        return this.config.getCompatibleMode();
    }

    public Config getConfig() {
        return this.config;
    }

    public Class<? extends Serializer> getDefaultJDKStreamSerializerType() {
        return this.config.getDefaultJDKStreamSerializerType();
    }

    public boolean compressString() {
        return this.config.compressString();
    }

    public boolean compressInt() {
        return this.compressInt;
    }

    public LongEncoding longEncoding() {
        return this.longEncoding;
    }

    public boolean compressLong() {
        return this.config.compressLong();
    }

    public static FuryBuilder builder() {
        return new FuryBuilder();
    }
}

