/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.fury.Fury;
import org.apache.fury.annotation.Internal;
import org.apache.fury.codegen.CodeGenerator;
import org.apache.fury.memory.Platform;
import org.apache.fury.util.Preconditions;

public class JITContext {
    private final Fury fury;
    private final boolean asyncCompilationEnabled;
    private final ReentrantLock jitLock;
    private int furyVisitState;
    private int numRunningTask;
    private final Map<Object, List<NotifyCallback>> hasJITResult;

    public JITContext(Fury fury) {
        this.fury = fury;
        this.asyncCompilationEnabled = fury.getConfig().isAsyncCompilationEnabled();
        this.jitLock = new ReentrantLock(true);
        this.hasJITResult = new HashMap<Object, List<NotifyCallback>>();
    }

    @Internal
    public <T> T registerSerializerJITCallback(Callable<T> interpreterModeAction, Callable<T> jitAction, SerializerJITCallback<T> callback) {
        try {
            this.lock();
            if (this.fury.getConfig().isCodeGenEnabled()) {
                if (this.fury.getConfig().isAsyncCompilationEnabled() && !this.isAsyncVisitingFury()) {
                    ExecutorService compilationService = CodeGenerator.getCompilationService();
                    this.hasJITResult.put(callback.id(), new ArrayList());
                    ++this.numRunningTask;
                    compilationService.execute(() -> {
                        try {
                            Object result = jitAction.call();
                            try {
                                this.lock();
                                callback.onSuccess(result);
                                for (NotifyCallback notifyCallback : this.hasJITResult.get(callback.id())) {
                                    notifyCallback.onNotifyResult(result);
                                }
                            }
                            finally {
                                --this.numRunningTask;
                                if (this.numRunningTask == 0) {
                                    this.hasJITResult.clear();
                                }
                                this.unlock();
                            }
                        }
                        catch (Throwable t2) {
                            try {
                                this.lock();
                                callback.onFailure(t2);
                            }
                            finally {
                                --this.numRunningTask;
                                if (this.numRunningTask == 0) {
                                    this.hasJITResult.clear();
                                }
                                this.unlock();
                            }
                        }
                    });
                    T t2 = interpreterModeAction.call();
                    return t2;
                }
                T compilationService = jitAction.call();
                return compilationService;
            }
            T compilationService = interpreterModeAction.call();
            return compilationService;
        }
        catch (Exception e) {
            Platform.throwException(e);
            throw new IllegalStateException("unreachable");
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerJITNotifyCallback(Object id, NotifyCallback notifyCallback) {
        Preconditions.checkNotNull(id);
        try {
            this.lock();
            List<NotifyCallback> notifyCallbacks = this.hasJITResult.get(id);
            if (notifyCallbacks == null) {
                notifyCallback.onNotifyMissed();
            } else {
                notifyCallbacks.add(notifyCallback);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Internal
    public <T> T asyncVisitFury(Function<Fury, T> function) {
        try {
            this.lock();
            ++this.furyVisitState;
            T t2 = function.apply(this.fury);
            return t2;
        }
        finally {
            --this.furyVisitState;
            this.unlock();
        }
    }

    private boolean isAsyncVisitingFury() {
        if (this.asyncCompilationEnabled) {
            try {
                this.lock();
                boolean bl = this.furyVisitState != 0;
                return bl;
            }
            finally {
                this.unlock();
            }
        }
        return false;
    }

    public boolean hasJITResult(Object key) {
        try {
            this.lock();
            boolean bl = this.hasJITResult.get(key) != null;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Internal
    public void lock() {
        if (this.asyncCompilationEnabled) {
            this.jitLock.lock();
        }
    }

    @Internal
    public boolean lockedByCurrentThread() {
        return !this.asyncCompilationEnabled || this.jitLock.isHeldByCurrentThread();
    }

    @Internal
    public void unlock() {
        if (this.asyncCompilationEnabled) {
            this.jitLock.unlock();
        }
    }

    @Internal
    public static interface NotifyCallback {
        default public void onNotifyResult(Object result) {
            this.onNotifyMissed();
        }

        public void onNotifyMissed();
    }

    @Internal
    public static interface SerializerJITCallback<T> {
        public void onSuccess(T var1);

        default public void onFailure(Throwable e) {
            e.printStackTrace();
            Platform.throwException(e);
        }

        default public Object id() {
            return null;
        }
    }
}

