/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.collection;

import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.FinalizableWeakReference;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.fury.util.GraalvmSupport;

public class MultiKeyWeakMap<T> {
    private static final FinalizableReferenceQueue REFERENCE_QUEUE = GraalvmSupport.isGraalBuildtime() ? null : new FinalizableReferenceQueue();
    private static final Set<KeyReference> REFERENCES = ConcurrentHashMap.newKeySet();
    private final Map<Object, T> map = new ConcurrentHashMap<Object, T>();

    public void put(Object[] keys, T value) {
        this.map.put(this.createKey(keys), value);
    }

    public T get(Object[] keys) {
        List<KeyReference> keyRefs = this.createKey(keys);
        T t2 = this.map.get(keyRefs);
        keyRefs.forEach(REFERENCES::remove);
        return t2;
    }

    private List<? extends KeyReference> createKey(Object[] keys) {
        boolean[] reclaimedFlags = new boolean[keys.length];
        if (GraalvmSupport.isGraalBuildtime()) {
            ArrayList<NoCallbackRef> keyRefs = new ArrayList<NoCallbackRef>();
            for (Object key : keys) {
                keyRefs.add(new NoCallbackRef(key));
            }
            return keyRefs;
        }
        ArrayList<FinalizableKeyReference> keyRefs = new ArrayList<FinalizableKeyReference>();
        for (int i = 0; i < keys.length; ++i) {
            keyRefs.add(new FinalizableKeyReference(keys[i], keyRefs, reclaimedFlags, i));
        }
        return keyRefs;
    }

    private final class FinalizableKeyReference
    extends FinalizableWeakReference<Object>
    implements KeyReference {
        private final boolean[] reclaimedFlags;
        private final int index;
        private final List<FinalizableKeyReference> keyRefs;
        private final int hashcode;

        public FinalizableKeyReference(Object obj, List<FinalizableKeyReference> keyRefs, boolean[] reclaimedFlags, int index) {
            super(obj, REFERENCE_QUEUE);
            this.reclaimedFlags = reclaimedFlags;
            this.index = index;
            this.keyRefs = keyRefs;
            this.hashcode = obj.hashCode();
            REFERENCES.add(this);
        }

        public void finalizeReferent() {
            this.reclaimedFlags[this.index] = true;
            REFERENCES.remove(this);
            if (IntStream.range(0, this.reclaimedFlags.length).allMatch(i -> this.reclaimedFlags[i])) {
                MultiKeyWeakMap.this.map.remove(this.keyRefs);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FinalizableKeyReference that = (FinalizableKeyReference)o;
            Object referent1 = this.get();
            if (referent1 != null) {
                return referent1.equals(that.get());
            }
            return false;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public String toString() {
            return "KeyReference{reclaimedFlags=" + Arrays.toString(this.reclaimedFlags) + ", index=" + this.index + ", keyRefs=" + this.keyRefs.stream().map(Reference::get).collect(Collectors.toList()) + ", hashcode=" + this.hashcode + '}';
        }
    }

    private static final class NoCallbackRef
    implements KeyReference {
        private final Object obj;

        private NoCallbackRef(Object obj) {
            this.obj = obj;
        }

        public boolean equals(Object o1) {
            if (this == o1) {
                return true;
            }
            if (o1 == null || this.getClass() != o1.getClass()) {
                return false;
            }
            NoCallbackRef that = (NoCallbackRef)o1;
            return Objects.equals(this.obj, that.obj);
        }

        public int hashCode() {
            return Objects.hash(this.obj);
        }
    }

    private static interface KeyReference {
    }
}

