/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.collection;

import java.util.Arrays;

public final class ObjectArray<T> {
    private static final int COPY_THRESHOLD = 128;
    private static final int NIL_ARRAY_SIZE = 1024;
    private static final Object[] NIL_ARRAY = new Object[1024];
    public Object[] objects;
    public int size;

    public ObjectArray() {
        this(0);
    }

    public ObjectArray(int initialCapacity) {
        this.objects = new Object[initialCapacity];
    }

    public void add(T element) {
        int size;
        Object[] objects = this.objects;
        if (objects.length <= (size = this.size++)) {
            Object[] tmp = new Object[(size + 1) * 2];
            System.arraycopy(objects, 0, tmp, 0, objects.length);
            objects = tmp;
            this.objects = tmp;
        }
        objects[size] = element;
    }

    public void set(int index, T element) {
        this.objects[index] = element;
    }

    public T get(int index) {
        return (T)this.objects[index];
    }

    public T popOrNull() {
        int size = this.size;
        if (size == 0) {
            return null;
        }
        this.size = --size;
        return (T)this.objects[size];
    }

    public void clear() {
        ObjectArray.clearObjectArray(this.objects, 0, this.size);
        this.size = 0;
    }

    public void clearApproximate(int maximumCapacity) {
        if (this.objects.length < maximumCapacity) {
            this.clear();
        } else {
            this.size = 0;
            this.objects = new Object[maximumCapacity];
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public static void clearObjectArray(Object[] objects, int start, int size) {
        if (size < 128) {
            Arrays.fill(objects, start, start + size, null);
        } else if (size < 1024) {
            System.arraycopy(NIL_ARRAY, 0, objects, start, size);
        } else {
            while (size > 1024) {
                System.arraycopy(NIL_ARRAY, 0, objects, start, 1024);
                size -= 1024;
                start += 1024;
            }
            System.arraycopy(NIL_ARRAY, 0, objects, start, size);
        }
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        return Arrays.asList(this.objects).subList(0, this.size).toString();
    }
}

