/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.logging;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.fury.logging.LogLevel;
import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;

public class FuryLogger
implements Logger {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss");
    private final String name;

    public FuryLogger(Class<?> targetClass) {
        this.name = targetClass.getSimpleName();
    }

    @Override
    public void info(String msg) {
        if (LoggerFactory.getLogLevel() >= 2) {
            this.log(2, msg, new Object[0], false);
        }
    }

    @Override
    public void info(String msg, Object arg) {
        if (LoggerFactory.getLogLevel() >= 2) {
            this.log(2, msg, new Object[]{arg}, false);
        }
    }

    @Override
    public void info(String msg, Object arg1, Object arg2) {
        if (LoggerFactory.getLogLevel() >= 2) {
            this.log(2, msg, new Object[]{arg1, arg2}, false);
        }
    }

    @Override
    public void info(String msg, Object ... args) {
        if (LoggerFactory.getLogLevel() >= 2) {
            this.log(2, msg, args, false);
        }
    }

    @Override
    public void warn(String msg) {
        if (LoggerFactory.getLogLevel() >= 1) {
            this.log(1, msg, new Object[0], false);
        }
    }

    @Override
    public void warn(String msg, Object arg) {
        if (LoggerFactory.getLogLevel() >= 1) {
            this.log(1, msg, new Object[]{arg}, true);
        }
    }

    @Override
    public void warn(String msg, Object arg1, Object arg2) {
        if (LoggerFactory.getLogLevel() >= 1) {
            this.log(1, msg, new Object[]{arg1, arg2}, true);
        }
    }

    @Override
    public void warn(String msg, Object ... args) {
        if (LoggerFactory.getLogLevel() >= 1) {
            this.log(1, msg, args, true);
        }
    }

    @Override
    public void warn(String msg, Throwable t2) {
        if (LoggerFactory.getLogLevel() >= 1) {
            this.log(1, msg, new Object[]{t2}, true);
        }
    }

    @Override
    public void error(String msg) {
        if (LoggerFactory.getLogLevel() >= 0) {
            this.log(1, msg, new Object[0], false);
        }
    }

    @Override
    public void error(String msg, Object arg) {
        if (LoggerFactory.getLogLevel() >= 0) {
            this.log(0, msg, new Object[]{arg}, true);
        }
    }

    @Override
    public void error(String msg, Object arg1, Object arg2) {
        if (LoggerFactory.getLogLevel() >= 0) {
            this.log(0, msg, new Object[]{arg1, arg2}, true);
        }
    }

    @Override
    public void error(String msg, Object ... args) {
        if (LoggerFactory.getLogLevel() >= 0) {
            this.log(0, msg, args, true);
        }
    }

    @Override
    public void error(String msg, Throwable t2) {
        if (LoggerFactory.getLogLevel() >= 0) {
            this.log(0, msg, new Object[]{t2}, true);
        }
    }

    private void log(int level, String msg, Object[] args, boolean mayPrintTrace) {
        Object o;
        StringBuilder builder = new StringBuilder(dateTimeFormatter.format(LocalDateTime.now()));
        builder.append(" ").append(LogLevel.level2String(level));
        builder.append("  ").append(this.name);
        int lineNumber = Thread.currentThread().getStackTrace()[3].getLineNumber();
        builder.append(":").append(lineNumber);
        builder.append(" [").append(Thread.currentThread().getName()).append(']');
        builder.append(" - ");
        if (msg == null) {
            msg = "null";
        }
        int len = msg.length();
        int argLen = args.length;
        if (argLen > 0 && args[argLen - 1] instanceof Throwable) {
            --argLen;
        }
        int count = 0;
        for (int i = 0; i < len; ++i) {
            char c = msg.charAt(i);
            if (c == '{' && msg.charAt(i + 1) == '}') {
                int cnt;
                if ((cnt = count++) < argLen) {
                    builder.append(args[cnt]);
                } else {
                    builder.append("{}");
                }
                ++i;
                continue;
            }
            builder.append(c);
        }
        System.out.println(builder);
        int length = args.length;
        if (mayPrintTrace && length > 0 && (o = args[length - 1]) instanceof Throwable) {
            ((Throwable)o).printStackTrace(System.out);
        }
    }
}

