/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.meta;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.fury.Fury;
import org.apache.fury.collection.Tuple2;
import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.Platform;
import org.apache.fury.meta.ClassDefDecoder;
import org.apache.fury.meta.ClassDefEncoder;
import org.apache.fury.meta.ClassSpec;
import org.apache.fury.meta.TypeExtMeta;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.reflect.TypeRef;
import org.apache.fury.resolver.ClassResolver;
import org.apache.fury.serializer.NonexistentClass;
import org.apache.fury.type.Descriptor;
import org.apache.fury.type.FinalObjectTypeStub;
import org.apache.fury.type.GenericType;
import org.apache.fury.type.TypeUtils;
import org.apache.fury.util.Preconditions;

public class ClassDef
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ClassDef.class);
    static final int SCHEMA_COMPATIBLE_FLAG = 16;
    public static final int SIZE_TWO_BYTES_FLAG = 32;
    static final int OBJECT_TYPE_FLAG = 64;
    static final int COMPRESSION_FLAG = 128;
    public static final Comparator<Field> FIELD_COMPARATOR = (f1, f2) -> {
        int compare;
        long offset2;
        long offset1 = Platform.objectFieldOffset(f1);
        long diff = offset1 - (offset2 = Platform.objectFieldOffset(f2));
        if (diff != 0L) {
            return (int)diff;
        }
        if (!f1.equals(f2)) {
            LOG.warn("Field {} has same offset with {}, please an issue with jdk info to fury", f1, f2);
        }
        if ((compare = f1.getDeclaringClass().getName().compareTo(f2.getName())) != 0) {
            return compare;
        }
        return f1.getName().compareTo(f2.getName());
    };
    private final ClassSpec classSpec;
    private final List<FieldInfo> fieldsInfo;
    private final boolean isObjectType;
    private final long id;
    private final byte[] encoded;
    private transient List<Descriptor> descriptors;

    ClassDef(ClassSpec classSpec, List<FieldInfo> fieldsInfo, boolean isObjectType, long id, byte[] encoded) {
        this.classSpec = classSpec;
        this.fieldsInfo = fieldsInfo;
        this.isObjectType = isObjectType;
        this.id = id;
        this.encoded = encoded;
    }

    public String getClassName() {
        return this.classSpec.entireClassName;
    }

    public ClassSpec getClassSpec() {
        return this.classSpec;
    }

    public List<FieldInfo> getFieldsInfo() {
        return this.fieldsInfo;
    }

    public boolean isObjectType() {
        return this.isObjectType;
    }

    public long getId() {
        return this.id;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassDef classDef = (ClassDef)o;
        return Objects.equals(this.classSpec.entireClassName, classDef.classSpec.entireClassName) && Objects.equals(this.fieldsInfo, classDef.fieldsInfo) && Objects.equals(this.id, classDef.id);
    }

    public int hashCode() {
        return Objects.hash(this.classSpec.entireClassName, this.fieldsInfo, this.id);
    }

    public String toString() {
        return "ClassDef{className='" + this.classSpec.entireClassName + '\'' + ", fieldsInfo=" + this.fieldsInfo + ", isObjectType=" + this.isObjectType + ", id=" + this.id + '}';
    }

    public void writeClassDef(MemoryBuffer buffer) {
        buffer.writeBytes(this.encoded, 0, this.encoded.length);
    }

    public static ClassDef readClassDef(ClassResolver classResolver, MemoryBuffer buffer) {
        return ClassDefDecoder.decodeClassDef(classResolver, buffer, buffer.readInt64());
    }

    public static ClassDef readClassDef(ClassResolver classResolver, MemoryBuffer buffer, long header) {
        return ClassDefDecoder.decodeClassDef(classResolver, buffer, header);
    }

    public List<Descriptor> getDescriptors(ClassResolver resolver, Class<?> cls) {
        if (this.descriptors == null) {
            SortedMap<Field, Descriptor> allDescriptorsMap = resolver.getAllDescriptorsMap(cls, true);
            HashMap<String, Descriptor> descriptorsMap = new HashMap<String, Descriptor>();
            for (Map.Entry<Field, Descriptor> e : allDescriptorsMap.entrySet()) {
                if (descriptorsMap.put(e.getKey().getDeclaringClass().getName() + "." + e.getKey().getName(), e.getValue()) == null) continue;
                throw new IllegalStateException("Duplicate key");
            }
            this.descriptors = new ArrayList<Descriptor>(this.fieldsInfo.size());
            for (FieldInfo fieldInfo : this.fieldsInfo) {
                Descriptor descriptor = (Descriptor)descriptorsMap.get(fieldInfo.getDefinedClass() + "." + fieldInfo.getFieldName());
                Descriptor newDesc = fieldInfo.toDescriptor(resolver);
                if (descriptor != null) {
                    Class<?> rawType = newDesc.getRawType();
                    if (rawType.isEnum() || rawType.isAssignableFrom(descriptor.getRawType()) || NonexistentClass.isNonexistent(rawType) || rawType == FinalObjectTypeStub.class || rawType.isArray() && TypeUtils.getArrayComponent(rawType) == FinalObjectTypeStub.class) {
                        descriptor = descriptor.copyWithTypeName(newDesc.getTypeName());
                        this.descriptors.add(descriptor);
                        continue;
                    }
                    this.descriptors.add(newDesc);
                    continue;
                }
                this.descriptors.add(newDesc);
            }
        }
        return this.descriptors;
    }

    static FieldType buildFieldType(ClassResolver classResolver, Field field) {
        Preconditions.checkNotNull(field);
        GenericType genericType = GenericType.build(field.getGenericType());
        return ClassDef.buildFieldType(classResolver, genericType);
    }

    private static FieldType buildFieldType(ClassResolver classResolver, GenericType genericType) {
        Preconditions.checkNotNull(genericType);
        Class<?> rawType = genericType.getCls();
        boolean isMonomorphic = genericType.isMonomorphic();
        boolean trackingRef = genericType.trackingRef(classResolver);
        if (TypeUtils.COLLECTION_TYPE.isSupertypeOf(genericType.getTypeRef())) {
            return new CollectionFieldType(isMonomorphic, trackingRef, ClassDef.buildFieldType(classResolver, genericType.getTypeParameter0() == null ? GenericType.build(Object.class) : genericType.getTypeParameter0()));
        }
        if (TypeUtils.MAP_TYPE.isSupertypeOf(genericType.getTypeRef())) {
            return new MapFieldType(isMonomorphic, trackingRef, ClassDef.buildFieldType(classResolver, genericType.getTypeParameter0() == null ? GenericType.build(Object.class) : genericType.getTypeParameter0()), ClassDef.buildFieldType(classResolver, genericType.getTypeParameter1() == null ? GenericType.build(Object.class) : genericType.getTypeParameter1()));
        }
        Short classId = classResolver.getRegisteredClassId(rawType);
        if (classId != null && classId != 0) {
            return new RegisteredFieldType(isMonomorphic, trackingRef, classId);
        }
        if (rawType.isEnum()) {
            return EnumFieldType.getInstance();
        }
        if (rawType.isArray()) {
            Tuple2<Class<?>, Integer> info = TypeUtils.getArrayComponentInfo(rawType);
            return new ArrayFieldType(isMonomorphic, trackingRef, ClassDef.buildFieldType(classResolver, GenericType.build((Type)info.f0)), (Integer)info.f1);
        }
        return new ObjectFieldType(isMonomorphic, trackingRef);
    }

    public static ClassDef buildClassDef(Fury fury, Class<?> cls) {
        return ClassDef.buildClassDef(fury, cls, true);
    }

    public static ClassDef buildClassDef(Fury fury, Class<?> cls, boolean resolveParent) {
        return ClassDefEncoder.buildClassDef(fury.getClassResolver(), cls, ClassDefEncoder.buildFields(fury, cls, resolveParent), true);
    }

    public static ClassDef buildClassDef(ClassResolver classResolver, Class<?> type, List<Field> fields) {
        return ClassDef.buildClassDef(classResolver, type, fields, true);
    }

    public static ClassDef buildClassDef(ClassResolver classResolver, Class<?> type, List<Field> fields, boolean isObjectType) {
        return ClassDefEncoder.buildClassDef(classResolver, type, fields, isObjectType);
    }

    public ClassDef replaceRootClassTo(ClassResolver classResolver, Class<?> targetCls) {
        String name = targetCls.getName();
        List<FieldInfo> fieldInfos = this.fieldsInfo.stream().map(fieldInfo -> {
            if (((FieldInfo)fieldInfo).definedClass.equals(this.classSpec.entireClassName)) {
                return new FieldInfo(name, ((FieldInfo)fieldInfo).fieldName, ((FieldInfo)fieldInfo).fieldType);
            }
            return fieldInfo;
        }).collect(Collectors.toList());
        return ClassDefEncoder.buildClassDefWithFieldInfos(classResolver, targetCls, fieldInfos, this.isObjectType);
    }

    public static class ObjectFieldType
    extends FieldType {
        public ObjectFieldType(boolean isFinal, boolean trackingRef) {
            super(isFinal, trackingRef);
        }

        @Override
        public TypeRef<?> toTypeToken(ClassResolver classResolver) {
            return this.isMonomorphic() ? TypeRef.of(FinalObjectTypeStub.class, new TypeExtMeta(this.trackingRef)) : TypeRef.of(Object.class, new TypeExtMeta(this.trackingRef));
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class ArrayFieldType
    extends FieldType {
        private final FieldType componentType;
        private final int dimensions;

        public ArrayFieldType(boolean isMonomorphic, boolean trackingRef, FieldType componentType, int dimensions) {
            super(isMonomorphic, trackingRef);
            this.componentType = componentType;
            this.dimensions = dimensions;
        }

        @Override
        public TypeRef<?> toTypeToken(ClassResolver classResolver) {
            TypeRef<?> componentTypeRef = this.componentType.toTypeToken(classResolver);
            Class<?> componentRawType = componentTypeRef.getRawType();
            if (NonexistentClass.class.isAssignableFrom(componentRawType)) {
                return TypeRef.of(NonexistentClass.getNonexistentClass(this.componentType instanceof EnumFieldType, this.dimensions, true), new TypeExtMeta(this.trackingRef));
            }
            return TypeRef.of(Array.newInstance(componentRawType, new int[this.dimensions]).getClass(), new TypeExtMeta(this.trackingRef));
        }

        public int getDimensions() {
            return this.dimensions;
        }

        public FieldType getComponentType() {
            return this.componentType;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ArrayFieldType that = (ArrayFieldType)o;
            return this.dimensions == that.dimensions && Objects.equals(this.componentType, that.componentType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.componentType, this.dimensions);
        }

        public String toString() {
            return "ArrayFieldType{componentType=" + this.componentType + ", dimensions=" + this.dimensions + ", isMonomorphic=" + this.isMonomorphic + ", trackingRef=" + this.trackingRef + '}';
        }
    }

    public static class EnumFieldType
    extends FieldType {
        private static final EnumFieldType INSTANCE = new EnumFieldType();

        private EnumFieldType() {
            super(true, false);
        }

        @Override
        public TypeRef<?> toTypeToken(ClassResolver classResolver) {
            return TypeRef.of(NonexistentClass.NonexistentEnum.class);
        }

        public static EnumFieldType getInstance() {
            return INSTANCE;
        }
    }

    public static class MapFieldType
    extends FieldType {
        private final FieldType keyType;
        private final FieldType valueType;

        public MapFieldType(boolean isFinal, boolean trackingRef, FieldType keyType, FieldType valueType) {
            super(isFinal, trackingRef);
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public FieldType getKeyType() {
            return this.keyType;
        }

        public FieldType getValueType() {
            return this.valueType;
        }

        @Override
        public TypeRef<?> toTypeToken(ClassResolver classResolver) {
            return TypeUtils.mapOf(this.keyType.toTypeToken(classResolver), this.valueType.toTypeToken(classResolver), new TypeExtMeta(this.trackingRef));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MapFieldType that = (MapFieldType)o;
            return Objects.equals(this.keyType, that.keyType) && Objects.equals(this.valueType, that.valueType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.keyType, this.valueType);
        }

        public String toString() {
            return "MapFieldType{keyType=" + this.keyType + ", valueType=" + this.valueType + ", isFinal=" + this.isMonomorphic() + ", trackingRef=" + this.trackingRef() + '}';
        }
    }

    public static class CollectionFieldType
    extends FieldType {
        private final FieldType elementType;

        public CollectionFieldType(boolean isFinal, boolean trackingRef, FieldType elementType) {
            super(isFinal, trackingRef);
            this.elementType = elementType;
        }

        public FieldType getElementType() {
            return this.elementType;
        }

        @Override
        public TypeRef<?> toTypeToken(ClassResolver classResolver) {
            return TypeUtils.collectionOf(this.elementType.toTypeToken(classResolver), new TypeExtMeta(this.trackingRef));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CollectionFieldType that = (CollectionFieldType)o;
            return Objects.equals(this.elementType, that.elementType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.elementType);
        }

        public String toString() {
            return "CollectionFieldType{elementType=" + this.elementType + ", isFinal=" + this.isMonomorphic() + ", trackingRef=" + this.trackingRef() + '}';
        }
    }

    public static class RegisteredFieldType
    extends FieldType {
        private final short classId;

        public RegisteredFieldType(boolean isFinal, boolean trackingRef, short classId) {
            super(isFinal, trackingRef);
            this.classId = classId;
        }

        public short getClassId() {
            return this.classId;
        }

        @Override
        public TypeRef<?> toTypeToken(ClassResolver classResolver) {
            return TypeRef.of(classResolver.getRegisteredClass(this.classId), new TypeExtMeta(this.trackingRef));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegisteredFieldType that = (RegisteredFieldType)o;
            return this.classId == that.classId;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.classId);
        }

        public String toString() {
            return "RegisteredFieldType{isMonomorphic=" + this.isMonomorphic() + ", trackingRef=" + this.trackingRef() + ", classId=" + this.classId + '}';
        }
    }

    public static abstract class FieldType
    implements Serializable {
        protected final boolean isMonomorphic;
        protected final boolean trackingRef;

        public FieldType(boolean isMonomorphic, boolean trackingRef) {
            this.isMonomorphic = isMonomorphic;
            this.trackingRef = trackingRef;
        }

        public boolean isMonomorphic() {
            return this.isMonomorphic;
        }

        public boolean trackingRef() {
            return this.trackingRef;
        }

        public abstract TypeRef<?> toTypeToken(ClassResolver var1);

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldType fieldType = (FieldType)o;
            return this.isMonomorphic == fieldType.isMonomorphic && this.trackingRef == fieldType.trackingRef;
        }

        public int hashCode() {
            return Objects.hash(this.isMonomorphic, this.trackingRef);
        }

        public void write(MemoryBuffer buffer, boolean writeHeader) {
            byte header = (byte)((this.isMonomorphic ? 1 : 0) << 1);
            header = (byte)(header | (byte)(this.trackingRef ? 1 : 0));
            if (this instanceof RegisteredFieldType) {
                short classId = ((RegisteredFieldType)this).getClassId();
                buffer.writeVarUint32Small7(writeHeader ? 5 + classId << 2 | header : 5 + classId);
            } else if (this instanceof EnumFieldType) {
                buffer.writeVarUint32Small7(writeHeader ? 0x10 | header : 4);
            } else if (this instanceof ArrayFieldType) {
                ArrayFieldType arrayFieldType = (ArrayFieldType)this;
                buffer.writeVarUint32Small7(writeHeader ? 0xC | header : 3);
                buffer.writeVarUint32Small7(arrayFieldType.getDimensions());
                arrayFieldType.getComponentType().write(buffer);
            } else if (this instanceof CollectionFieldType) {
                buffer.writeVarUint32Small7(writeHeader ? 8 | header : 2);
                ((CollectionFieldType)this).getElementType().write(buffer);
            } else if (this instanceof MapFieldType) {
                buffer.writeVarUint32Small7(writeHeader ? 4 | header : 1);
                MapFieldType mapFieldType = (MapFieldType)this;
                mapFieldType.getKeyType().write(buffer);
                mapFieldType.getValueType().write(buffer);
            } else {
                Preconditions.checkArgument(this instanceof ObjectFieldType);
                buffer.writeVarUint32Small7(writeHeader ? header : (byte)0);
            }
        }

        public void write(MemoryBuffer buffer) {
            this.write(buffer, true);
        }

        public static FieldType read(MemoryBuffer buffer) {
            int header = buffer.readVarUint32Small7();
            boolean isMonomorphic = (header & 2) != 0;
            boolean trackingRef = (header & 1) != 0;
            return FieldType.read(buffer, isMonomorphic, trackingRef, header >>> 2);
        }

        public static FieldType read(MemoryBuffer buffer, boolean isFinal, boolean trackingRef, int typeId) {
            if (typeId == 0) {
                return new ObjectFieldType(isFinal, trackingRef);
            }
            if (typeId == 1) {
                return new MapFieldType(isFinal, trackingRef, FieldType.read(buffer), FieldType.read(buffer));
            }
            if (typeId == 2) {
                return new CollectionFieldType(isFinal, trackingRef, FieldType.read(buffer));
            }
            if (typeId == 3) {
                int dims = buffer.readVarUint32Small7();
                return new ArrayFieldType(isFinal, trackingRef, FieldType.read(buffer), dims);
            }
            if (typeId == 4) {
                return EnumFieldType.getInstance();
            }
            return new RegisteredFieldType(isFinal, trackingRef, (short)(typeId - 5));
        }
    }

    public static class FieldInfo
    implements Serializable {
        private final String definedClass;
        private final String fieldName;
        private final FieldType fieldType;

        FieldInfo(String definedClass, String fieldName, FieldType fieldType) {
            this.definedClass = definedClass;
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }

        public String getDefinedClass() {
            return this.definedClass;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public boolean hasTypeTag() {
            return false;
        }

        public short getTypeTag() {
            return -1;
        }

        public FieldType getFieldType() {
            return this.fieldType;
        }

        Descriptor toDescriptor(ClassResolver classResolver) {
            TypeRef<?> typeRef = this.fieldType.toTypeToken(classResolver);
            int stubModifiers = ReflectionUtils.getField(this.getClass(), "fieldName").getModifiers();
            return new Descriptor(typeRef, this.fieldName, stubModifiers, this.definedClass);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldInfo fieldInfo = (FieldInfo)o;
            return Objects.equals(this.definedClass, fieldInfo.definedClass) && Objects.equals(this.fieldName, fieldInfo.fieldName) && Objects.equals(this.fieldType, fieldInfo.fieldType);
        }

        public int hashCode() {
            return Objects.hash(this.definedClass, this.fieldName, this.fieldType);
        }

        public String toString() {
            return "FieldInfo{definedClass='" + this.definedClass + '\'' + ", fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + '}';
        }
    }
}

