/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.meta;

import java.util.Arrays;
import java.util.Objects;
import org.apache.fury.util.Preconditions;

public class MetaString {
    public static final MetaString EMPTY = new MetaString("", Encoding.forEmptyStr(), '\u0000', '\u0000', new byte[0]);
    private final String string;
    private final Encoding encoding;
    private final char specialChar1;
    private final char specialChar2;
    private final byte[] bytes;
    private final boolean stripLastChar;

    public MetaString(String string, Encoding encoding, char specialChar1, char specialChar2, byte[] bytes) {
        this.string = string;
        this.encoding = encoding;
        this.specialChar1 = specialChar1;
        this.specialChar2 = specialChar2;
        this.bytes = bytes;
        if (encoding != Encoding.UTF_8) {
            Preconditions.checkArgument(bytes.length > 0);
            this.stripLastChar = (bytes[0] & 0x80) != 0;
        } else {
            this.stripLastChar = false;
        }
    }

    public String getString() {
        return this.string;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public char getSpecialChar1() {
        return this.specialChar1;
    }

    public char getSpecialChar2() {
        return this.specialChar2;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean stripLastChar() {
        return this.stripLastChar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaString that = (MetaString)o;
        return this.specialChar1 == that.specialChar1 && this.specialChar2 == that.specialChar2 && this.stripLastChar == that.stripLastChar && this.encoding == that.encoding && Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.encoding, Character.valueOf(this.specialChar1), Character.valueOf(this.specialChar2), this.stripLastChar});
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    public String toString() {
        return "MetaString{str=" + this.string + ", encoding=" + (Object)((Object)this.encoding) + ", specialChar1=" + this.specialChar1 + ", specialChar2=" + this.specialChar2 + ", bytes=" + Arrays.toString(this.bytes) + ", stripLastChar=" + this.stripLastChar + '}';
    }

    public static enum Encoding {
        UTF_8(0),
        LOWER_SPECIAL(1),
        LOWER_UPPER_DIGIT_SPECIAL(2),
        FIRST_TO_LOWER_SPECIAL(3),
        ALL_TO_LOWER_SPECIAL(4);

        private final int value;

        private Encoding(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Encoding fromInt(int value) {
            for (Encoding encoding : Encoding.values()) {
                if (encoding.getValue() != value) continue;
                return encoding;
            }
            throw new IllegalArgumentException("Encoding flag not recognized: " + value);
        }

        public static Encoding forEmptyStr() {
            return UTF_8;
        }
    }
}

