/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.pool;

import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.fury.Fury;
import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;

public class ClassLoaderFuryPooled {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoaderFuryPooled.class);
    private final Function<ClassLoader, Fury> furyFactory;
    private Consumer<Fury> factoryCallback = f -> {};
    private final ClassLoader classLoader;
    private final BlockingQueue<Fury> idleCacheQueue;
    final WeakHashMap<Fury, Object> allFury = new WeakHashMap();
    private final AtomicInteger activeCacheNumber = new AtomicInteger(0);
    private final int maxPoolSize;
    private final Lock lock = new ReentrantLock();

    public ClassLoaderFuryPooled(ClassLoader classLoader, Function<ClassLoader, Fury> furyFactory, int minPoolSize, int maxPoolSize) {
        Objects.requireNonNull(furyFactory);
        this.maxPoolSize = maxPoolSize;
        this.furyFactory = furyFactory;
        this.classLoader = classLoader;
        this.idleCacheQueue = new LinkedBlockingQueue<Fury>(maxPoolSize);
        while (this.idleCacheQueue.size() < minPoolSize) {
            this.addFury(true);
        }
    }

    public Fury getFury() {
        if (this.activeCacheNumber.get() < this.maxPoolSize) {
            Fury fury = (Fury)this.idleCacheQueue.poll();
            if (fury != null) {
                return fury;
            }
            fury = this.addFury(false);
            if (fury != null) {
                return fury;
            }
        }
        try {
            return this.idleCacheQueue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void returnFury(Fury fury) {
        Objects.requireNonNull(fury);
        this.idleCacheQueue.offer(fury);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Fury addFury(boolean addQueue) {
        int after = this.activeCacheNumber.incrementAndGet();
        if (after > this.maxPoolSize) {
            this.activeCacheNumber.decrementAndGet();
            return null;
        }
        try {
            this.lock.lock();
            Fury fury = this.furyFactory.apply(this.classLoader);
            this.factoryCallback.accept(fury);
            this.allFury.put(fury, null);
            if (addQueue) {
                this.idleCacheQueue.add(fury);
            }
            Fury fury2 = fury;
            return fury2;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setFactoryCallback(Consumer<Fury> factoryCallback) {
        try {
            this.lock.lock();
            this.factoryCallback = this.factoryCallback.andThen(factoryCallback);
            this.allFury.keySet().forEach(factoryCallback);
        }
        finally {
            this.lock.unlock();
        }
    }
}

