/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.resolver;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.fury.Fury;
import org.apache.fury.FuryCopyable;
import org.apache.fury.annotation.Internal;
import org.apache.fury.builder.CodecUtils;
import org.apache.fury.builder.Generated;
import org.apache.fury.builder.JITContext;
import org.apache.fury.codegen.CodeGenerator;
import org.apache.fury.codegen.Expression;
import org.apache.fury.collection.IdentityMap;
import org.apache.fury.collection.IdentityObjectIntMap;
import org.apache.fury.collection.LongMap;
import org.apache.fury.collection.ObjectArray;
import org.apache.fury.collection.ObjectMap;
import org.apache.fury.collection.Tuple2;
import org.apache.fury.config.CompatibleMode;
import org.apache.fury.config.Language;
import org.apache.fury.exception.InsecureException;
import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.Platform;
import org.apache.fury.meta.ClassDef;
import org.apache.fury.meta.ClassSpec;
import org.apache.fury.meta.Encoders;
import org.apache.fury.meta.MetaString;
import org.apache.fury.meta.TypeExtMeta;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.reflect.TypeRef;
import org.apache.fury.resolver.ClassChecker;
import org.apache.fury.resolver.ClassInfo;
import org.apache.fury.resolver.ClassInfoHolder;
import org.apache.fury.resolver.DisallowedList;
import org.apache.fury.resolver.FieldResolver;
import org.apache.fury.resolver.MetaContext;
import org.apache.fury.resolver.MetaStringBytes;
import org.apache.fury.resolver.MetaStringResolver;
import org.apache.fury.serializer.ArraySerializers;
import org.apache.fury.serializer.BufferSerializers;
import org.apache.fury.serializer.CodegenSerializer;
import org.apache.fury.serializer.CompatibleSerializer;
import org.apache.fury.serializer.EnumSerializer;
import org.apache.fury.serializer.ExternalizableSerializer;
import org.apache.fury.serializer.FuryCopyableSerializer;
import org.apache.fury.serializer.JavaSerializer;
import org.apache.fury.serializer.JdkProxySerializer;
import org.apache.fury.serializer.LambdaSerializer;
import org.apache.fury.serializer.LocaleSerializer;
import org.apache.fury.serializer.MetaSharedSerializer;
import org.apache.fury.serializer.NoneSerializer;
import org.apache.fury.serializer.NonexistentClass;
import org.apache.fury.serializer.NonexistentClassSerializers;
import org.apache.fury.serializer.ObjectSerializer;
import org.apache.fury.serializer.OptionalSerializers;
import org.apache.fury.serializer.PrimitiveSerializers;
import org.apache.fury.serializer.ReplaceResolveSerializer;
import org.apache.fury.serializer.Serializer;
import org.apache.fury.serializer.SerializerFactory;
import org.apache.fury.serializer.Serializers;
import org.apache.fury.serializer.StringSerializer;
import org.apache.fury.serializer.StructSerializer;
import org.apache.fury.serializer.TimeSerializers;
import org.apache.fury.serializer.collection.ChildContainerSerializers;
import org.apache.fury.serializer.collection.CollectionSerializer;
import org.apache.fury.serializer.collection.CollectionSerializers;
import org.apache.fury.serializer.collection.GuavaCollectionSerializers;
import org.apache.fury.serializer.collection.ImmutableCollectionSerializers;
import org.apache.fury.serializer.collection.MapSerializer;
import org.apache.fury.serializer.collection.MapSerializers;
import org.apache.fury.serializer.collection.SubListSerializers;
import org.apache.fury.serializer.collection.SynchronizedSerializers;
import org.apache.fury.serializer.collection.UnmodifiableSerializers;
import org.apache.fury.serializer.scala.SingletonCollectionSerializer;
import org.apache.fury.serializer.scala.SingletonMapSerializer;
import org.apache.fury.serializer.scala.SingletonObjectSerializer;
import org.apache.fury.serializer.shim.ProtobufDispatcher;
import org.apache.fury.serializer.shim.ShimDispatcher;
import org.apache.fury.type.Descriptor;
import org.apache.fury.type.GenericType;
import org.apache.fury.type.ScalaTypes;
import org.apache.fury.type.TypeUtils;
import org.apache.fury.util.GraalvmSupport;
import org.apache.fury.util.Preconditions;
import org.apache.fury.util.function.Functions;

public class ClassResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ClassResolver.class);
    public static final byte USE_CLASS_VALUE_FLAG = 1;
    public static final short NO_CLASS_ID = 0;
    public static final short LAMBDA_STUB_ID = 1;
    public static final short JDK_PROXY_STUB_ID = 2;
    public static final short REPLACE_STUB_ID = 3;
    public static final short PRIMITIVE_VOID_CLASS_ID = 4;
    public static final short PRIMITIVE_BOOLEAN_CLASS_ID = 5;
    public static final short PRIMITIVE_BYTE_CLASS_ID = 6;
    public static final short PRIMITIVE_CHAR_CLASS_ID = 7;
    public static final short PRIMITIVE_SHORT_CLASS_ID = 8;
    public static final short PRIMITIVE_INT_CLASS_ID = 9;
    public static final short PRIMITIVE_FLOAT_CLASS_ID = 10;
    public static final short PRIMITIVE_LONG_CLASS_ID = 11;
    public static final short PRIMITIVE_DOUBLE_CLASS_ID = 12;
    public static final short VOID_CLASS_ID = 13;
    public static final short BOOLEAN_CLASS_ID = 14;
    public static final short BYTE_CLASS_ID = 15;
    public static final short CHAR_CLASS_ID = 16;
    public static final short SHORT_CLASS_ID = 17;
    public static final short INTEGER_CLASS_ID = 18;
    public static final short FLOAT_CLASS_ID = 19;
    public static final short LONG_CLASS_ID = 20;
    public static final short DOUBLE_CLASS_ID = 21;
    public static final short STRING_CLASS_ID = 22;
    public static final short PRIMITIVE_BOOLEAN_ARRAY_CLASS_ID = 23;
    public static final short PRIMITIVE_BYTE_ARRAY_CLASS_ID = 24;
    public static final short PRIMITIVE_CHAR_ARRAY_CLASS_ID = 25;
    public static final short PRIMITIVE_SHORT_ARRAY_CLASS_ID = 26;
    public static final short PRIMITIVE_INT_ARRAY_CLASS_ID = 27;
    public static final short PRIMITIVE_FLOAT_ARRAY_CLASS_ID = 28;
    public static final short PRIMITIVE_LONG_ARRAY_CLASS_ID = 29;
    public static final short PRIMITIVE_DOUBLE_ARRAY_CLASS_ID = 30;
    public static final short STRING_ARRAY_CLASS_ID = 31;
    public static final short OBJECT_ARRAY_CLASS_ID = 32;
    public static final short ARRAYLIST_CLASS_ID = 33;
    public static final short HASHMAP_CLASS_ID = 34;
    public static final short HASHSET_CLASS_ID = 35;
    public static final short CLASS_CLASS_ID = 36;
    public static final short EMPTY_OBJECT_ID = 37;
    private static final float loadFactor = 0.25f;
    private static final float furyMapLoadFactor = 0.25f;
    private static final int estimatedNumRegistered = 150;
    private static final String SET_META__CONTEXT_MSG = "Meta context must be set before serialization, please set meta context by SerializationContext.setMetaContext";
    private static final ClassInfo NIL_CLASS_INFO = new ClassInfo(null, null, null, null, false, null, null, 0);
    private final Fury fury;
    private ClassInfo[] registeredId2ClassInfo = new ClassInfo[0];
    private final IdentityMap<Class<?>, ClassInfo> classInfoMap = new IdentityMap(150, 0.25f);
    private ClassInfo classInfoCache;
    private final ObjectMap<MetaStringBytes, Class<?>> classNameBytes2Class = new ObjectMap(16, 0.25f);
    private final ObjectMap<ClassNameBytes, ClassInfo> compositeClassNameBytes2ClassInfo = new ObjectMap(16, 0.25f);
    private final HashMap<Short, Class<?>> typeIdToClassXLangMap = new HashMap(8, 0.25f);
    private final HashMap<String, Class<?>> typeTagToClassXLangMap = new HashMap(8, 0.25f);
    private final MetaStringResolver metaStringResolver;
    private final boolean metaContextShareEnabled;
    private final Map<Class<?>, ClassDef> classDefMap = new HashMap();
    private Class<?> currentReadClass;
    private short innerEndClassId;
    private final ExtRegistry extRegistry;
    private final ShimDispatcher shimDispatcher;
    private static final ConcurrentMap<Integer, GraalvmClassRegistry> GRAALVM_REGISTRY = new ConcurrentHashMap<Integer, GraalvmClassRegistry>();

    public ClassResolver(Fury fury) {
        this.fury = fury;
        this.metaStringResolver = fury.getMetaStringResolver();
        this.classInfoCache = NIL_CLASS_INFO;
        this.metaContextShareEnabled = fury.getConfig().isMetaShareEnabled();
        this.extRegistry = new ExtRegistry();
        this.extRegistry.objectGenericType = this.buildGenericType(TypeUtils.OBJECT_TYPE);
        this.shimDispatcher = new ShimDispatcher(fury);
        ClassResolver._addGraalvmClassRegistry(fury.getConfig().getConfigHash(), this);
    }

    public void initialize() {
        this.register(LambdaSerializer.ReplaceStub.class, 1);
        this.register(JdkProxySerializer.ReplaceStub.class, 2);
        this.register(ReplaceResolveSerializer.ReplaceStub.class, 3);
        this.register(Void.TYPE, 4);
        this.register(Boolean.TYPE, 5);
        this.register(Byte.TYPE, 6);
        this.register(Character.TYPE, 7);
        this.register(Short.TYPE, 8);
        this.register(Integer.TYPE, 9);
        this.register(Float.TYPE, 10);
        this.register(Long.TYPE, 11);
        this.register(Double.TYPE, 12);
        this.register(Void.class, 13);
        this.register(Boolean.class, 14);
        this.register(Byte.class, 15);
        this.register(Character.class, 16);
        this.register(Short.class, 17);
        this.register(Integer.class, 18);
        this.register(Float.class, 19);
        this.register(Long.class, 20);
        this.register(Double.class, 21);
        this.register(String.class, 22);
        this.register(boolean[].class, 23);
        this.register(byte[].class, 24);
        this.register(char[].class, 25);
        this.register(short[].class, 26);
        this.register(int[].class, 27);
        this.register(float[].class, 28);
        this.register(long[].class, 29);
        this.register(double[].class, 30);
        this.register(String[].class, 31);
        this.register(Object[].class, 32);
        this.register(ArrayList.class, 33);
        this.register(HashMap.class, 34);
        this.register(HashSet.class, 35);
        this.register(Class.class, 36);
        this.register(Object.class, 37);
        this.registerCommonUsedClasses();
        this.registerDefaultClasses();
        this.addDefaultSerializers();
        this.shimDispatcher.initialize();
        this.innerEndClassId = this.extRegistry.classIdGenerator;
    }

    private void addDefaultSerializers() {
        this.addDefaultSerializer(Void.TYPE, NoneSerializer.class);
        this.addDefaultSerializer(String.class, new StringSerializer(this.fury));
        PrimitiveSerializers.registerDefaultSerializers(this.fury);
        Serializers.registerDefaultSerializers(this.fury);
        ArraySerializers.registerDefaultSerializers(this.fury);
        TimeSerializers.registerDefaultSerializers(this.fury);
        OptionalSerializers.registerDefaultSerializers(this.fury);
        CollectionSerializers.registerDefaultSerializers(this.fury);
        MapSerializers.registerDefaultSerializers(this.fury);
        this.addDefaultSerializer(Locale.class, new LocaleSerializer(this.fury));
        this.addDefaultSerializer(LambdaSerializer.ReplaceStub.class, new LambdaSerializer(this.fury, LambdaSerializer.ReplaceStub.class));
        this.addDefaultSerializer(JdkProxySerializer.ReplaceStub.class, new JdkProxySerializer(this.fury, JdkProxySerializer.ReplaceStub.class));
        this.addDefaultSerializer(ReplaceResolveSerializer.ReplaceStub.class, new ReplaceResolveSerializer(this.fury, ReplaceResolveSerializer.ReplaceStub.class));
        SynchronizedSerializers.registerSerializers(this.fury);
        UnmodifiableSerializers.registerSerializers(this.fury);
        ImmutableCollectionSerializers.registerSerializers(this.fury);
        SubListSerializers.registerSerializers(this.fury, true);
        if (this.fury.getConfig().registerGuavaTypes()) {
            GuavaCollectionSerializers.registerDefaultSerializers(this.fury);
        }
        if (this.fury.getConfig().deserializeNonexistentClass()) {
            if (this.metaContextShareEnabled) {
                this.addDefaultSerializer(NonexistentClass.NonexistentMetaShared.class, new NonexistentClassSerializers.NonexistentClassSerializer(this.fury, null));
                short classId = Objects.requireNonNull(this.classInfoMap.get(NonexistentClass.NonexistentMetaShared.class)).classId;
                Preconditions.checkArgument(classId > 63 && classId < 8192, classId);
            } else {
                this.register((Class<?>)NonexistentClass.NonexistentSkip.class);
            }
        }
    }

    private void addDefaultSerializer(Class<?> type, Class<? extends Serializer> serializerClass) {
        this.addDefaultSerializer(type, Serializers.newSerializer(this.fury, type, serializerClass));
    }

    private void addDefaultSerializer(Class type, Serializer serializer) {
        this.registerSerializer(type, serializer);
        this.register((Class<?>)type);
    }

    private void registerCommonUsedClasses() {
        this.register(LinkedList.class, TreeSet.class);
        this.register(LinkedHashMap.class, TreeMap.class);
        this.register(Date.class, Timestamp.class, LocalDateTime.class, Instant.class);
        this.register(BigInteger.class, BigDecimal.class);
        this.register(Optional.class, OptionalInt.class);
        this.register(Boolean[].class, Byte[].class, Short[].class, Character[].class);
        this.register(Integer[].class, Float[].class, Long[].class, Double[].class);
    }

    private void registerDefaultClasses() {
        this.register(Platform.HEAP_BYTE_BUFFER_CLASS);
        this.register(Platform.DIRECT_BYTE_BUFFER_CLASS);
        this.register(Comparator.naturalOrder().getClass());
        this.register(Comparator.reverseOrder().getClass());
        this.register((Class<?>)ConcurrentHashMap.class);
        this.register((Class<?>)ArrayBlockingQueue.class);
        this.register((Class<?>)LinkedBlockingQueue.class);
        this.register((Class<?>)AtomicBoolean.class);
        this.register((Class<?>)AtomicInteger.class);
        this.register((Class<?>)AtomicLong.class);
        this.register((Class<?>)AtomicReference.class);
        this.register(EnumSet.allOf(Language.class).getClass());
        this.register(EnumSet.of(Language.JAVA).getClass());
        this.register(Throwable.class, StackTraceElement.class, Exception.class, RuntimeException.class);
        this.register((Class<?>)NullPointerException.class);
        this.register((Class<?>)IOException.class);
        this.register((Class<?>)IllegalArgumentException.class);
        this.register((Class<?>)IllegalStateException.class);
        this.register(IndexOutOfBoundsException.class, ArrayIndexOutOfBoundsException.class);
    }

    public void register(Class<?> cls) {
        if (!this.extRegistry.registeredClassIdMap.containsKey(cls)) {
            while (this.extRegistry.classIdGenerator < this.registeredId2ClassInfo.length && this.registeredId2ClassInfo[this.extRegistry.classIdGenerator] != null) {
                ExtRegistry.access$208(this.extRegistry);
            }
            this.register(cls, (int)this.extRegistry.classIdGenerator);
        }
    }

    public void register(String className) {
        this.register(this.loadClass(className, false, 0, false));
    }

    public void register(Class<?> ... classes) {
        for (Class<?> cls : classes) {
            this.register(cls);
        }
    }

    public void register(Class<?> cls, boolean createSerializer) {
        this.register(cls);
        if (createSerializer) {
            this.createSerializerAhead(cls);
        }
    }

    public void register(Class<?> cls, String typeTag) {
        if (this.fury.getLanguage() == Language.JAVA) {
            throw new IllegalArgumentException("Java serialization should register class by Fury#register(Class) or Fury.register(Class<?>, Short)");
        }
        this.register(cls);
        Preconditions.checkArgument(!this.typeTagToClassXLangMap.containsKey(typeTag));
        this.addSerializer(cls, new StructSerializer(this.fury, cls, typeTag));
    }

    public void register(Class<?> cls, int classId) {
        ClassInfo classInfo;
        Preconditions.checkArgument(classId >= 0 && classId < Short.MAX_VALUE);
        if (this.extRegistry.registeredClassIdMap.containsKey(cls)) {
            throw new IllegalArgumentException(String.format("Class %s already registered with id %s.", cls, this.extRegistry.registeredClassIdMap.get(cls)));
        }
        if (this.extRegistry.registeredClasses.containsKey(cls.getName())) {
            throw new IllegalArgumentException(String.format("Class %s with name %s has been registered, registering class with same name are not allowed.", this.extRegistry.registeredClasses.get(cls.getName()), cls.getName()));
        }
        short id = (short)classId;
        if (id < this.registeredId2ClassInfo.length && this.registeredId2ClassInfo[id] != null) {
            throw new IllegalArgumentException(String.format("Class %s with id %s has been registered, registering class %s with same id are not allowed.", this.registeredId2ClassInfo[id].getCls(), id, cls.getName()));
        }
        this.extRegistry.registeredClassIdMap.put(cls, id);
        if (this.registeredId2ClassInfo.length <= id) {
            ClassInfo[] tmp = new ClassInfo[(id + 1) * 2];
            System.arraycopy(this.registeredId2ClassInfo, 0, tmp, 0, this.registeredId2ClassInfo.length);
            this.registeredId2ClassInfo = tmp;
        }
        if ((classInfo = this.classInfoMap.get(cls)) != null) {
            classInfo.classId = id;
        } else {
            classInfo = new ClassInfo(this, cls, null, null, id);
            this.classInfoMap.put(cls, classInfo);
        }
        this.registeredId2ClassInfo[id] = classInfo;
        this.extRegistry.registeredClasses.put(cls.getName(), cls);
        ExtRegistry.access$208(this.extRegistry);
    }

    public void register(String className, int classId) {
        this.register(this.loadClass(className, false, 0, false), classId);
    }

    public void register(Class<?> cls, Short id, boolean createSerializer) {
        this.register(cls, (int)id.shortValue());
        if (createSerializer) {
            this.createSerializerAhead(cls);
        }
    }

    public void register(String className, Short classId, boolean createSerializer) {
        this.register(this.loadClass(className, false, 0, false), classId, createSerializer);
    }

    public boolean isRegistered(Class<?> cls) {
        return this.extRegistry.registeredClassIdMap.get(cls) != null;
    }

    public Short getRegisteredClassId(Class<?> cls) {
        return (Short)this.extRegistry.registeredClassIdMap.get(cls);
    }

    public Class<?> getRegisteredClass(short id) {
        ClassInfo classInfo;
        if (id < this.registeredId2ClassInfo.length && (classInfo = this.registeredId2ClassInfo[id]) != null) {
            return classInfo.cls;
        }
        return null;
    }

    public List<Class<?>> getRegisteredClasses() {
        return Arrays.stream(this.registeredId2ClassInfo).filter(Objects::nonNull).map(info -> info.cls).collect(Collectors.toList());
    }

    public boolean isMonomorphic(Class<?> clz) {
        if (this.fury.getConfig().isMetaShareEnabled()) {
            if (!ReflectionUtils.isMonomorphic(clz)) {
                return false;
            }
            if (Map.class.isAssignableFrom(clz) || Collection.class.isAssignableFrom(clz)) {
                return false;
            }
            if (clz.isArray()) {
                Class<?> component = TypeUtils.getArrayComponent(clz);
                return this.isMonomorphic(component);
            }
            return this.isInnerClass(clz) || clz.isEnum();
        }
        return ReflectionUtils.isMonomorphic(clz);
    }

    boolean isInnerClass(Class<?> cls) {
        ClassInfo classInfo;
        Short classId = (Short)this.extRegistry.registeredClassIdMap.get(cls);
        if (classId == null && (classInfo = this.getClassInfo(cls, false)) != null) {
            classId = classInfo.getClassId();
        }
        return classId != null && classId != 0 && classId < this.innerEndClassId;
    }

    public static boolean useReplaceResolveSerializer(Class<?> clz) {
        return JavaSerializer.getWriteReplaceMethod(clz) != null || JavaSerializer.getReadResolveMethod(clz) != null;
    }

    public static boolean requireJavaSerialization(Class<?> clz) {
        if (clz.isEnum() || clz.isArray()) {
            return false;
        }
        if (ReflectionUtils.isDynamicGeneratedCLass(clz)) {
            return false;
        }
        if (!Serializable.class.isAssignableFrom(clz)) {
            return false;
        }
        if (ClassResolver.useReplaceResolveSerializer(clz)) {
            return false;
        }
        if (Externalizable.class.isAssignableFrom(clz)) {
            return false;
        }
        if ("sun.reflect.annotation.AnnotationInvocationHandler".equals(clz.getName())) {
            return false;
        }
        return JavaSerializer.getReadObjectMethod(clz) != null || JavaSerializer.getWriteObjectMethod(clz) != null;
    }

    public <T> void registerSerializer(Class<T> type, Class<? extends Serializer> serializerClass) {
        this.registerSerializer(type, Serializers.newSerializer(this.fury, type, serializerClass));
    }

    public void registerSerializer(Class<?> type, Serializer<?> serializer) {
        if (!this.extRegistry.registeredClassIdMap.containsKey(type) && this.fury.getLanguage() == Language.JAVA) {
            this.register(type);
        }
        this.addSerializer(type, serializer);
    }

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.extRegistry.serializerFactory = serializerFactory;
    }

    public SerializerFactory getSerializerFactory() {
        return this.extRegistry.serializerFactory;
    }

    public <T> void setSerializer(Class<T> cls, Serializer<T> serializer) {
        this.addSerializer(cls, serializer);
    }

    public void setSerializer(String className, Class<? extends Serializer> serializer) {
        for (Map.Entry entry : this.classInfoMap.iterable()) {
            if (this.extRegistry.registeredClasses.containsKey(className)) {
                LOG.warn("Skip clear serializer for registered class {}", (Object)className);
                return;
            }
            Class cls = (Class)entry.getKey();
            if (!cls.getName().equals(className)) continue;
            LOG.info("Clear serializer for class {}.", (Object)className);
            ((ClassInfo)entry.getValue()).setSerializer(this, Serializers.newSerializer(this.fury, cls, serializer));
            this.classInfoCache = NIL_CLASS_INFO;
            return;
        }
    }

    public void setSerializers(String classNamePrefix, Class<? extends Serializer> serializer) {
        for (Map.Entry entry : this.classInfoMap.iterable()) {
            Class cls = (Class)entry.getKey();
            String className = cls.getName();
            if (this.extRegistry.registeredClasses.containsKey(className) || !className.startsWith(classNamePrefix)) continue;
            LOG.info("Clear serializer for class {}.", (Object)className);
            ((ClassInfo)entry.getValue()).setSerializer(this, Serializers.newSerializer(this.fury, cls, serializer));
            this.classInfoCache = NIL_CLASS_INFO;
        }
    }

    public <T> void resetSerializer(Class<T> cls, Serializer<T> serializer) {
        if (serializer == null) {
            this.clearSerializer(cls);
        } else {
            this.setSerializer(cls, serializer);
        }
    }

    public <T> void setSerializerIfAbsent(Class<T> cls, Serializer<T> serializer) {
        Serializer<T> s2 = this.getSerializer(cls, false);
        if (s2 == null) {
            this.setSerializer(cls, serializer);
        }
    }

    public void clearSerializer(Class<?> cls) {
        ClassInfo classInfo = this.classInfoMap.get(cls);
        if (classInfo != null) {
            classInfo.setSerializer(this, null);
        }
    }

    private void addSerializer(Class<?> type, Serializer<?> serializer) {
        ClassInfo classInfo;
        Short classId;
        boolean registered;
        Preconditions.checkNotNull(serializer);
        String typeTag = null;
        short typeId = serializer.getXtypeId();
        if (typeId != 0) {
            if (typeId > 0) {
                this.typeIdToClassXLangMap.put(typeId, type);
            }
            if (typeId == Fury.FURY_TYPE_TAG_ID) {
                typeTag = serializer.getCrossLanguageTypeTag();
                this.typeTagToClassXLangMap.put(typeTag, type);
            }
        }
        boolean bl = registered = (classId = (Short)this.extRegistry.registeredClassIdMap.get(type)) != null;
        if (registered) {
            classInfo = this.registeredId2ClassInfo[classId];
        } else {
            classId = serializer instanceof ReplaceResolveSerializer ? Short.valueOf((short)3) : Short.valueOf((short)0);
            classInfo = this.classInfoMap.get(type);
        }
        if (classInfo == null || typeTag != null || classId != classInfo.classId) {
            classInfo = new ClassInfo(this, type, typeTag, null, classId);
            this.classInfoMap.put(type, classInfo);
            if (registered) {
                this.registeredId2ClassInfo[classId.shortValue()] = classInfo;
            }
        }
        classInfo.setSerializer(this, serializer);
    }

    public <T> Serializer<T> getSerializer(Class<T> cls, boolean createIfNotExist) {
        Preconditions.checkNotNull(cls);
        if (createIfNotExist) {
            return this.getSerializer(cls);
        }
        ClassInfo classInfo = this.classInfoMap.get(cls);
        return classInfo == null ? null : classInfo.serializer;
    }

    public <T> Serializer<T> getSerializer(Class<T> cls) {
        Preconditions.checkNotNull(cls);
        return this.getOrUpdateClassInfo(cls).serializer;
    }

    @Internal
    public Serializer<?> getRawSerializer(Class<?> cls) {
        Preconditions.checkNotNull(cls);
        return this.getOrUpdateClassInfo(cls).serializer;
    }

    public boolean isSerializable(Class<?> cls) {
        if (ReflectionUtils.isAbstract(cls) || cls.isInterface()) {
            return false;
        }
        try {
            this.getSerializerClass(cls, false);
            return true;
        }
        catch (Throwable t2) {
            return false;
        }
    }

    public Class<? extends Serializer> getSerializerClass(Class<?> cls) {
        boolean codegen = CodegenSerializer.supportCodegenForJavaSerialization(cls) && this.fury.getConfig().isCodeGenEnabled();
        return this.getSerializerClass(cls, codegen);
    }

    public Class<? extends Serializer> getSerializerClass(Class<?> cls, boolean codegen) {
        Serializer serializer;
        if (!cls.isEnum() && (ReflectionUtils.isAbstract(cls) || cls.isInterface())) {
            throw new UnsupportedOperationException(String.format("Class %s doesn't support serialization.", cls));
        }
        Class<? extends Serializer> serializerClass = this.getSerializerClassFromGraalvmRegistry(cls);
        if (serializerClass != null) {
            return serializerClass;
        }
        ClassInfo classInfo = this.classInfoMap.get(cls = TypeUtils.boxedType(cls));
        if (classInfo != null && classInfo.serializer != null) {
            return classInfo.serializer.getClass();
        }
        if (this.getSerializerFactory() != null && (serializer = this.getSerializerFactory().createSerializer(this.fury, cls)) != null) {
            return serializer.getClass();
        }
        if (NonexistentClass.isNonexistent(cls)) {
            return NonexistentClassSerializers.getSerializer(this.fury, "Unknown", cls).getClass();
        }
        if (cls.isArray()) {
            return ArraySerializers.ObjectArraySerializer.class;
        }
        if (cls.isEnum()) {
            return EnumSerializer.class;
        }
        if (Enum.class.isAssignableFrom(cls) && cls != Enum.class) {
            return EnumSerializer.class;
        }
        if (EnumSet.class.isAssignableFrom(cls)) {
            return CollectionSerializers.EnumSetSerializer.class;
        }
        if (Charset.class.isAssignableFrom(cls)) {
            return Serializers.CharsetSerializer.class;
        }
        if (Functions.isLambda(cls)) {
            return LambdaSerializer.class;
        }
        if (ReflectionUtils.isJdkProxy(cls)) {
            if (JavaSerializer.getWriteReplaceMethod(cls) != null) {
                return ReplaceResolveSerializer.class;
            }
            return JdkProxySerializer.class;
        }
        if (Calendar.class.isAssignableFrom(cls)) {
            return TimeSerializers.CalendarSerializer.class;
        }
        if (ZoneId.class.isAssignableFrom(cls)) {
            return TimeSerializers.ZoneIdSerializer.class;
        }
        if (TimeZone.class.isAssignableFrom(cls)) {
            return TimeSerializers.TimeZoneSerializer.class;
        }
        if (ByteBuffer.class.isAssignableFrom(cls)) {
            return BufferSerializers.ByteBufferSerializer.class;
        }
        if (this.shimDispatcher.contains(cls)) {
            return this.shimDispatcher.getSerializer(cls).getClass();
        }
        serializerClass = ProtobufDispatcher.getSerializerClass(cls);
        if (serializerClass != null) {
            return serializerClass;
        }
        if (this.fury.getConfig().checkJdkClassSerializable() && cls.getName().startsWith("java") && !Serializable.class.isAssignableFrom(cls)) {
            throw new UnsupportedOperationException(String.format("Class %s doesn't support serialization.", cls));
        }
        if (this.fury.getConfig().isScalaOptimizationEnabled() && ReflectionUtils.isScalaSingletonObject(cls)) {
            if (this.isCollection(cls)) {
                return SingletonCollectionSerializer.class;
            }
            if (this.isMap(cls)) {
                return SingletonMapSerializer.class;
            }
            return SingletonObjectSerializer.class;
        }
        if (this.isCollection(cls)) {
            serializerClass = ChildContainerSerializers.getCollectionSerializerClass(cls);
            if (serializerClass != null) {
                return serializerClass;
            }
            if (ClassResolver.requireJavaSerialization(cls) || ClassResolver.useReplaceResolveSerializer(cls)) {
                return CollectionSerializers.JDKCompatibleCollectionSerializer.class;
            }
            if (this.fury.getLanguage() == Language.JAVA) {
                return CollectionSerializers.DefaultJavaCollectionSerializer.class;
            }
            return CollectionSerializer.class;
        }
        if (this.isMap(cls)) {
            serializerClass = ChildContainerSerializers.getMapSerializerClass(cls);
            if (serializerClass != null) {
                return serializerClass;
            }
            if (ClassResolver.requireJavaSerialization(cls) || ClassResolver.useReplaceResolveSerializer(cls)) {
                return MapSerializers.JDKCompatibleMapSerializer.class;
            }
            if (this.fury.getLanguage() == Language.JAVA) {
                return MapSerializers.DefaultJavaMapSerializer.class;
            }
            return MapSerializer.class;
        }
        if (this.fury.getLanguage() != Language.JAVA) {
            LOG.warn("Class {} isn't supported for cross-language serialization.", (Object)cls);
        }
        if (ClassResolver.useReplaceResolveSerializer(cls)) {
            return ReplaceResolveSerializer.class;
        }
        if (Externalizable.class.isAssignableFrom(cls)) {
            return ExternalizableSerializer.class;
        }
        if (ClassResolver.requireJavaSerialization(cls)) {
            return this.getJavaSerializer(cls);
        }
        final Class<?> clz = cls;
        return this.getObjectSerializerClass(cls, this.metaContextShareEnabled, codegen, new JITContext.SerializerJITCallback<Class<? extends Serializer>>(){

            @Override
            public void onSuccess(Class<? extends Serializer> result) {
                ClassResolver.this.setSerializer(clz, Serializers.newSerializer(ClassResolver.this.fury, clz, result));
                if (((ClassResolver)ClassResolver.this).classInfoCache.cls == clz) {
                    ClassResolver.this.classInfoCache = NIL_CLASS_INFO;
                }
                Preconditions.checkState(ClassResolver.this.getSerializer(clz).getClass() == result);
            }

            @Override
            public Object id() {
                return clz;
            }
        });
    }

    public boolean isCollection(Class<?> cls) {
        if (Collection.class.isAssignableFrom(cls)) {
            return true;
        }
        if (this.fury.getConfig().isScalaOptimizationEnabled()) {
            if (ScalaTypes.getScalaMapType().isAssignableFrom(cls)) {
                return false;
            }
            return ScalaTypes.getScalaIterableType().isAssignableFrom(cls);
        }
        return false;
    }

    public boolean isMap(Class<?> cls) {
        return Map.class.isAssignableFrom(cls) || this.fury.getConfig().isScalaOptimizationEnabled() && ScalaTypes.getScalaMapType().isAssignableFrom(cls);
    }

    public Class<? extends Serializer> getObjectSerializerClass(Class<?> cls, JITContext.SerializerJITCallback<Class<? extends Serializer>> callback) {
        boolean codegen = CodegenSerializer.supportCodegenForJavaSerialization(cls) && this.fury.getConfig().isCodeGenEnabled();
        return this.getObjectSerializerClass(cls, false, codegen, callback);
    }

    private Class<? extends Serializer> getObjectSerializerClass(Class<?> cls, boolean shareMeta, boolean codegen, JITContext.SerializerJITCallback<Class<? extends Serializer>> callback) {
        if (codegen) {
            if (this.extRegistry.getClassCtx.contains(cls)) {
                return CodegenSerializer.LazyInitBeanSerializer.class;
            }
            try {
                this.extRegistry.getClassCtx.add(cls);
                switch (this.fury.getCompatibleMode()) {
                    case SCHEMA_CONSISTENT: {
                        Class<? extends Serializer> sc;
                        Class<? extends Serializer> clazz = sc = this.fury.getJITContext().registerSerializerJITCallback(() -> ObjectSerializer.class, () -> CodegenSerializer.loadCodegenSerializer(this.fury, cls), callback);
                        return clazz;
                    }
                    case COMPATIBLE: {
                        Class<? extends Serializer> sc;
                        Class<? extends Serializer> clazz = sc = this.fury.getJITContext().registerSerializerJITCallback(() -> shareMeta ? ObjectSerializer.class : CompatibleSerializer.class, () -> shareMeta ? CodegenSerializer.loadCodegenSerializer(this.fury, cls) : CodegenSerializer.loadCompatibleCodegenSerializer(this.fury, cls), callback);
                        return clazz;
                    }
                }
                throw new UnsupportedOperationException(String.format("Unsupported mode %s", new Object[]{this.fury.getCompatibleMode()}));
            }
            finally {
                this.extRegistry.getClassCtx.remove(cls);
            }
        }
        if (codegen) {
            LOG.info("Object of type {} can't be serialized by jit", (Object)cls);
        }
        switch (this.fury.getCompatibleMode()) {
            case SCHEMA_CONSISTENT: {
                return ObjectSerializer.class;
            }
            case COMPATIBLE: {
                return shareMeta ? ObjectSerializer.class : CompatibleSerializer.class;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported mode %s", new Object[]{this.fury.getCompatibleMode()}));
    }

    public Class<? extends Serializer> getJavaSerializer(Class<?> clz) {
        if (Collection.class.isAssignableFrom(clz)) {
            return CollectionSerializers.JDKCompatibleCollectionSerializer.class;
        }
        if (Map.class.isAssignableFrom(clz)) {
            return MapSerializers.JDKCompatibleMapSerializer.class;
        }
        if (ClassResolver.useReplaceResolveSerializer(clz)) {
            return ReplaceResolveSerializer.class;
        }
        return this.fury.getDefaultJDKStreamSerializerType();
    }

    public ClassChecker getClassChecker() {
        return this.extRegistry.classChecker;
    }

    public void setClassChecker(ClassChecker classChecker) {
        this.extRegistry.classChecker = classChecker;
    }

    public FieldResolver getFieldResolver(Class<?> cls) {
        FieldResolver fieldResolver = (FieldResolver)this.extRegistry.fieldResolverMap.get(cls);
        if (fieldResolver == null) {
            fieldResolver = FieldResolver.of(this.fury, cls);
            this.extRegistry.fieldResolverMap.put(cls, fieldResolver);
        }
        return fieldResolver;
    }

    public SortedMap<Field, Descriptor> getAllDescriptorsMap(Class<?> clz, boolean searchParent) {
        return this.extRegistry.descriptorsCache.computeIfAbsent(Tuple2.of(clz, searchParent), t2 -> Descriptor.getAllDescriptorsMap(clz, searchParent));
    }

    public boolean needToWriteRef(TypeRef<?> typeRef) {
        Object extInfo = typeRef.getExtInfo();
        if (extInfo instanceof TypeExtMeta) {
            TypeExtMeta meta = (TypeExtMeta)extInfo;
            return meta.trackingRef();
        }
        Class<?> cls = typeRef.getRawType();
        if (this.fury.trackingRef()) {
            ClassInfo classInfo = this.getClassInfo(cls, false);
            if (classInfo == null || classInfo.serializer == null) {
                return !cls.isEnum();
            }
            return classInfo.serializer.needToWriteRef();
        }
        return false;
    }

    public ClassInfo getClassInfo(short classId) {
        ClassInfo classInfo = this.registeredId2ClassInfo[classId];
        assert (classInfo != null) : classId;
        if (classInfo.serializer == null) {
            this.addSerializer(classInfo.cls, this.createSerializer(classInfo.cls));
            classInfo = this.classInfoMap.get(classInfo.cls);
        }
        return classInfo;
    }

    public ClassInfo getClassInfo(Class<?> cls) {
        ClassInfo classInfo = this.classInfoMap.get(cls);
        if (classInfo == null || classInfo.serializer == null) {
            this.addSerializer(cls, this.createSerializer(cls));
            classInfo = this.classInfoMap.get(cls);
        }
        return classInfo;
    }

    public ClassInfo getClassInfo(Class<?> cls, ClassInfoHolder classInfoHolder) {
        ClassInfo classInfo = classInfoHolder.classInfo;
        if (classInfo.getCls() != cls) {
            classInfo = this.classInfoMap.get(cls);
            if (classInfo == null || classInfo.serializer == null) {
                this.addSerializer(cls, this.createSerializer(cls));
                classInfo = Objects.requireNonNull(this.classInfoMap.get(cls));
            }
            classInfoHolder.classInfo = classInfo;
        }
        assert (classInfo.serializer != null);
        return classInfo;
    }

    public ClassInfo getClassInfo(Class<?> cls, boolean createClassInfoIfNotFound) {
        if (createClassInfoIfNotFound) {
            return this.getOrUpdateClassInfo(cls);
        }
        if (this.extRegistry.getClassCtx.contains(cls)) {
            return null;
        }
        return this.classInfoMap.get(cls);
    }

    @Internal
    public ClassInfo getOrUpdateClassInfo(Class<?> cls) {
        ClassInfo classInfo = this.classInfoCache;
        if (classInfo.cls != cls) {
            classInfo = this.classInfoMap.get(cls);
            if (classInfo == null || classInfo.serializer == null) {
                this.addSerializer(cls, this.createSerializer(cls));
                classInfo = this.classInfoMap.get(cls);
            }
            this.classInfoCache = classInfo;
        }
        return classInfo;
    }

    private ClassInfo getOrUpdateClassInfo(short classId) {
        ClassInfo classInfo = this.classInfoCache;
        if (classInfo.classId != classId) {
            classInfo = this.registeredId2ClassInfo[classId];
            if (classInfo.serializer == null) {
                this.addSerializer(classInfo.cls, this.createSerializer(classInfo.cls));
                classInfo = this.classInfoMap.get(classInfo.cls);
            }
            this.classInfoCache = classInfo;
        }
        return classInfo;
    }

    public <T> Serializer<T> createSerializerSafe(Class<T> cls, Supplier<Serializer<T>> func) {
        Serializer<T> serializer = this.fury.getClassResolver().getSerializer(cls, false);
        try {
            return func.get();
        }
        catch (Throwable t2) {
            this.resetSerializer(cls, serializer);
            Platform.throwException(t2);
            throw new IllegalStateException("unreachable");
        }
    }

    private Serializer createSerializer(Class<?> cls) {
        Serializer serializer;
        DisallowedList.checkNotInDisallowedList(cls.getName());
        if (!this.isSecure(cls)) {
            throw new InsecureException(this.generateSecurityMsg(cls));
        }
        if (!(this.fury.getConfig().suppressClassRegistrationWarnings() || Functions.isLambda(cls) || ReflectionUtils.isJdkProxy(cls) || this.extRegistry.registeredClassIdMap.containsKey(cls) || this.shimDispatcher.contains(cls))) {
            LOG.warn(this.generateSecurityMsg(cls));
        }
        if (this.extRegistry.serializerFactory != null && (serializer = this.extRegistry.serializerFactory.createSerializer(this.fury, cls)) != null) {
            return serializer;
        }
        Serializer<?> shimSerializer = this.shimDispatcher.getSerializer(cls);
        if (shimSerializer != null) {
            return shimSerializer;
        }
        Class<? extends Serializer> serializerClass = this.getSerializerClass(cls);
        Serializer serializer2 = Serializers.newSerializer(this.fury, cls, serializerClass);
        if (FuryCopyable.class.isAssignableFrom(cls)) {
            serializer2 = new FuryCopyableSerializer(this.fury, cls, serializer2);
        }
        return serializer2;
    }

    private void createSerializerAhead(Class<?> cls) {
        ClassInfo classInfo = this.getClassInfo(cls);
        if (this.metaContextShareEnabled && this.needToWriteClassDef(classInfo.serializer)) {
            ClassInfo deserializationClassInfo;
            ClassDef classDef = classInfo.classDef;
            if (classDef == null) {
                classDef = this.buildClassDef(classInfo);
            }
            if ((deserializationClassInfo = this.buildMetaSharedClassInfo(Tuple2.of(classDef, null), classDef)) != null && GraalvmSupport.isGraalBuildtime()) {
                this.getGraalvmClassRegistry().deserializerClassMap.put(classDef.getId(), deserializationClassInfo.serializer.getClass());
                Tuple2 classDefTuple = (Tuple2)this.extRegistry.classIdToDef.get(classDef.getId());
                ((ClassInfo)classDefTuple.f1).serializer = null;
                this.extRegistry.classIdToDef.put(classDef.getId(), Tuple2.of(classDefTuple.f0, null));
            }
        }
        if (GraalvmSupport.isGraalBuildtime()) {
            this.getGraalvmClassRegistry().serializerClassMap.put(cls, classInfo.serializer.getClass());
            classInfo.serializer = null;
        }
    }

    private String generateSecurityMsg(Class<?> cls) {
        String tpl = "%s is not registered, please check whether it's the type you want to serialize or a **vulnerability**. If safe, you should invoke `Fury#register` to register class,  which will have better performance by skipping classname serialization. If your env is 100%% secure, you can also avoid this exception by disabling class registration check using `FuryBuilder#requireClassRegistration(false)`";
        return String.format(tpl, cls);
    }

    private boolean isSecure(Class<?> cls) {
        if (this.extRegistry.registeredClassIdMap.containsKey(cls) || this.shimDispatcher.contains(cls)) {
            return true;
        }
        if (cls.isArray()) {
            return this.isSecure(TypeUtils.getArrayComponent(cls));
        }
        if (this.fury.getConfig().requireClassRegistration()) {
            return Functions.isLambda(cls) || ReflectionUtils.isJdkProxy(cls) || this.extRegistry.registeredClassIdMap.containsKey(cls) || this.shimDispatcher.contains(cls);
        }
        return this.extRegistry.classChecker.checkClass(this, cls.getName());
    }

    public void writeClassAndUpdateCache(MemoryBuffer buffer, Class<?> cls) {
        if (cls == Integer.class) {
            buffer.writeVarUint32Small7(36);
        } else if (cls == Long.class) {
            buffer.writeVarUint32Small7(40);
        } else {
            this.writeClass(buffer, this.getOrUpdateClassInfo(cls));
        }
    }

    public void writeClass(MemoryBuffer buffer, ClassInfo classInfo) {
        if (this.metaContextShareEnabled) {
            this.writeClassWithMetaShare(buffer, classInfo);
        } else if (classInfo.classId == 0) {
            assert (classInfo.packageNameBytes != null);
            this.metaStringResolver.writeMetaStringBytesWithFlag(buffer, classInfo.packageNameBytes);
            assert (classInfo.classNameBytes != null);
            this.metaStringResolver.writeMetaStringBytes(buffer, classInfo.classNameBytes);
        } else {
            buffer.writeVarUint32(classInfo.classId << 1);
        }
    }

    public void writeClassWithMetaShare(MemoryBuffer buffer, ClassInfo classInfo) {
        if (classInfo.classId != 0 && !classInfo.needToWriteClassDef) {
            buffer.writeVarUint32(classInfo.classId << 1);
            return;
        }
        MetaContext metaContext = this.fury.getSerializationContext().getMetaContext();
        assert (metaContext != null) : "Meta context must be set before serialization, please set meta context by SerializationContext.setMetaContext";
        IdentityObjectIntMap<Class<?>> classMap = metaContext.classMap;
        int newId = classMap.size;
        int id = classMap.putOrGet(classInfo.cls, newId);
        if (id >= 0) {
            buffer.writeVarUint32(id << 1 | 1);
        } else {
            buffer.writeVarUint32(newId << 1 | 1);
            ClassDef classDef = classInfo.classDef;
            if (classDef == null) {
                classDef = this.buildClassDef(classInfo);
            }
            metaContext.writingClassDefs.add(classDef);
        }
    }

    private ClassDef buildClassDef(ClassInfo classInfo) {
        Serializer<?> serializer = classInfo.serializer;
        Preconditions.checkArgument(serializer.getClass() != NonexistentClassSerializers.NonexistentClassSerializer.class);
        ClassDef classDef = this.needToWriteClassDef(serializer) ? this.classDefMap.computeIfAbsent(classInfo.cls, cls -> ClassDef.buildClassDef(this.fury, cls)) : this.classDefMap.computeIfAbsent(classInfo.cls, cls -> ClassDef.buildClassDef(this, cls, new ArrayList<Field>(), false));
        classInfo.classDef = classDef;
        return classDef;
    }

    boolean needToWriteClassDef(Serializer serializer) {
        return this.fury.getConfig().getCompatibleMode() == CompatibleMode.COMPATIBLE && (serializer instanceof Generated.GeneratedObjectSerializer || serializer instanceof Generated.GeneratedMetaSharedSerializer || serializer instanceof CodegenSerializer.LazyInitBeanSerializer || serializer instanceof ObjectSerializer || serializer instanceof MetaSharedSerializer);
    }

    private ClassInfo readClassInfoWithMetaShare(MemoryBuffer buffer, MetaContext metaContext) {
        assert (metaContext != null) : "Meta context must be set before serialization, please set meta context by SerializationContext.setMetaContext";
        int header = buffer.readVarUint32Small14();
        int id = header >>> 1;
        if ((header & 1) == 0) {
            return this.getOrUpdateClassInfo((short)id);
        }
        ClassInfo classInfo = metaContext.readClassInfos.get(id);
        if (classInfo == null) {
            classInfo = this.readClassInfoWithMetaShare(metaContext, id);
        }
        return classInfo;
    }

    private ClassInfo readClassInfoWithMetaShare(MetaContext metaContext, int index) {
        ClassDef classDef = metaContext.readClassDefs.get(index);
        Tuple2 classDefTuple = (Tuple2)this.extRegistry.classIdToDef.get(classDef.getId());
        ClassInfo classInfo = classDefTuple == null || classDefTuple.f1 == null || ((ClassInfo)classDefTuple.f1).serializer == null ? this.buildMetaSharedClassInfo(classDefTuple, classDef) : (ClassInfo)classDefTuple.f1;
        metaContext.readClassInfos.set(index, classInfo);
        return classInfo;
    }

    public ClassInfo readClassInfoWithMetaShare(MemoryBuffer buffer, Class<?> targetClass) {
        assert (this.metaContextShareEnabled);
        ClassInfo classInfo = this.readClassInfoWithMetaShare(buffer, this.fury.getSerializationContext().getMetaContext());
        Class<?> readClass = classInfo.getCls();
        if (targetClass != readClass) {
            Tuple2<Class<?>, Class<?>> key = Tuple2.of(readClass, targetClass);
            ClassInfo newClassInfo = (ClassInfo)this.extRegistry.transformedClassInfo.get(key);
            if (newClassInfo == null) {
                newClassInfo = this.getMetaSharedClassInfo(classInfo.classDef.replaceRootClassTo(this, targetClass), targetClass);
                this.extRegistry.transformedClassInfo.put(key, newClassInfo);
            }
            return newClassInfo;
        }
        return classInfo;
    }

    private ClassInfo buildMetaSharedClassInfo(Tuple2<ClassDef, ClassInfo> classDefTuple, ClassDef classDef) {
        if (classDefTuple != null) {
            classDef = (ClassDef)classDefTuple.f0;
        }
        Class<?> cls = this.loadClass(classDef.getClassSpec());
        ClassInfo classInfo = !classDef.isObjectType() ? this.getClassInfo(cls) : this.getMetaSharedClassInfo(classDef, cls);
        this.putClassDef(classDef, classInfo);
        return classInfo;
    }

    private ClassInfo getMetaSharedClassInfo(ClassDef classDef, Class<?> clz) {
        if (clz == NonexistentClass.NonexistentSkip.class) {
            clz = NonexistentClass.NonexistentMetaShared.class;
        }
        Class<?> cls = clz;
        Short classId = (Short)this.extRegistry.registeredClassIdMap.get(cls);
        ClassInfo classInfo = new ClassInfo(this, cls, null, null, classId == null ? (short)0 : classId);
        classInfo.classDef = classDef;
        if (NonexistentClass.class.isAssignableFrom(TypeUtils.getComponentIfArray(cls))) {
            if (cls == NonexistentClass.NonexistentMetaShared.class) {
                classInfo.setSerializer(this, new NonexistentClassSerializers.NonexistentClassSerializer(this.fury, classDef));
                Preconditions.checkNotNull(classId);
            } else {
                classInfo.serializer = NonexistentClassSerializers.getSerializer(this.fury, classDef.getClassName(), cls);
            }
            return classInfo;
        }
        if (clz.isArray() || cls.isEnum()) {
            return this.getClassInfo(cls);
        }
        Class sc = this.getMetaSharedDeserializerClassFromGraalvmRegistry(cls, classDef);
        if (sc == null) {
            if (GraalvmSupport.isGraalRuntime()) {
                sc = MetaSharedSerializer.class;
                LOG.warn("Can't generate class at runtime in graalvm for class def {}, use {} instead", (Object)classDef, (Object)sc);
            } else {
                sc = this.fury.getJITContext().registerSerializerJITCallback(() -> MetaSharedSerializer.class, () -> CodecUtils.loadOrGenMetaSharedCodecClass(this.fury, cls, classDef), c -> classInfo.setSerializer(this, Serializers.newSerializer(this.fury, cls, c)));
            }
        }
        if (sc == MetaSharedSerializer.class) {
            classInfo.setSerializer(this, new MetaSharedSerializer(this.fury, cls, classDef));
        } else {
            classInfo.setSerializer(this, Serializers.newSerializer(this.fury, cls, sc));
        }
        return classInfo;
    }

    public void writeClassDefs(MemoryBuffer buffer) {
        MetaContext metaContext = this.fury.getSerializationContext().getMetaContext();
        ObjectArray<ClassDef> writingClassDefs = metaContext.writingClassDefs;
        int size = writingClassDefs.size;
        buffer.writeVarUint32Small7(size);
        if (buffer.isHeapFullyWriteable()) {
            this.writeClassDefs(buffer, writingClassDefs, size);
        } else {
            for (int i = 0; i < size; ++i) {
                writingClassDefs.get(i).writeClassDef(buffer);
            }
        }
        metaContext.writingClassDefs.size = 0;
    }

    private void writeClassDefs(MemoryBuffer buffer, ObjectArray<ClassDef> writingClassDefs, int size) {
        int writerIndex = buffer.writerIndex();
        for (int i = 0; i < size; ++i) {
            byte[] encoded = writingClassDefs.get(i).getEncoded();
            int bytesLen = encoded.length;
            buffer.ensure(writerIndex + bytesLen);
            byte[] targetArray = buffer.getHeapMemory();
            System.arraycopy(encoded, 0, targetArray, writerIndex, bytesLen);
            writerIndex += bytesLen;
        }
        buffer.writerIndex(writerIndex);
    }

    public void readClassDefs(MemoryBuffer buffer) {
        MetaContext metaContext = this.fury.getSerializationContext().getMetaContext();
        assert (metaContext != null) : "Meta context must be set before serialization, please set meta context by SerializationContext.setMetaContext";
        int numClassDefs = buffer.readVarUint32Small7();
        for (int i = 0; i < numClassDefs; ++i) {
            long id = buffer.readInt64();
            Tuple2<ClassDef, ClassInfo> tuple2 = (Tuple2<ClassDef, ClassInfo>)this.extRegistry.classIdToDef.get(id);
            if (tuple2 != null) {
                int size = (id & 0x20L) == 0L ? buffer.readByte() & 0xFF : buffer.readInt16() & 0xFFFF;
                buffer.increaseReaderIndex(size);
            } else {
                tuple2 = this.readClassDef(buffer, id);
            }
            metaContext.readClassDefs.add((ClassDef)tuple2.f0);
            metaContext.readClassInfos.add((ClassInfo)tuple2.f1);
        }
    }

    private Tuple2<ClassDef, ClassInfo> readClassDef(MemoryBuffer buffer, long header) {
        ClassDef readClassDef = ClassDef.readClassDef(this, buffer, header);
        Tuple2<ClassDef, ClassInfo> tuple2 = (Tuple2<ClassDef, ClassInfo>)this.extRegistry.classIdToDef.get(readClassDef.getId());
        if (tuple2 == null) {
            tuple2 = this.putClassDef(readClassDef, null);
        }
        return tuple2;
    }

    private Tuple2<ClassDef, ClassInfo> putClassDef(ClassDef classDef, ClassInfo classInfo) {
        Tuple2<ClassDef, ClassInfo> tuple2 = Tuple2.of(classDef, classInfo);
        this.extRegistry.classIdToDef.put(classDef.getId(), tuple2);
        return tuple2;
    }

    public ClassDef getClassDef(Class<?> cls, boolean resolveParent) {
        if (resolveParent) {
            return this.classDefMap.computeIfAbsent(cls, k -> ClassDef.buildClassDef(this.fury, cls));
        }
        ClassDef classDef = (ClassDef)this.extRegistry.currentLayerClassDef.get(cls);
        if (classDef == null) {
            classDef = ClassDef.buildClassDef(this.fury, cls, false);
            this.extRegistry.currentLayerClassDef.put(cls, classDef);
        }
        return classDef;
    }

    public Expression writeClassExpr(Expression classResolverRef, Expression buffer, Expression classInfo) {
        return new Expression.Invoke(classResolverRef, "writeClass", buffer, classInfo);
    }

    public Expression writeClassExpr(Expression buffer, short classId) {
        Preconditions.checkArgument(classId != 0);
        return this.writeClassExpr(buffer, Expression.Literal.ofShort(classId));
    }

    public Expression writeClassExpr(Expression buffer, Expression classId) {
        return new Expression.Invoke(buffer, "writeVarUint32", new Expression.BitShift("<<", classId, 1));
    }

    public Expression skipRegisteredClassExpr(Expression buffer) {
        return new Expression.Invoke(buffer, "readVarUint32Small14", new Expression[0]);
    }

    public void writeClassInternal(MemoryBuffer buffer, Class<?> cls) {
        ClassInfo classInfo = this.classInfoMap.get(cls);
        if (classInfo == null) {
            Short classId = (Short)this.extRegistry.registeredClassIdMap.get(cls);
            classInfo = new ClassInfo(this, cls, null, null, classId == null ? (short)0 : classId);
            this.classInfoMap.put(cls, classInfo);
        }
        this.writeClassInternal(buffer, classInfo);
    }

    public void writeClassInternal(MemoryBuffer buffer, ClassInfo classInfo) {
        short classId = classInfo.classId;
        if (classId == 3) {
            classInfo.classId = 0;
        }
        if (classInfo.classId != 0) {
            buffer.writeVarUint32(classInfo.classId << 1);
        } else {
            this.metaStringResolver.writeMetaStringBytesWithFlag(buffer, classInfo.packageNameBytes);
            this.metaStringResolver.writeMetaStringBytes(buffer, classInfo.classNameBytes);
        }
        classInfo.classId = classId;
    }

    public Class<?> readClassInternal(MemoryBuffer buffer) {
        ClassInfo classInfo;
        int header = buffer.readVarUint32Small14();
        if ((header & 1) != 0) {
            MetaStringBytes packageBytes = this.metaStringResolver.readMetaStringBytesWithFlag(buffer, header);
            MetaStringBytes simpleClassNameBytes = this.metaStringResolver.readMetaStringBytes(buffer);
            classInfo = this.loadBytesToClassInfo(packageBytes, simpleClassNameBytes);
        } else {
            classInfo = this.registeredId2ClassInfo[(short)(header >> 1)];
        }
        Class<?> cls = classInfo.cls;
        this.currentReadClass = cls;
        return cls;
    }

    public ClassInfo readClassInfo(MemoryBuffer buffer) {
        ClassInfo classInfo;
        if (this.metaContextShareEnabled) {
            return this.readClassInfoWithMetaShare(buffer, this.fury.getSerializationContext().getMetaContext());
        }
        int header = buffer.readVarUint32Small14();
        if ((header & 1) != 0) {
            this.classInfoCache = classInfo = this.readClassInfoFromBytes(buffer, this.classInfoCache, header);
        } else {
            classInfo = this.getOrUpdateClassInfo((short)(header >> 1));
        }
        this.currentReadClass = classInfo.cls;
        return classInfo;
    }

    public ClassInfo readClassInfo(MemoryBuffer buffer, ClassInfo classInfoCache) {
        if (this.metaContextShareEnabled) {
            return this.readClassInfoWithMetaShare(buffer, this.fury.getSerializationContext().getMetaContext());
        }
        int header = buffer.readVarUint32Small14();
        if ((header & 1) != 0) {
            return this.readClassInfoByCache(buffer, classInfoCache, header);
        }
        return this.getClassInfo((short)(header >> 1));
    }

    public ClassInfo readClassInfo(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        if (this.metaContextShareEnabled) {
            return this.readClassInfoWithMetaShare(buffer, this.fury.getSerializationContext().getMetaContext());
        }
        int header = buffer.readVarUint32Small14();
        if ((header & 1) != 0) {
            return this.readClassInfoFromBytes(buffer, classInfoHolder, header);
        }
        return this.getClassInfo((short)(header >> 1));
    }

    private ClassInfo readClassInfoByCache(MemoryBuffer buffer, ClassInfo classInfoCache, int header) {
        if (this.metaContextShareEnabled) {
            return this.readClassInfoWithMetaShare(buffer, this.fury.getSerializationContext().getMetaContext());
        }
        return this.readClassInfoFromBytes(buffer, classInfoCache, header);
    }

    private ClassInfo readClassInfoFromBytes(MemoryBuffer buffer, ClassInfoHolder classInfoHolder, int header) {
        ClassInfo classInfo;
        if (this.metaContextShareEnabled) {
            return this.readClassInfoWithMetaShare(buffer, this.fury.getSerializationContext().getMetaContext());
        }
        classInfoHolder.classInfo = classInfo = this.readClassInfoFromBytes(buffer, classInfoHolder.classInfo, header);
        return classInfo;
    }

    private ClassInfo readClassInfoFromBytes(MemoryBuffer buffer, ClassInfo classInfoCache, int header) {
        MetaStringBytes simpleClassNameBytes;
        MetaStringBytes packageBytes;
        MetaStringBytes simpleClassNameBytesCache = classInfoCache.classNameBytes;
        if (simpleClassNameBytesCache != null) {
            MetaStringBytes packageNameBytesCache = classInfoCache.packageNameBytes;
            packageBytes = this.metaStringResolver.readMetaStringBytesWithFlag(buffer, packageNameBytesCache, header);
            assert (packageNameBytesCache != null);
            simpleClassNameBytes = this.metaStringResolver.readMetaStringBytes(buffer, simpleClassNameBytesCache);
            if (simpleClassNameBytesCache.hashCode == simpleClassNameBytes.hashCode && packageNameBytesCache.hashCode == packageBytes.hashCode) {
                return classInfoCache;
            }
        } else {
            packageBytes = this.metaStringResolver.readMetaStringBytesWithFlag(buffer, header);
            simpleClassNameBytes = this.metaStringResolver.readMetaStringBytes(buffer);
        }
        ClassInfo classInfo = this.loadBytesToClassInfo(packageBytes, simpleClassNameBytes);
        if (classInfo.serializer == null) {
            return this.getClassInfo(classInfo.cls);
        }
        return classInfo;
    }

    private ClassInfo loadBytesToClassInfo(MetaStringBytes packageBytes, MetaStringBytes simpleClassNameBytes) {
        ClassNameBytes classNameBytes = new ClassNameBytes(packageBytes.hashCode, simpleClassNameBytes.hashCode);
        ClassInfo classInfo = (ClassInfo)this.compositeClassNameBytes2ClassInfo.get(classNameBytes);
        if (classInfo == null) {
            classInfo = this.populateBytesToClassInfo(classNameBytes, packageBytes, simpleClassNameBytes);
        }
        return classInfo;
    }

    private ClassInfo populateBytesToClassInfo(ClassNameBytes classNameBytes, MetaStringBytes packageBytes, MetaStringBytes simpleClassNameBytes) {
        String packageName = packageBytes.decode(Encoders.PACKAGE_DECODER);
        String className = simpleClassNameBytes.decode(Encoders.TYPE_NAME_DECODER);
        ClassSpec classSpec = Encoders.decodePkgAndClass(packageName, className);
        MetaStringBytes fullClassNameBytes = this.metaStringResolver.getOrCreateMetaStringBytes(Encoders.PACKAGE_ENCODER.encode(classSpec.entireClassName, MetaString.Encoding.UTF_8));
        Class<?> cls = this.loadClass(classSpec.entireClassName, classSpec.isEnum, classSpec.dimension);
        ClassInfo classInfo = new ClassInfo(cls, fullClassNameBytes, packageBytes, simpleClassNameBytes, false, null, null, 0);
        if (NonexistentClass.class.isAssignableFrom(TypeUtils.getComponentIfArray(cls))) {
            classInfo.serializer = NonexistentClassSerializers.getSerializer(this.fury, classSpec.entireClassName, cls);
        } else if (!this.classInfoMap.containsKey(cls)) {
            this.classInfoMap.put(cls, classInfo);
        }
        this.compositeClassNameBytes2ClassInfo.put(classNameBytes, classInfo);
        return classInfo;
    }

    public void xwriteClass(MemoryBuffer buffer, Class<?> cls) {
        this.metaStringResolver.writeMetaStringBytes(buffer, this.getOrUpdateClassInfo(cls).fullClassNameBytes);
    }

    public void xwriteTypeTag(MemoryBuffer buffer, Class<?> cls) {
        this.metaStringResolver.writeMetaStringBytes(buffer, this.getOrUpdateClassInfo(cls).typeTagBytes);
    }

    public Class<?> xreadClass(MemoryBuffer buffer) {
        MetaStringBytes byteString = this.metaStringResolver.readMetaStringBytes(buffer);
        Class<?> cls = (Class<?>)this.classNameBytes2Class.get(byteString);
        if (cls == null) {
            Preconditions.checkNotNull(byteString);
            String className = byteString.decode(Encoders.GENERIC_DECODER);
            cls = this.loadClass(className);
            this.classNameBytes2Class.put(byteString, cls);
        }
        this.currentReadClass = cls;
        return cls;
    }

    public String xreadClassName(MemoryBuffer buffer) {
        return this.metaStringResolver.readMetaString(buffer);
    }

    public Class<?> getCurrentReadClass() {
        return this.currentReadClass;
    }

    private Class<?> loadClass(String className) {
        return this.loadClass(className, false, 0);
    }

    private Class<?> loadClass(ClassSpec classSpec) {
        return this.loadClass(classSpec.entireClassName, classSpec.isEnum, classSpec.dimension);
    }

    private Class<?> loadClass(String className, boolean isEnum, int arrayDims) {
        return this.loadClass(className, isEnum, arrayDims, this.fury.getConfig().deserializeNonexistentClass());
    }

    private Class<?> loadClass(String className, boolean isEnum, int arrayDims, boolean deserializeNonexistentClass) {
        this.extRegistry.classChecker.checkClass(this, className);
        try {
            return Class.forName(className, false, this.fury.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException ex) {
                String msg = String.format("Class %s not found from classloaders [%s, %s]", className, this.fury.getClassLoader(), Thread.currentThread().getContextClassLoader());
                if (deserializeNonexistentClass) {
                    LOG.warn(msg);
                    return NonexistentClass.getNonexistentClass(className, isEnum, arrayDims, this.metaContextShareEnabled);
                }
                throw new IllegalStateException(msg, ex);
            }
        }
    }

    public void reset() {
        this.resetRead();
        this.resetWrite();
    }

    public void resetRead() {
    }

    public void resetWrite() {
    }

    public Class<?> getClassByTypeId(short typeId) {
        return this.typeIdToClassXLangMap.get(typeId);
    }

    public Class<?> readClassByTypeTag(MemoryBuffer buffer) {
        String tag = this.metaStringResolver.readMetaString(buffer);
        return this.typeTagToClassXLangMap.get(tag);
    }

    public GenericType buildGenericType(TypeRef<?> typeRef) {
        return GenericType.build(typeRef, t2 -> {
            if (t2.getClass() == Class.class) {
                return this.isMonomorphic((Class)t2);
            }
            return this.isMonomorphic(TypeUtils.getRawType(t2));
        });
    }

    public GenericType buildGenericType(Type type) {
        return GenericType.build(type, t2 -> {
            if (t2.getClass() == Class.class) {
                return this.isMonomorphic((Class)t2);
            }
            return this.isMonomorphic(TypeUtils.getRawType(t2));
        });
    }

    public GenericType getObjectGenericType() {
        return this.extRegistry.objectGenericType;
    }

    public ClassInfo newClassInfo(Class<?> cls, Serializer<?> serializer, short classId) {
        return new ClassInfo(this, cls, null, serializer, classId);
    }

    public ClassInfo nilClassInfo() {
        return new ClassInfo(this, null, null, null, 0);
    }

    public ClassInfoHolder nilClassInfoHolder() {
        return new ClassInfoHolder(this.nilClassInfo());
    }

    public boolean isPrimitive(short classId) {
        return classId >= 4 && classId <= 12;
    }

    public MetaStringResolver getMetaStringResolver() {
        return this.metaStringResolver;
    }

    public CodeGenerator getCodeGenerator(ClassLoader ... loaders) {
        ArrayList loaderList = new ArrayList(loaders.length);
        Collections.addAll(loaderList, loaders);
        return (CodeGenerator)this.extRegistry.codeGeneratorMap.get(loaderList);
    }

    public void setCodeGenerator(ClassLoader loader, CodeGenerator codeGenerator) {
        this.setCodeGenerator(new ClassLoader[]{loader}, codeGenerator);
    }

    public void setCodeGenerator(ClassLoader[] loaders, CodeGenerator codeGenerator) {
        this.extRegistry.codeGeneratorMap.put(Arrays.asList(loaders), codeGenerator);
    }

    public Fury getFury() {
        return this.fury;
    }

    public static void _addGraalvmClassRegistry(int furyConfigHash, ClassResolver classResolver) {
        if (GraalvmSupport.isGraalBuildtime()) {
            GraalvmClassRegistry registry = GRAALVM_REGISTRY.computeIfAbsent(furyConfigHash, k -> new GraalvmClassRegistry());
            registry.resolvers.add(classResolver);
        }
    }

    private GraalvmClassRegistry getGraalvmClassRegistry() {
        return GRAALVM_REGISTRY.computeIfAbsent(this.fury.getConfig().getConfigHash(), k -> new GraalvmClassRegistry());
    }

    private Class<? extends Serializer> getSerializerClassFromGraalvmRegistry(Class<?> cls) {
        GraalvmClassRegistry registry = this.getGraalvmClassRegistry();
        List classResolvers = registry.resolvers;
        if (classResolvers.isEmpty()) {
            return null;
        }
        for (ClassResolver classResolver : classResolvers) {
            ClassInfo classInfo;
            if (classResolver == this || (classInfo = classResolver.classInfoMap.get(cls)) == null || classInfo.serializer == null) continue;
            return classInfo.serializer.getClass();
        }
        Class serializerClass = (Class)registry.serializerClassMap.get(cls);
        if (serializerClass != null) {
            return serializerClass;
        }
        if (GraalvmSupport.isGraalRuntime()) {
            if (Functions.isLambda(cls) || ReflectionUtils.isJdkProxy(cls)) {
                return null;
            }
            throw new RuntimeException(String.format("Class %s is not registered", cls));
        }
        return null;
    }

    private Class<? extends Serializer> getMetaSharedDeserializerClassFromGraalvmRegistry(Class<?> cls, ClassDef classDef) {
        GraalvmClassRegistry registry = this.getGraalvmClassRegistry();
        List classResolvers = registry.resolvers;
        if (classResolvers.isEmpty()) {
            return null;
        }
        Class deserializerClass = (Class)registry.deserializerClassMap.get(classDef.getId());
        if (deserializerClass != null) {
            return deserializerClass;
        }
        if (GraalvmSupport.isGraalRuntime()) {
            if (Functions.isLambda(cls) || ReflectionUtils.isJdkProxy(cls)) {
                return null;
            }
            throw new RuntimeException(String.format("Class %s is not registered", cls));
        }
        return null;
    }

    private static class GraalvmClassRegistry {
        private final List<ClassResolver> resolvers = Collections.synchronizedList(new ArrayList());
        private final Map<Class<?>, Class<? extends Serializer>> serializerClassMap = new ConcurrentHashMap();
        private final Map<Long, Class<? extends Serializer>> deserializerClassMap = new ConcurrentHashMap<Long, Class<? extends Serializer>>();

        private GraalvmClassRegistry() {
        }
    }

    private static class ClassNameBytes {
        private final long packageHash;
        private final long classNameHash;

        private ClassNameBytes(long packageHash, long classNameHash) {
            this.packageHash = packageHash;
            this.classNameHash = classNameHash;
        }

        public boolean equals(Object o) {
            ClassNameBytes that = (ClassNameBytes)o;
            return this.packageHash == that.packageHash && this.classNameHash == that.classNameHash;
        }

        public int hashCode() {
            int result = 31 + (int)(this.packageHash ^ this.packageHash >>> 32);
            result = result * 31 + (int)(this.classNameHash ^ this.classNameHash >>> 32);
            return result;
        }
    }

    private static class ExtRegistry {
        private short classIdGenerator = 1;
        private SerializerFactory serializerFactory;
        private final IdentityMap<Class<?>, Short> registeredClassIdMap = new IdentityMap(150);
        private final Map<String, Class<?>> registeredClasses = new HashMap(150);
        private final Set<Class<?>> getClassCtx = new HashSet();
        private final Map<Class<?>, FieldResolver> fieldResolverMap = new HashMap();
        private final LongMap<Tuple2<ClassDef, ClassInfo>> classIdToDef = new LongMap();
        private final Map<Class<?>, ClassDef> currentLayerClassDef = new HashMap();
        private final Map<Tuple2<Class<?>, Class<?>>, ClassInfo> transformedClassInfo = new HashMap();
        private final ConcurrentHashMap<Tuple2<Class<?>, Boolean>, SortedMap<Field, Descriptor>> descriptorsCache = new ConcurrentHashMap();
        private ClassChecker classChecker = (classResolver, className) -> true;
        private GenericType objectGenericType;
        private Map<List<ClassLoader>, CodeGenerator> codeGeneratorMap = new HashMap<List<ClassLoader>, CodeGenerator>();

        private ExtRegistry() {
        }

        static /* synthetic */ short access$208(ExtRegistry x0) {
            short s2 = x0.classIdGenerator;
            x0.classIdGenerator = (short)(s2 + 1);
            return s2;
        }
    }
}

