/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.resolver;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.fury.exception.InsecureException;

class DisallowedList {
    private static final String DISALLOWED_LIST_TXT_PATH = "fury/disallowed.txt";
    private static final String SHA256_HASH = "53ecb405085d795d45ce033cd4f1055ae06247a5dbaa617ecd20e4aac4303f60";
    private static final Set<String> DEFAULT_DISALLOWED_LIST_SET;

    DisallowedList() {
    }

    private static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int numbytesRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((numbytesRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, numbytesRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private static String calculateSHA256(TreeSet<String> set) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(String.join((CharSequence)",", set).getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
    }

    static void checkNotInDisallowedList(String clsName) {
        if (DEFAULT_DISALLOWED_LIST_SET.contains(clsName)) {
            throw new InsecureException(String.format("%s hit disallowed list", clsName));
        }
    }

    static {
        block16: {
            try (InputStream is = DisallowedList.class.getClassLoader().getResourceAsStream(DISALLOWED_LIST_TXT_PATH);){
                if (is != null) {
                    DEFAULT_DISALLOWED_LIST_SET = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().filter(line -> !line.isEmpty() && !line.startsWith("#")).collect(Collectors.toSet());
                    String calculatedHash = DisallowedList.calculateSHA256(new TreeSet<String>(DEFAULT_DISALLOWED_LIST_SET));
                    if (!SHA256_HASH.equals(calculatedHash)) {
                        throw new SecurityException("Disallowed list has been tampered");
                    }
                    break block16;
                }
                throw new IllegalStateException(String.format("Read disallowed list %s failed", DISALLOWED_LIST_TXT_PATH));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Read disallowed list %s failed", DISALLOWED_LIST_TXT_PATH), e);
            }
        }
    }
}

