/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.fury.Fury;
import org.apache.fury.collection.Tuple2;
import org.apache.fury.collection.Tuple3;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.Platform;
import org.apache.fury.meta.ClassDef;
import org.apache.fury.reflect.FieldAccessor;
import org.apache.fury.resolver.ClassInfoHolder;
import org.apache.fury.resolver.ClassResolver;
import org.apache.fury.resolver.RefResolver;
import org.apache.fury.serializer.AbstractObjectSerializer;
import org.apache.fury.serializer.ObjectSerializer;
import org.apache.fury.serializer.Serializer;
import org.apache.fury.serializer.Serializers;
import org.apache.fury.type.Descriptor;
import org.apache.fury.type.DescriptorGrouper;
import org.apache.fury.type.Generics;
import org.apache.fury.util.Preconditions;
import org.apache.fury.util.record.RecordInfo;
import org.apache.fury.util.record.RecordUtils;

public class MetaSharedSerializer<T>
extends AbstractObjectSerializer<T> {
    private final AbstractObjectSerializer.FinalTypeField[] finalFields;
    private final boolean[] isFinal;
    private final AbstractObjectSerializer.GenericTypeField[] otherFields;
    private final AbstractObjectSerializer.GenericTypeField[] containerFields;
    private final RecordInfo recordInfo;
    private Serializer<T> serializer;
    private final ClassInfoHolder classInfoHolder;

    public MetaSharedSerializer(Fury fury, Class<T> type, ClassDef classDef) {
        super(fury, type);
        Preconditions.checkArgument(!fury.getConfig().checkClassVersion(), "Class version check should be disabled when compatible mode is enabled.");
        Preconditions.checkArgument(fury.getConfig().isMetaShareEnabled(), "Meta share must be enabled.");
        Collection<Descriptor> descriptors = MetaSharedSerializer.consolidateFields(this.classResolver, type, classDef);
        DescriptorGrouper descriptorGrouper = DescriptorGrouper.createDescriptorGrouper(this.classResolver::isMonomorphic, descriptors, false, fury.compressInt(), fury.getConfig().compressLong());
        Tuple3<Tuple2<AbstractObjectSerializer.FinalTypeField[], boolean[]>, AbstractObjectSerializer.GenericTypeField[], AbstractObjectSerializer.GenericTypeField[]> infos = AbstractObjectSerializer.buildFieldInfos(fury, descriptorGrouper);
        this.finalFields = (AbstractObjectSerializer.FinalTypeField[])((Tuple2)infos.f0).f0;
        this.isFinal = (boolean[])((Tuple2)infos.f0).f1;
        this.otherFields = (AbstractObjectSerializer.GenericTypeField[])infos.f1;
        this.containerFields = (AbstractObjectSerializer.GenericTypeField[])infos.f2;
        this.classInfoHolder = this.classResolver.nilClassInfoHolder();
        if (this.isRecord) {
            List<String> fieldNames = descriptorGrouper.getSortedDescriptors().stream().map(Descriptor::getName).collect(Collectors.toList());
            this.recordInfo = new RecordInfo(type, fieldNames);
        } else {
            this.recordInfo = null;
        }
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        if (this.serializer == null) {
            this.serializer = this.classResolver.createSerializerSafe(this.type, () -> new ObjectSerializer(this.fury, this.type));
        }
        this.serializer.write(buffer, value);
    }

    @Override
    public T read(MemoryBuffer buffer) {
        Object fieldValue;
        if (this.isRecord) {
            Object[] fieldValues = new Object[this.finalFields.length + this.otherFields.length + this.containerFields.length];
            this.readFields(buffer, fieldValues);
            fieldValues = RecordUtils.remapping(this.recordInfo, fieldValues);
            try {
                Object t2 = this.constructor.invokeWithArguments(fieldValues);
                Arrays.fill(this.recordInfo.getRecordComponents(), null);
                return (T)t2;
            }
            catch (Throwable e) {
                Platform.throwException(e);
            }
        }
        Object obj = this.newBean();
        Fury fury = this.fury;
        RefResolver refResolver = this.refResolver;
        ClassResolver classResolver = this.classResolver;
        refResolver.reference(obj);
        AbstractObjectSerializer.FinalTypeField[] finalFields = this.finalFields;
        for (int i = 0; i < finalFields.length; ++i) {
            AbstractObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
            boolean isFinal = this.isFinal[i];
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            if (fieldAccessor != null) {
                short classId = fieldInfo.classId;
                if (!ObjectSerializer.readPrimitiveFieldValueFailed(fury, buffer, obj, fieldAccessor, classId) || !ObjectSerializer.readBasicObjectFieldValueFailed(fury, buffer, obj, fieldAccessor, classId)) continue;
                assert (fieldInfo.classInfo != null);
                fieldValue = ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal, buffer);
                fieldAccessor.putObject(obj, fieldValue);
                continue;
            }
            if (!MetaSharedSerializer.skipPrimitiveFieldValueFailed(fury, fieldInfo.classId, buffer)) continue;
            if (fieldInfo.classInfo == null) {
                fury.readRef(buffer, this.classInfoHolder);
                continue;
            }
            ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal, buffer);
        }
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.otherFields) {
            Object fieldValue2 = ObjectSerializer.readOtherFieldValue(fury, fieldInfo, buffer);
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            if (fieldAccessor == null) continue;
            fieldAccessor.putObject(obj, fieldValue2);
        }
        Generics generics = fury.getGenerics();
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.containerFields) {
            fieldValue = ObjectSerializer.readContainerFieldValue(fury, generics, fieldInfo, buffer);
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            if (fieldAccessor == null) continue;
            fieldAccessor.putObject(obj, fieldValue);
        }
        return obj;
    }

    private void readFields(MemoryBuffer buffer, Object[] fields) {
        Object fieldValue;
        int counter = 0;
        Fury fury = this.fury;
        RefResolver refResolver = this.refResolver;
        ClassResolver classResolver = this.classResolver;
        AbstractObjectSerializer.FinalTypeField[] finalFields = this.finalFields;
        for (int i = 0; i < finalFields.length; ++i) {
            AbstractObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
            boolean isFinal = this.isFinal[i];
            if (fieldInfo.fieldAccessor != null) {
                assert (fieldInfo.classInfo != null);
                short classId = fieldInfo.classId;
                if (classId >= 5 && classId <= 12) {
                    fields[counter++] = Serializers.readPrimitiveValue(fury, buffer, classId);
                    continue;
                }
                fieldValue = ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal, buffer);
                fields[counter++] = fieldValue;
                continue;
            }
            if (MetaSharedSerializer.skipPrimitiveFieldValueFailed(fury, fieldInfo.classId, buffer)) {
                if (fieldInfo.classInfo == null) {
                    fury.readRef(buffer, this.classInfoHolder);
                } else {
                    ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal, buffer);
                }
            }
            fields[counter++] = null;
        }
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.otherFields) {
            fieldValue = ObjectSerializer.readOtherFieldValue(fury, fieldInfo, buffer);
            fields[counter++] = fieldValue;
        }
        Generics generics = fury.getGenerics();
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.containerFields) {
            Object fieldValue2 = ObjectSerializer.readContainerFieldValue(fury, generics, fieldInfo, buffer);
            fields[counter++] = fieldValue2;
        }
    }

    static boolean skipPrimitiveFieldValueFailed(Fury fury, short classId, MemoryBuffer buffer) {
        switch (classId) {
            case 5: {
                buffer.increaseReaderIndex(1);
                return false;
            }
            case 6: {
                buffer.increaseReaderIndex(1);
                return false;
            }
            case 7: {
                buffer.increaseReaderIndex(2);
                return false;
            }
            case 8: {
                buffer.increaseReaderIndex(2);
                return false;
            }
            case 9: {
                if (fury.compressInt()) {
                    buffer.readVarInt32();
                } else {
                    buffer.increaseReaderIndex(4);
                }
                return false;
            }
            case 10: {
                buffer.increaseReaderIndex(4);
                return false;
            }
            case 11: {
                fury.readInt64(buffer);
                return false;
            }
            case 12: {
                buffer.increaseReaderIndex(8);
                return false;
            }
        }
        return true;
    }

    public static Collection<Descriptor> consolidateFields(ClassResolver classResolver, Class<?> cls, ClassDef classDef) {
        return classDef.getDescriptors(classResolver, cls);
    }
}

