/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.type;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.fury.collection.IdentityMap;
import org.apache.fury.collection.Tuple2;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.reflect.TypeParameter;
import org.apache.fury.reflect.TypeRef;
import org.apache.fury.type.Descriptor;
import org.apache.fury.type.ScalaTypes;
import org.apache.fury.util.Preconditions;

public class TypeUtils {
    public static final String JAVA_BOOLEAN = "boolean";
    public static final String JAVA_BYTE = "byte";
    public static final String JAVA_SHORT = "short";
    public static final String JAVA_INT = "int";
    public static final String JAVA_LONG = "long";
    public static final String JAVA_FLOAT = "float";
    public static final String JAVA_DOUBLE = "double";
    public static final TypeRef<?> PRIMITIVE_VOID_TYPE = TypeRef.of(Void.TYPE);
    public static final TypeRef<?> VOID_TYPE = TypeRef.of(Void.class);
    public static final TypeRef<?> PRIMITIVE_BYTE_TYPE = TypeRef.of(Byte.TYPE);
    public static final TypeRef<?> PRIMITIVE_BOOLEAN_TYPE = TypeRef.of(Boolean.TYPE);
    public static final TypeRef<?> PRIMITIVE_CHAR_TYPE = TypeRef.of(Character.TYPE);
    public static final TypeRef<?> PRIMITIVE_SHORT_TYPE = TypeRef.of(Short.TYPE);
    public static final TypeRef<?> PRIMITIVE_INT_TYPE = TypeRef.of(Integer.TYPE);
    public static final TypeRef<?> PRIMITIVE_LONG_TYPE = TypeRef.of(Long.TYPE);
    public static final TypeRef<?> PRIMITIVE_FLOAT_TYPE = TypeRef.of(Float.TYPE);
    public static final TypeRef<?> PRIMITIVE_DOUBLE_TYPE = TypeRef.of(Double.TYPE);
    public static final TypeRef<?> BYTE_TYPE = TypeRef.of(Byte.class);
    public static final TypeRef<?> BOOLEAN_TYPE = TypeRef.of(Boolean.class);
    public static final TypeRef<?> CHAR_TYPE = TypeRef.of(Character.class);
    public static final TypeRef<?> SHORT_TYPE = TypeRef.of(Short.class);
    public static final TypeRef<?> INT_TYPE = TypeRef.of(Integer.class);
    public static final TypeRef<?> LONG_TYPE = TypeRef.of(Long.class);
    public static final TypeRef<?> FLOAT_TYPE = TypeRef.of(Float.class);
    public static final TypeRef<?> DOUBLE_TYPE = TypeRef.of(Double.class);
    public static final TypeRef<?> STRING_TYPE = TypeRef.of(String.class);
    public static final TypeRef<?> BIG_DECIMAL_TYPE = TypeRef.of(BigDecimal.class);
    public static final TypeRef<?> BIG_INTEGER_TYPE = TypeRef.of(BigInteger.class);
    public static final TypeRef<?> DATE_TYPE = TypeRef.of(Date.class);
    public static final TypeRef<?> LOCAL_DATE_TYPE = TypeRef.of(LocalDate.class);
    public static final TypeRef<?> TIMESTAMP_TYPE = TypeRef.of(Timestamp.class);
    public static final TypeRef<?> INSTANT_TYPE = TypeRef.of(Instant.class);
    public static final TypeRef<?> BINARY_TYPE = TypeRef.of(byte[].class);
    public static final TypeRef<?> ITERABLE_TYPE = TypeRef.of(Iterable.class);
    public static final TypeRef<?> ITERATOR_TYPE = TypeRef.of(Iterator.class);
    public static final TypeRef<?> COLLECTION_TYPE = TypeRef.of(Collection.class);
    public static final TypeRef<?> LIST_TYPE = TypeRef.of(List.class);
    public static final TypeRef<?> ARRAYLIST_TYPE = TypeRef.of(ArrayList.class);
    public static final TypeRef<?> SET_TYPE = TypeRef.of(Set.class);
    public static final TypeRef<?> HASHSET_TYPE = TypeRef.of(HashSet.class);
    public static final TypeRef<?> MAP_TYPE = TypeRef.of(Map.class);
    public static final TypeRef<?> MAP_ENTRY_TYPE = TypeRef.of(Map.Entry.class);
    public static final TypeRef<?> HASHMAP_TYPE = TypeRef.of(HashMap.class);
    public static final TypeRef<?> OBJECT_TYPE = TypeRef.of(Object.class);
    public static Type ITERATOR_RETURN_TYPE;
    public static Type NEXT_RETURN_TYPE;
    public static Type KEY_SET_RETURN_TYPE;
    public static Type VALUES_RETURN_TYPE;
    public static final TypeRef<?> PRIMITIVE_BYTE_ARRAY_TYPE;
    public static final TypeRef<?> PRIMITIVE_BOOLEAN_ARRAY_TYPE;
    public static final TypeRef<?> PRIMITIVE_SHORT_ARRAY_TYPE;
    public static final TypeRef<?> PRIMITIVE_CHAR_ARRAY_TYPE;
    public static final TypeRef<?> PRIMITIVE_INT_ARRAY_TYPE;
    public static final TypeRef<?> PRIMITIVE_LONG_ARRAY_TYPE;
    public static final TypeRef<?> PRIMITIVE_FLOAT_ARRAY_TYPE;
    public static final TypeRef<?> PRIMITIVE_DOUBLE_ARRAY_TYPE;
    public static final TypeRef<?> OBJECT_ARRAY_TYPE;
    public static final TypeRef<?> CLASS_TYPE;
    public static Set<TypeRef<?>> SUPPORTED_TYPES;
    private static final List<Class<?>> sortedPrimitiveClasses;
    private static final List<Class<?>> sortedBoxedClasses;
    private static final int[] sortedSizes;
    private static final IdentityMap<Class<?>, Class<?>> primToWrap;
    private static final IdentityMap<Class<?>, Class<?>> wrapToPrim;

    private static void add(IdentityMap<Class<?>, Class<?>> forward, IdentityMap<Class<?>, Class<?>> backward, Class<?> key, Class<?> value) {
        forward.put(key, value);
        backward.put(value, key);
    }

    public static boolean isNullable(Class<?> clz) {
        return !TypeUtils.isPrimitive(clz);
    }

    public static boolean isPrimitive(Class<?> clz) {
        return clz.isPrimitive();
    }

    public static boolean isBoxed(Class<?> clz) {
        return wrapToPrim.containsKey(clz);
    }

    public static Class<?> wrap(Class<?> clz) {
        return TypeUtils.boxedType(clz);
    }

    public static Class<?> unwrap(Class<?> clz) {
        if (clz.isPrimitive()) {
            return clz;
        }
        return wrapToPrim.get(clz, clz);
    }

    public static Class<?> boxedType(Class<?> clz) {
        if (!clz.isPrimitive()) {
            return clz;
        }
        return primToWrap.get(clz);
    }

    public static List<Class<?>> getSortedPrimitiveClasses() {
        return sortedPrimitiveClasses;
    }

    public static List<Class<?>> getSortedBoxedClasses() {
        return sortedBoxedClasses;
    }

    public static Class<?> maxType(Class<?> ... numericTypes) {
        Preconditions.checkArgument(numericTypes.length >= 2);
        int maxIndex = 0;
        for (Class<?> numericType : numericTypes) {
            int index = TypeUtils.isPrimitive(numericType) ? sortedPrimitiveClasses.indexOf(numericType) : sortedBoxedClasses.indexOf(numericType);
            if (index == -1) {
                throw new IllegalArgumentException(String.format("Wrong numericTypes %s", Arrays.toString(numericTypes)));
            }
            maxIndex = Math.max(maxIndex, index);
        }
        return sortedPrimitiveClasses.get(maxIndex);
    }

    public static int getSizeOfPrimitiveType(TypeRef<?> numericType) {
        return TypeUtils.getSizeOfPrimitiveType(TypeUtils.getRawType(numericType));
    }

    public static int getSizeOfPrimitiveType(Class<?> numericType) {
        if (TypeUtils.isPrimitive(numericType)) {
            int index = sortedPrimitiveClasses.indexOf(numericType);
            return sortedSizes[index];
        }
        String msg = String.format("Class %s must be primitive", numericType);
        throw new IllegalArgumentException(msg);
    }

    public static String defaultValue(Class<?> type) {
        return TypeUtils.defaultValue(type.getSimpleName(), false);
    }

    public static String defaultValue(String type) {
        return TypeUtils.defaultValue(type, false);
    }

    public static String defaultValue(String type, boolean typedNull) {
        switch (type) {
            case "boolean": {
                return "false";
            }
            case "byte": {
                return "(byte)0";
            }
            case "short": {
                return "(short)0";
            }
            case "int": {
                return "0";
            }
            case "long": {
                return "0L";
            }
            case "float": {
                return "0.0f";
            }
            case "double": {
                return "0.0";
            }
        }
        if (typedNull) {
            return String.format("((%s)null)", type);
        }
        return "null";
    }

    public static Class<?> getRawType(TypeRef<?> typeRef) {
        Type type = typeRef.getType();
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        return TypeUtils.getRawType(typeRef.getType());
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof TypeVariable) {
            return TypeUtils.getRawType(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return TypeUtils.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(TypeUtils.getRawType(TypeRef.of(componentType)), 0).getClass();
        }
        throw new AssertionError((Object)("Unknown type: " + type));
    }

    public static int getArrayDimensions(TypeRef<?> type) {
        return TypeUtils.getArrayDimensions(TypeUtils.getRawType(type));
    }

    public static int getArrayDimensions(Class<?> type) {
        return (Integer)TypeUtils.getArrayComponentInfo(type).f1;
    }

    public static int getArrayDimensions(String className) {
        int dimension = 0;
        while (className.charAt(dimension) == '[') {
            ++dimension;
        }
        return dimension;
    }

    public static Class<?> getComponentIfArray(Class<?> type) {
        if (type.isArray()) {
            return TypeUtils.getArrayComponent(type);
        }
        return type;
    }

    public static Class<?> getArrayComponent(Class<?> type) {
        return (Class)TypeUtils.getArrayComponentInfo(type).f0;
    }

    public static Tuple2<Class<?>, Integer> getArrayComponentInfo(Class<?> type) {
        Class<?> t2;
        Preconditions.checkArgument(type.isArray());
        int dimension = 0;
        for (t2 = type; t2 != null && t2.isArray(); t2 = t2.getComponentType()) {
            ++dimension;
        }
        return Tuple2.of(t2, dimension);
    }

    public static String getArrayType(TypeRef<?> type) {
        return TypeUtils.getArrayType(TypeUtils.getRawType(type));
    }

    public static String getArrayType(Class<?> type) {
        Tuple2<Class<?>, Integer> info = TypeUtils.getArrayComponentInfo(type);
        StringBuilder typeBuilder = new StringBuilder(ReflectionUtils.getLiteralName((Class)info.f0));
        for (int i = 0; i < (Integer)info.f1; ++i) {
            typeBuilder.append("[]");
        }
        return typeBuilder.toString();
    }

    public static String getArrayType(Class<?> elemType, int[] dimensions) {
        StringBuilder typeBuilder = new StringBuilder(ReflectionUtils.getLiteralName(elemType));
        for (int dimension : dimensions) {
            typeBuilder.append('[').append(dimension).append(']');
        }
        return typeBuilder.toString();
    }

    public static String getArrayClass(Class<?> type) {
        Tuple2<Class<?>, Integer> info = TypeUtils.getArrayComponentInfo(type);
        StringBuilder typeBuilder = new StringBuilder(((Class)info.f0).getName());
        for (int i = 0; i < (Integer)info.f1; ++i) {
            typeBuilder.append("[]");
        }
        return typeBuilder.toString();
    }

    public static TypeRef<?> getMultiDimensionArrayElementType(TypeRef<?> type) {
        TypeRef<?> t2;
        for (t2 = type; t2 != null && t2.isArray(); t2 = t2.getComponentType()) {
        }
        return t2;
    }

    public static TypeRef<?> getElementType(TypeRef<?> typeRef) {
        ParameterizedType parameterizedType;
        Type type = typeRef.getType();
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() == List.class) {
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            Preconditions.checkState(actualTypeArguments.length == 1);
            Type t2 = actualTypeArguments[0];
            if (t2.getClass() == Class.class) {
                return TypeRef.of(t2);
            }
        }
        if (typeRef.getType().getTypeName().startsWith("scala.collection")) {
            return ScalaTypes.getElementType(typeRef);
        }
        TypeRef<Iterable> supertype = typeRef.getSupertype(Iterable.class);
        return supertype.resolveType(ITERATOR_RETURN_TYPE).resolveType(NEXT_RETURN_TYPE);
    }

    public static TypeRef<?> getCollectionType(TypeRef<?> typeRef) {
        TypeRef<Iterable> supertype = typeRef.getSupertype(Iterable.class);
        return supertype.getSubtype(Collection.class);
    }

    public static Tuple2<TypeRef<?>, TypeRef<?>> getMapKeyValueType(TypeRef<?> typeRef) {
        ParameterizedType parameterizedType;
        Type type = typeRef.getType();
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() == Map.class) {
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            Preconditions.checkState(actualTypeArguments.length == 2);
            if (actualTypeArguments[0].getClass() == Class.class && actualTypeArguments[1].getClass() == Class.class) {
                return Tuple2.of(TypeRef.of(actualTypeArguments[0]), TypeRef.of(actualTypeArguments[1]));
            }
        }
        if (typeRef.getType().getTypeName().startsWith("scala.collection")) {
            return ScalaTypes.getMapKeyValueType(typeRef);
        }
        TypeRef<Map> supertype = typeRef.getSupertype(Map.class);
        TypeRef<?> keyType = TypeUtils.getElementType(supertype.resolveType(KEY_SET_RETURN_TYPE));
        TypeRef<?> valueType = TypeUtils.getElementType(supertype.resolveType(VALUES_RETURN_TYPE));
        return Tuple2.of(keyType, valueType);
    }

    public static <E> TypeRef<ArrayList<E>> arrayListOf(Class<E> elemType) {
        return new TypeRef<ArrayList<E>>(){}.where(new TypeParameter<E>(){}, elemType);
    }

    public static <E> TypeRef<List<E>> listOf(Class<E> elemType) {
        return new TypeRef<List<E>>(){}.where(new TypeParameter<E>(){}, elemType);
    }

    public static <E> TypeRef<Collection<E>> collectionOf(Class<E> elemType) {
        return TypeUtils.collectionOf(TypeRef.of(elemType));
    }

    public static <E> TypeRef<Collection<E>> collectionOf(TypeRef<E> elemType) {
        return new TypeRef<Collection<E>>(){}.where(new TypeParameter<E>(){}, elemType);
    }

    public static <E> TypeRef<Collection<E>> collectionOf(TypeRef<E> elemType, Object extMeta) {
        return new TypeRef<Collection<E>>(extMeta){}.where(new TypeParameter<E>(){}, elemType);
    }

    public static <K, V> TypeRef<Map<K, V>> mapOf(Class<K> keyType, Class<V> valueType) {
        return TypeUtils.mapOf(TypeRef.of(keyType), TypeRef.of(valueType));
    }

    public static <K, V> TypeRef<Map<K, V>> mapOf(TypeRef<K> keyType, TypeRef<V> valueType) {
        return new TypeRef<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType);
    }

    public static <K, V> TypeRef<Map<K, V>> mapOf(TypeRef<K> keyType, TypeRef<V> valueType, Object extMeta) {
        return new TypeRef<Map<K, V>>(extMeta){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType);
    }

    public static <K, V> TypeRef<? extends Map<K, V>> mapOf(Class<?> mapType, TypeRef<K> keyType, TypeRef<V> valueType) {
        TypeRef<Map<K, V>> mapTypeRef = TypeUtils.mapOf(keyType, valueType);
        return mapTypeRef.getSubtype(mapType);
    }

    public static <K, V> TypeRef<? extends Map<K, V>> mapOf(Class<?> mapType, Class<K> keyType, Class<V> valueType) {
        TypeRef<Map<K, V>> mapTypeRef = TypeUtils.mapOf(keyType, valueType);
        return mapTypeRef.getSubtype(mapType);
    }

    public static <K, V> TypeRef<HashMap<K, V>> hashMapOf(Class<K> keyType, Class<V> valueType) {
        return new TypeRef<HashMap<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType);
    }

    public static boolean isCollection(Class<?> cls) {
        return cls == ArrayList.class || Collection.class.isAssignableFrom(cls);
    }

    public static boolean isMap(Class<?> cls) {
        return cls == HashMap.class || Map.class.isAssignableFrom(cls);
    }

    public static boolean isBean(Type type) {
        return TypeUtils.isBean(TypeRef.of(type));
    }

    public static boolean isBean(Class<?> clz) {
        return TypeUtils.isBean(TypeRef.of(clz));
    }

    public static boolean isBean(TypeRef<?> typeRef) {
        return TypeUtils.isBean(typeRef, new LinkedHashSet<TypeRef>());
    }

    private static boolean isBean(TypeRef<?> typeRef, LinkedHashSet<TypeRef> walkedTypePath) {
        Class<?> cls = TypeUtils.getRawType(typeRef);
        if (Modifier.isAbstract(cls.getModifiers()) || Modifier.isInterface(cls.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(cls.getModifiers())) {
            boolean maybe;
            if (cls.getEnclosingClass() != null && !Modifier.isStatic(cls.getModifiers())) {
                return false;
            }
            LinkedHashSet<TypeRef> newTypePath = new LinkedHashSet<TypeRef>(walkedTypePath);
            newTypePath.add(typeRef);
            if (cls == Object.class) {
                return false;
            }
            boolean bl = maybe = !SUPPORTED_TYPES.contains(typeRef) && !typeRef.isArray() && !cls.isEnum() && !ITERABLE_TYPE.isSupertypeOf(typeRef) && !MAP_TYPE.isSupertypeOf(typeRef);
            if (maybe) {
                return Descriptor.getDescriptors(cls).stream().allMatch(d -> {
                    TypeRef<?> t2 = d.getTypeRef();
                    return TypeUtils.isSupported(t2, newTypePath) || TypeUtils.isBean(t2, newTypePath);
                });
            }
            return false;
        }
        return false;
    }

    public static boolean isSupported(TypeRef<?> typeRef) {
        return TypeUtils.isSupported(typeRef, new LinkedHashSet<TypeRef>());
    }

    private static boolean isSupported(TypeRef<?> typeRef, LinkedHashSet<TypeRef> walkedTypePath) {
        Class<Object> cls = TypeUtils.getRawType(typeRef);
        if (!Modifier.isPublic(cls.getModifiers())) {
            return false;
        }
        if (cls == Object.class) {
            return true;
        }
        if (SUPPORTED_TYPES.contains(typeRef)) {
            return true;
        }
        if (typeRef.isArray()) {
            return TypeUtils.isSupported(Objects.requireNonNull(typeRef.getComponentType()));
        }
        if (ITERABLE_TYPE.isSupertypeOf(typeRef)) {
            boolean isSuperOfArrayList = cls.isAssignableFrom(ArrayList.class);
            boolean isSuperOfHashSet = cls.isAssignableFrom(HashSet.class);
            if (!isSuperOfArrayList && !isSuperOfHashSet && (cls.isInterface() || Modifier.isAbstract(cls.getModifiers()))) {
                return false;
            }
            return TypeUtils.isSupported(TypeUtils.getElementType(typeRef));
        }
        if (MAP_TYPE.isSupertypeOf(typeRef)) {
            boolean isSuperOfHashMap = cls.isAssignableFrom(HashMap.class);
            if (!isSuperOfHashMap && (cls.isInterface() || Modifier.isAbstract(cls.getModifiers()))) {
                return false;
            }
            Tuple2<TypeRef<?>, TypeRef<?>> mapKeyValueType = TypeUtils.getMapKeyValueType(typeRef);
            return TypeUtils.isSupported((TypeRef)mapKeyValueType.f0) && TypeUtils.isSupported((TypeRef)mapKeyValueType.f1);
        }
        if (walkedTypePath.contains(typeRef)) {
            throw new UnsupportedOperationException("cyclic type is not supported. walkedTypePath: " + walkedTypePath);
        }
        LinkedHashSet<TypeRef> newTypePath = new LinkedHashSet<TypeRef>(walkedTypePath);
        newTypePath.add(typeRef);
        return TypeUtils.isBean(typeRef, newTypePath);
    }

    public static LinkedHashSet<Class<?>> listBeansRecursiveInclusive(Class<?> beanClass) {
        return TypeUtils.listBeansRecursiveInclusive(beanClass, new LinkedHashSet());
    }

    private static LinkedHashSet<Class<?>> listBeansRecursiveInclusive(Class<?> beanClass, LinkedHashSet<TypeRef<?>> walkedTypePath) {
        LinkedHashSet beans = new LinkedHashSet();
        if (TypeUtils.isBean(beanClass)) {
            beans.add(beanClass);
        }
        LinkedHashSet typeRefs = new LinkedHashSet();
        List<Descriptor> descriptors = Descriptor.getDescriptors(beanClass);
        for (Descriptor descriptor : descriptors) {
            TypeRef<?> typeRef = descriptor.getTypeRef();
            typeRefs.add(descriptor.getTypeRef());
            typeRefs.addAll(TypeUtils.getAllTypeArguments(typeRef));
        }
        for (TypeRef typeRef : typeRefs) {
            LinkedHashSet newPath;
            Class<?> type = TypeUtils.getRawType(typeRef);
            if (TypeUtils.isBean(type)) {
                beans.add(type);
                if (walkedTypePath.contains(typeRef)) {
                    throw new UnsupportedOperationException("cyclic type is not supported. walkedTypePath: " + walkedTypePath);
                }
                LinkedHashSet newPath2 = new LinkedHashSet(walkedTypePath);
                newPath2.add(typeRef);
                beans.addAll(TypeUtils.listBeansRecursiveInclusive(type, newPath2));
                continue;
            }
            if (TypeUtils.isCollection(type)) {
                TypeRef<?> elementType = TypeUtils.getElementType(typeRef);
                newPath = new LinkedHashSet(walkedTypePath);
                newPath.add(elementType);
                beans.addAll(TypeUtils.listBeansRecursiveInclusive(elementType.getClass(), newPath));
                continue;
            }
            if (TypeUtils.isMap(type)) {
                Tuple2<TypeRef<?>, TypeRef<?>> mapKeyValueType = TypeUtils.getMapKeyValueType(typeRef);
                newPath = new LinkedHashSet(walkedTypePath);
                newPath.add((TypeRef<?>)mapKeyValueType.f0);
                newPath.add((TypeRef<?>)mapKeyValueType.f1);
                beans.addAll(TypeUtils.listBeansRecursiveInclusive(((TypeRef)mapKeyValueType.f0).getRawType(), newPath));
                beans.addAll(TypeUtils.listBeansRecursiveInclusive(((TypeRef)mapKeyValueType.f1).getRawType(), newPath));
                continue;
            }
            if (!type.isArray()) continue;
            Class<?> arrayComponent = TypeUtils.getArrayComponent(type);
            newPath = new LinkedHashSet(walkedTypePath);
            newPath.add(TypeRef.of(arrayComponent));
            beans.addAll(TypeUtils.listBeansRecursiveInclusive(arrayComponent, newPath));
        }
        return beans;
    }

    public static int computeStringHash(String str) {
        byte[] strBytes = str.getBytes(StandardCharsets.UTF_8);
        long hash = 17L;
        for (byte b : strBytes) {
            for (hash = hash * 31L + (long)b; hash > Integer.MAX_VALUE; hash /= 7L) {
            }
        }
        return (int)hash;
    }

    public static List<TypeRef<?>> getTypeArguments(TypeRef typeRef) {
        if (typeRef.getType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)typeRef.getType();
            return Arrays.stream(parameterizedType.getActualTypeArguments()).map(TypeRef::of).collect(Collectors.toList());
        }
        return new ArrayList();
    }

    public static List<TypeRef<?>> getAllTypeArguments(TypeRef typeRef) {
        List<TypeRef<?>> types = TypeUtils.getTypeArguments(typeRef);
        LinkedHashSet allTypeArguments = new LinkedHashSet(types);
        for (TypeRef<?> type : types) {
            allTypeArguments.addAll(TypeUtils.getAllTypeArguments(type));
        }
        return new ArrayList(allTypeArguments);
    }

    public static boolean isEnumArray(Class<?> clz) {
        if (!clz.isArray()) {
            return false;
        }
        return TypeUtils.getArrayComponent(clz).isEnum();
    }

    static {
        PRIMITIVE_BYTE_ARRAY_TYPE = TypeRef.of(byte[].class);
        PRIMITIVE_BOOLEAN_ARRAY_TYPE = TypeRef.of(boolean[].class);
        PRIMITIVE_SHORT_ARRAY_TYPE = TypeRef.of(short[].class);
        PRIMITIVE_CHAR_ARRAY_TYPE = TypeRef.of(char[].class);
        PRIMITIVE_INT_ARRAY_TYPE = TypeRef.of(int[].class);
        PRIMITIVE_LONG_ARRAY_TYPE = TypeRef.of(long[].class);
        PRIMITIVE_FLOAT_ARRAY_TYPE = TypeRef.of(float[].class);
        PRIMITIVE_DOUBLE_ARRAY_TYPE = TypeRef.of(double[].class);
        OBJECT_ARRAY_TYPE = TypeRef.of(Object[].class);
        CLASS_TYPE = TypeRef.of(Class.class);
        SUPPORTED_TYPES = new HashSet();
        SUPPORTED_TYPES.add(PRIMITIVE_BYTE_TYPE);
        SUPPORTED_TYPES.add(PRIMITIVE_BOOLEAN_TYPE);
        SUPPORTED_TYPES.add(PRIMITIVE_CHAR_TYPE);
        SUPPORTED_TYPES.add(PRIMITIVE_SHORT_TYPE);
        SUPPORTED_TYPES.add(PRIMITIVE_INT_TYPE);
        SUPPORTED_TYPES.add(PRIMITIVE_LONG_TYPE);
        SUPPORTED_TYPES.add(PRIMITIVE_FLOAT_TYPE);
        SUPPORTED_TYPES.add(PRIMITIVE_DOUBLE_TYPE);
        SUPPORTED_TYPES.add(BYTE_TYPE);
        SUPPORTED_TYPES.add(BOOLEAN_TYPE);
        SUPPORTED_TYPES.add(CHAR_TYPE);
        SUPPORTED_TYPES.add(SHORT_TYPE);
        SUPPORTED_TYPES.add(INT_TYPE);
        SUPPORTED_TYPES.add(LONG_TYPE);
        SUPPORTED_TYPES.add(FLOAT_TYPE);
        SUPPORTED_TYPES.add(DOUBLE_TYPE);
        SUPPORTED_TYPES.add(STRING_TYPE);
        SUPPORTED_TYPES.add(BIG_DECIMAL_TYPE);
        SUPPORTED_TYPES.add(DATE_TYPE);
        SUPPORTED_TYPES.add(LOCAL_DATE_TYPE);
        SUPPORTED_TYPES.add(TIMESTAMP_TYPE);
        SUPPORTED_TYPES.add(INSTANT_TYPE);
        try {
            ITERATOR_RETURN_TYPE = Iterable.class.getMethod("iterator", new Class[0]).getGenericReturnType();
            NEXT_RETURN_TYPE = Iterator.class.getMethod("next", new Class[0]).getGenericReturnType();
            KEY_SET_RETURN_TYPE = Map.class.getMethod("keySet", new Class[0]).getGenericReturnType();
            VALUES_RETURN_TYPE = Map.class.getMethod("values", new Class[0]).getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        sortedPrimitiveClasses = Arrays.asList(Void.TYPE, Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Long.TYPE, Double.TYPE);
        sortedBoxedClasses = Arrays.asList(Void.class, Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Float.class, Long.class, Double.class);
        sortedSizes = new int[]{0, 1, 1, 2, 2, 4, 4, 8, 8};
        primToWrap = new IdentityMap(18);
        wrapToPrim = new IdentityMap(18);
        TypeUtils.add(primToWrap, wrapToPrim, Boolean.TYPE, Boolean.class);
        TypeUtils.add(primToWrap, wrapToPrim, Byte.TYPE, Byte.class);
        TypeUtils.add(primToWrap, wrapToPrim, Character.TYPE, Character.class);
        TypeUtils.add(primToWrap, wrapToPrim, Double.TYPE, Double.class);
        TypeUtils.add(primToWrap, wrapToPrim, Float.TYPE, Float.class);
        TypeUtils.add(primToWrap, wrapToPrim, Integer.TYPE, Integer.class);
        TypeUtils.add(primToWrap, wrapToPrim, Long.TYPE, Long.class);
        TypeUtils.add(primToWrap, wrapToPrim, Short.TYPE, Short.class);
        TypeUtils.add(primToWrap, wrapToPrim, Void.TYPE, Void.class);
    }
}

