/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.fury.util.MathUtils;

public class DateTimeUtils {
    public static TimeZone DEFAULT_TIMEZONE = TimeZone.getDefault();
    public static long MICROS_PER_SECOND = TimeUnit.SECONDS.toMicros(1L);
    public static long MILLIS_PER_DAY = TimeUnit.DAYS.toMillis(1L);
    public static long MICROS_PER_MILLIS = 1000L;
    public static final long NANOS_PER_MICROS = TimeUnit.MICROSECONDS.toNanos(1L);
    public static final long NANOS_PER_MILLIS = NANOS_PER_MICROS * MICROS_PER_MILLIS;

    public static int localDateToDays(LocalDate localDate) {
        return Math.toIntExact(localDate.toEpochDay());
    }

    public static int fromJavaDate(Date date) {
        return DateTimeUtils.millisToDays(date.getTime());
    }

    public static int millisToDays(long millisUtc) {
        return DateTimeUtils.millisToDays(millisUtc, DEFAULT_TIMEZONE);
    }

    public static int millisToDays(long millisUtc, TimeZone timeZone) {
        long millisLocal = millisUtc + (long)timeZone.getOffset(millisUtc);
        return (int)Math.floorDiv(millisLocal, MILLIS_PER_DAY);
    }

    public static long fromJavaTimestamp(Timestamp t2) {
        return DateTimeUtils.instantToMicros(t2.toInstant());
    }

    public static long instantToMicros(Instant instant) {
        long us = Math.multiplyExact(instant.getEpochSecond(), MICROS_PER_SECOND);
        return Math.addExact(us, TimeUnit.NANOSECONDS.toMicros(instant.getNano()));
    }

    public static Instant truncateInstantToMicros(Instant instant) {
        return Instant.ofEpochSecond(instant.getEpochSecond(), (long)((int)TimeUnit.NANOSECONDS.toMicros(instant.getNano())) * NANOS_PER_MICROS);
    }

    public static long daysToMillis(int days) {
        return DateTimeUtils.daysToMillis(days, DEFAULT_TIMEZONE);
    }

    public static long daysToMillis(int days, TimeZone timeZone) {
        long millisLocal = (long)days * MILLIS_PER_DAY;
        return millisLocal - (long)DateTimeUtils.getOffsetFromLocalMillis(millisLocal, timeZone);
    }

    private static int getOffsetFromLocalMillis(long millisLocal, TimeZone tz) {
        int guess = tz.getRawOffset();
        int offset = tz.getOffset(millisLocal - (long)guess);
        if (offset != guess && (guess = tz.getOffset(millisLocal - (long)offset)) != offset) {
            LocalDate localDate = LocalDate.ofEpochDay(TimeUnit.MILLISECONDS.toDays(millisLocal));
            LocalTime localTime = LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(Math.floorMod(millisLocal, MILLIS_PER_DAY)));
            LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
            long millisEpoch = localDateTime.atZone(tz.toZoneId()).toInstant().toEpochMilli();
            guess = (int)(millisLocal - millisEpoch);
        }
        return guess;
    }

    public static LocalDate daysToLocalDate(int days) {
        return LocalDate.ofEpochDay(days);
    }

    public static Date toJavaDate(int daysSinceEpoch) {
        return new Date(DateTimeUtils.daysToMillis(daysSinceEpoch));
    }

    public static Instant microsToInstant(long us) {
        long secs = Math.floorDiv(us, MICROS_PER_SECOND);
        long mos = MathUtils.floorMod(us, MICROS_PER_SECOND, secs);
        return Instant.ofEpochSecond(secs, mos * NANOS_PER_MICROS);
    }

    public static Timestamp toJavaTimestamp(long us) {
        return Timestamp.from(DateTimeUtils.microsToInstant(us));
    }
}

