/*
 * Decompiled with CFR 0.152.
 */
package net.felinamods.itp.network;

import java.util.function.Supplier;
import net.felinamods.itp.ItpMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ItpModVariables {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ItpMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "itp_mapvars";
        public double teamBScore = 0.0;
        public String TeamBName = "\"\"";
        public double teamAScore = 0.0;
        public String TeamAName = "\"\"";
        public double pointsArea = 15.0;
        public Vec3 pointEPos = Vec3.f_82478_;
        public double pointEOwner = 0.0;
        public double pointECapture = 0.0;
        public Vec3 pointDPos = Vec3.f_82478_;
        public double pointDOwner = -1.0;
        public double pointDCapture = 0.0;
        public Vec3 pointCPos = Vec3.f_82478_;
        public double pointCOwner = -1.0;
        public double pointCCapture = 0.0;
        public Vec3 pointBPos = Vec3.f_82478_;
        public double pointBOwner = -1.0;
        public double pointBCapture = 0.0;
        public Vec3 pointAPos = Vec3.f_82478_;
        public double pointAOwner = -1.0;
        public double pointACapture = 0.0;
        public double numberOfPoints = 5.0;
        public double gameState = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.teamBScore = nbt.m_128459_("teamBScore");
            this.TeamBName = nbt.m_128461_("TeamBName");
            this.teamAScore = nbt.m_128459_("teamAScore");
            this.TeamAName = nbt.m_128461_("TeamAName");
            this.pointsArea = nbt.m_128459_("pointsArea");
            ListTag listTag = nbt.m_128437_("pointEPos", 6);
            this.pointEPos = new Vec3(listTag.m_128772_(0), listTag.m_128772_(1), listTag.m_128772_(2));
            this.pointEOwner = nbt.m_128459_("pointEOwner");
            this.pointECapture = nbt.m_128459_("pointECapture");
            listTag = nbt.m_128437_("pointDPos", 6);
            this.pointDPos = new Vec3(listTag.m_128772_(0), listTag.m_128772_(1), listTag.m_128772_(2));
            this.pointDOwner = nbt.m_128459_("pointDOwner");
            this.pointDCapture = nbt.m_128459_("pointDCapture");
            listTag = nbt.m_128437_("pointCPos", 6);
            this.pointCPos = new Vec3(listTag.m_128772_(0), listTag.m_128772_(1), listTag.m_128772_(2));
            this.pointCOwner = nbt.m_128459_("pointCOwner");
            this.pointCCapture = nbt.m_128459_("pointCCapture");
            listTag = nbt.m_128437_("pointBPos", 6);
            this.pointBPos = new Vec3(listTag.m_128772_(0), listTag.m_128772_(1), listTag.m_128772_(2));
            this.pointBOwner = nbt.m_128459_("pointBOwner");
            this.pointBCapture = nbt.m_128459_("pointBCapture");
            listTag = nbt.m_128437_("pointAPos", 6);
            this.pointAPos = new Vec3(listTag.m_128772_(0), listTag.m_128772_(1), listTag.m_128772_(2));
            this.pointAOwner = nbt.m_128459_("pointAOwner");
            this.pointACapture = nbt.m_128459_("pointACapture");
            this.numberOfPoints = nbt.m_128459_("numberOfPoints");
            this.gameState = nbt.m_128459_("gameState");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("teamBScore", this.teamBScore);
            nbt.m_128359_("TeamBName", this.TeamBName);
            nbt.m_128347_("teamAScore", this.teamAScore);
            nbt.m_128359_("TeamAName", this.TeamAName);
            nbt.m_128347_("pointsArea", this.pointsArea);
            this.pointEPos = this.pointEPos == null ? Vec3.f_82478_ : this.pointEPos;
            ListTag listTag = new ListTag();
            listTag.m_7614_(0, (Tag)DoubleTag.m_128500_((double)this.pointEPos.m_7096_()));
            listTag.m_7614_(1, (Tag)DoubleTag.m_128500_((double)this.pointEPos.m_7098_()));
            listTag.m_7614_(2, (Tag)DoubleTag.m_128500_((double)this.pointEPos.m_7094_()));
            nbt.m_128365_("pointEPos", (Tag)listTag);
            nbt.m_128347_("pointEOwner", this.pointEOwner);
            nbt.m_128347_("pointECapture", this.pointECapture);
            this.pointDPos = this.pointDPos == null ? Vec3.f_82478_ : this.pointDPos;
            listTag = new ListTag();
            listTag.m_7614_(0, (Tag)DoubleTag.m_128500_((double)this.pointDPos.m_7096_()));
            listTag.m_7614_(1, (Tag)DoubleTag.m_128500_((double)this.pointDPos.m_7098_()));
            listTag.m_7614_(2, (Tag)DoubleTag.m_128500_((double)this.pointDPos.m_7094_()));
            nbt.m_128365_("pointDPos", (Tag)listTag);
            nbt.m_128347_("pointDOwner", this.pointDOwner);
            nbt.m_128347_("pointDCapture", this.pointDCapture);
            this.pointCPos = this.pointCPos == null ? Vec3.f_82478_ : this.pointCPos;
            listTag = new ListTag();
            listTag.m_7614_(0, (Tag)DoubleTag.m_128500_((double)this.pointCPos.m_7096_()));
            listTag.m_7614_(1, (Tag)DoubleTag.m_128500_((double)this.pointCPos.m_7098_()));
            listTag.m_7614_(2, (Tag)DoubleTag.m_128500_((double)this.pointCPos.m_7094_()));
            nbt.m_128365_("pointCPos", (Tag)listTag);
            nbt.m_128347_("pointCOwner", this.pointCOwner);
            nbt.m_128347_("pointCCapture", this.pointCCapture);
            this.pointBPos = this.pointBPos == null ? Vec3.f_82478_ : this.pointBPos;
            listTag = new ListTag();
            listTag.m_7614_(0, (Tag)DoubleTag.m_128500_((double)this.pointBPos.m_7096_()));
            listTag.m_7614_(1, (Tag)DoubleTag.m_128500_((double)this.pointBPos.m_7098_()));
            listTag.m_7614_(2, (Tag)DoubleTag.m_128500_((double)this.pointBPos.m_7094_()));
            nbt.m_128365_("pointBPos", (Tag)listTag);
            nbt.m_128347_("pointBOwner", this.pointBOwner);
            nbt.m_128347_("pointBCapture", this.pointBCapture);
            this.pointAPos = this.pointAPos == null ? Vec3.f_82478_ : this.pointAPos;
            listTag = new ListTag();
            listTag.m_7614_(0, (Tag)DoubleTag.m_128500_((double)this.pointAPos.m_7096_()));
            listTag.m_7614_(1, (Tag)DoubleTag.m_128500_((double)this.pointAPos.m_7098_()));
            listTag.m_7614_(2, (Tag)DoubleTag.m_128500_((double)this.pointAPos.m_7094_()));
            nbt.m_128365_("pointAPos", (Tag)listTag);
            nbt.m_128347_("pointAOwner", this.pointAOwner);
            nbt.m_128347_("pointACapture", this.pointACapture);
            nbt.m_128347_("numberOfPoints", this.numberOfPoints);
            nbt.m_128347_("gameState", this.gameState);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                ItpMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "itp_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                ItpMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    ItpMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    ItpMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                ItpMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

