/*
 * Decompiled with CFR 0.152.
 */
package net.felinamods.itp.point;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.felinamods.itp.network.ItpModVariables;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TickingPoints {
    private static double CAP_RADIUS = 0.0;
    private static final double CAP_SPEED = 0.25;
    private static int scoreTick = 0;

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TickingPoints.execute((LevelAccessor)event.level);
        }
    }

    public static void execute(LevelAccessor world) {
        ItpModVariables.MapVariables map = ItpModVariables.MapVariables.get(world);
        if (CAP_RADIUS != map.pointsArea) {
            CAP_RADIUS = map.pointsArea;
        }
        if (map.gameState != 2.0) {
            return;
        }
        TickingPoints.processPoint(world, map.pointAPos, p -> {
            map.pointACapture = p;
        }, () -> map.pointACapture, o -> {
            map.pointAOwner = o;
        }, () -> map.pointAOwner);
        TickingPoints.processPoint(world, map.pointBPos, p -> {
            map.pointBCapture = p;
        }, () -> map.pointBCapture, o -> {
            map.pointBOwner = o;
        }, () -> map.pointBOwner);
        TickingPoints.processPoint(world, map.pointCPos, p -> {
            map.pointCCapture = p;
        }, () -> map.pointCCapture, o -> {
            map.pointCOwner = o;
        }, () -> map.pointCOwner);
        TickingPoints.processPoint(world, map.pointDPos, p -> {
            map.pointDCapture = p;
        }, () -> map.pointDCapture, o -> {
            map.pointDOwner = o;
        }, () -> map.pointDOwner);
        TickingPoints.processPoint(world, map.pointEPos, p -> {
            map.pointECapture = p;
        }, () -> map.pointECapture, o -> {
            map.pointEOwner = o;
        }, () -> map.pointEOwner);
        if (++scoreTick >= 120) {
            scoreTick = 0;
            if (map.pointAOwner == 0.0) {
                map.teamAScore += 1.0;
            }
            if (map.pointBOwner == 0.0) {
                map.teamAScore += 1.0;
            }
            if (map.pointCOwner == 0.0) {
                map.teamAScore += 1.0;
            }
            if (map.pointDOwner == 0.0) {
                map.teamAScore += 1.0;
            }
            if (map.pointEOwner == 0.0) {
                map.teamAScore += 1.0;
            }
            if (map.pointAOwner == 1.0) {
                map.teamBScore += 1.0;
            }
            if (map.pointBOwner == 1.0) {
                map.teamBScore += 1.0;
            }
            if (map.pointCOwner == 1.0) {
                map.teamBScore += 1.0;
            }
            if (map.pointDOwner == 1.0) {
                map.teamBScore += 1.0;
            }
            if (map.pointEOwner == 1.0) {
                map.teamBScore += 1.0;
            }
        }
        map.syncData(world);
    }

    private static void processPoint(LevelAccessor world, Vec3 pointPos, Consumer<Double> setCapture, Supplier<Double> getCapture, Consumer<Double> setOwner, Supplier<Double> getOwner) {
        List players = world.m_6907_().stream().filter(p -> p.m_20275_(pointPos.f_82479_, pointPos.f_82480_, pointPos.f_82481_) < CAP_RADIUS * CAP_RADIUS).collect(Collectors.toList());
        int teamA = 0;
        int teamB = 0;
        for (Player p2 : players) {
            int t = TickingPoints.getVanillaTeamIndex(p2);
            if (t == 0) {
                ++teamA;
            }
            if (t != 1) continue;
            ++teamB;
        }
        double progress = getCapture.get();
        double owner = getOwner.get();
        if (teamA == 0 && teamB == 0) {
            return;
        }
        if (teamA > 0 && teamB == 0) {
            if (owner == 1.0) {
                if ((progress -= 0.25) <= 0.0) {
                    owner = -1.0;
                    progress = 0.0;
                }
            } else if ((progress += 0.25) >= 100.0) {
                owner = 0.0;
                progress = 100.0;
            }
        } else if (teamB > 0 && teamA == 0) {
            if (owner == 0.0) {
                if ((progress -= 0.25) <= 0.0) {
                    owner = -1.0;
                    progress = 0.0;
                }
            } else if ((progress += 0.25) >= 100.0) {
                owner = 1.0;
                progress = 100.0;
            }
        }
        setCapture.accept(progress);
        setOwner.accept(owner);
    }

    private static int getVanillaTeamIndex(Player p) {
        if (p.m_5647_() == null) {
            return -1;
        }
        String t = p.m_5647_().m_5758_();
        if (t.equals("Blue_Team")) {
            return 0;
        }
        if (t.equals("Red_Team")) {
            return 1;
        }
        return -1;
    }
}

