/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.additionalentityattributes;

import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class Support {
    private static final double MIN_SCALE = 0.0625;
    private static final double MAX_SCALE = 16.0;

    public static float getExperienceMod(LivingEntity entity) {
        if (entity == null) {
            return 1.0f;
        }
        AttributeInstance attributeInstance = entity.getAttribute(AdditionalEntityAttributes.DROPPED_EXPERIENCE);
        if (attributeInstance == null) {
            return 1.0f;
        }
        return (float)attributeInstance.getValue();
    }

    public static double getHitboxWidth(LivingEntity entity, double original) {
        return Mth.clamp((double)(original * Support.getScaleAttributeModifierValue(entity, AdditionalEntityAttributes.WIDTH) * Support.getScaleAttributeModifierValue(entity, AdditionalEntityAttributes.HITBOX_SCALE) * Support.getScaleAttributeModifierValue(entity, AdditionalEntityAttributes.HITBOX_WIDTH)), (double)0.0625, (double)16.0);
    }

    public static double getModelWidth(LivingEntity entity, double original) {
        return Mth.clamp((double)(original * Support.getScaleAttributeModifierValue(entity, AdditionalEntityAttributes.WIDTH) * Support.getScaleAttributeModifierValue(entity, AdditionalEntityAttributes.MODEL_SCALE) * Support.getScaleAttributeModifierValue(entity, AdditionalEntityAttributes.MODEL_WIDTH)), (double)0.0625, (double)16.0);
    }

    public static double getHitboxHeight(LivingEntity entity, double original) {
        return Mth.clamp((double)(original * Support.getScaleAttributeModifierValue(entity, AdditionalEntityAttributes.HEIGHT) * Support.getScaleAttributeModifierValue(entity, AdditionalEntityAttributes.HITBOX_SCALE) * Support.getScaleAttributeModifierValue(entity, AdditionalEntityAttributes.HITBOX_HEIGHT)), (double)0.0625, (double)16.0);
    }

    public static double getModelHeight(LivingEntity entity, double original) {
        return Mth.clamp((double)(original * Support.getScaleAttributeModifierValue(entity, AdditionalEntityAttributes.HEIGHT) * Support.getScaleAttributeModifierValue(entity, AdditionalEntityAttributes.MODEL_SCALE) * Support.getScaleAttributeModifierValue(entity, AdditionalEntityAttributes.MODEL_HEIGHT)), (double)0.0625, (double)16.0);
    }

    public static double getScaleAttributeModifierValue(LivingEntity entity, Holder<Attribute> attribute) {
        double value = 1.0;
        if (entity == null) {
            return value;
        }
        AttributeInstance instance = entity.getAttribute(attribute);
        if (instance != null) {
            value = instance.getValue();
        }
        return Mth.clamp((double)value, (double)0.0625, (double)16.0);
    }

    public static double getMobDetectionValue(LivingEntity entity, double original) {
        if (entity == null) {
            return original;
        }
        AttributeInstance instance = entity.getAttribute(AdditionalEntityAttributes.MOB_DETECTION_RANGE);
        if (instance != null) {
            for (AttributeModifier modifier : instance.getModifiers()) {
                float amount = (float)modifier.amount();
                if (modifier.operation() == AttributeModifier.Operation.ADD_VALUE) {
                    original += (double)amount;
                    continue;
                }
                original *= (double)(amount + 1.0f);
            }
        }
        return original;
    }
}

