/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.additionalentityattributes.mixin.common;

import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ApplyBonusCount.class})
public abstract class ApplyBonusCountMixin {
    @Shadow
    @Final
    private ApplyBonusCount.Formula formula;
    @Shadow
    @Final
    private Holder<Enchantment> enchantment;

    @ModifyVariable(method={"run"}, at=@At(value="STORE"), ordinal=1)
    public int additionalEntityAttributes$applyBonusLoot(int original, ItemStack stack, LootContext context) {
        ItemStack itemStack = (ItemStack)context.getOptionalParameter(LootContextParams.TOOL);
        Entity entity = (Entity)context.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (itemStack != null && entity instanceof LivingEntity) {
            AttributeInstance attributeInstance;
            LivingEntity livingEntity = (LivingEntity)entity;
            int enchantmentLevel = EnchantmentHelper.getItemEnchantmentLevel(this.enchantment, (ItemStack)itemStack);
            if (enchantmentLevel > 0 && (attributeInstance = livingEntity.getAttribute(AdditionalEntityAttributes.BONUS_LOOT_COUNT_ROLLS)) != null) {
                int bonusRollCount = (int)attributeInstance.getValue();
                int highestRoll = original;
                for (int i = 0; i < bonusRollCount; ++i) {
                    int thisRoll = this.formula.calculateNewCount(context.getRandom(), stack.getCount(), enchantmentLevel);
                    highestRoll = Math.max(highestRoll, thisRoll);
                }
                return highestRoll;
            }
        }
        return original;
    }
}

