/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.additionalentityattributes.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import de.dafuqs.additionalentityattributes.Support;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class}, priority=500)
public abstract class LivingEntityScaleMixin {
    @Unique
    private boolean additionalEntityAttributes$hasInitializedDimensions = false;
    @Unique
    private double additionalEntityAttributes$previousHitboxWidth;
    @Unique
    private double additionalEntityAttributes$previousHitboxHeight;

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getScale()F")})
    private void additionalEntityAttributes$recalculateDimensions(CallbackInfo ci) {
        LivingEntity thisAsLiving = (LivingEntity)this;
        boolean updateScales = false;
        double hitboxWidth = Support.getHitboxWidth(thisAsLiving, 1.0);
        double hitboxHeight = Support.getHitboxHeight(thisAsLiving, 1.0);
        if (!this.additionalEntityAttributes$hasInitializedDimensions) {
            this.additionalEntityAttributes$previousHitboxWidth = hitboxWidth;
            this.additionalEntityAttributes$previousHitboxHeight = hitboxHeight;
            this.additionalEntityAttributes$hasInitializedDimensions = true;
            thisAsLiving.refreshDimensions();
            return;
        }
        if (hitboxWidth != this.additionalEntityAttributes$previousHitboxWidth) {
            this.additionalEntityAttributes$previousHitboxWidth = hitboxWidth;
            updateScales = true;
        }
        if (hitboxHeight != this.additionalEntityAttributes$previousHitboxHeight) {
            this.additionalEntityAttributes$previousHitboxHeight = hitboxHeight;
            updateScales = true;
        }
        if (updateScales) {
            thisAsLiving.refreshDimensions();
        }
    }

    @ModifyReturnValue(method={"getDimensions"}, at={@At(value="RETURN")})
    private EntityDimensions additionalEntityAttributes$modifyDimensions(EntityDimensions original) {
        return original.scale((float)Support.getHitboxWidth((LivingEntity)this, 1.0), (float)Support.getHitboxHeight((LivingEntity)this, 1.0));
    }

    @ModifyArg(method={"getPassengerRidingPosition"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getPassengerAttachmentPoint(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/EntityDimensions;F)Lnet/minecraft/world/phys/Vec3;"), index=2)
    private float additionalEntityAttributes$modifyPassengerRidingPos(float value) {
        return (float)Support.getHitboxHeight((LivingEntity)this, value);
    }
}

