/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.opac_mute_claim_warnings.fabric;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.swzo.opac_mute_claim_warnings.Opac_mute_claim_warnings;
import net.swzo.opac_mute_claim_warnings.config.ModConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Opac_mute_claim_warningsFabric
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"opac_mute_claim_warnings");
    private Path configFile;

    public void onInitialize() {
        Opac_mute_claim_warnings.init();
        this.configFile = FabricLoader.getInstance().getConfigDir().resolve("opac_mute_claim_warnings.properties");
        this.loadConfig();
    }

    private void loadConfig() {
        Properties properties = new Properties();
        try {
            if (this.configFile.toFile().exists()) {
                try (FileInputStream stream = new FileInputStream(this.configFile.toFile());){
                    properties.load(stream);
                }
            } else {
                properties.setProperty("showMessagesInActionBar", "false");
                this.saveConfig(properties);
            }
            ModConfig.showMessagesInActionBar = Boolean.parseBoolean(properties.getProperty("showMessagesInActionBar", "false"));
            LOGGER.info("Loaded OPAC Mute Warnings config. Action bar messages are {}.", (Object)(ModConfig.showMessagesInActionBar ? "ENABLED" : "DISABLED"));
        }
        catch (IOException e) {
            LOGGER.error("Failed to load OPAC Mute Warnings config.", (Throwable)e);
        }
    }

    private void saveConfig(Properties properties) {
        try (FileOutputStream stream = new FileOutputStream(this.configFile.toFile());){
            properties.store(stream, "OPAC Mute Claim Warnings Server Configuration");
        }
        catch (IOException e) {
            LOGGER.error("Failed to save OPAC Mute Warnings config.", (Throwable)e);
        }
    }
}

