/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.lib.mysql.cj;

import gg.drak.thebase.lib.mysql.cj.AbstractQuery;
import gg.drak.thebase.lib.mysql.cj.BindValue;
import gg.drak.thebase.lib.mysql.cj.Messages;
import gg.drak.thebase.lib.mysql.cj.NativeSession;
import gg.drak.thebase.lib.mysql.cj.PreparedQuery;
import gg.drak.thebase.lib.mysql.cj.QueryBindings;
import gg.drak.thebase.lib.mysql.cj.QueryInfo;
import gg.drak.thebase.lib.mysql.cj.conf.PropertyKey;
import gg.drak.thebase.lib.mysql.cj.conf.RuntimeProperty;
import gg.drak.thebase.lib.mysql.cj.exceptions.ExceptionFactory;
import gg.drak.thebase.lib.mysql.cj.exceptions.WrongArgumentException;
import gg.drak.thebase.lib.mysql.cj.protocol.Message;
import gg.drak.thebase.lib.mysql.cj.util.StringUtils;

public class ClientPreparedQuery
extends AbstractQuery
implements PreparedQuery {
    protected QueryInfo queryInfo;
    protected QueryBindings queryBindings = null;
    protected String originalSql = null;
    protected int parameterCount;
    protected int batchCommandIndex = -1;
    protected RuntimeProperty<Boolean> autoClosePStmtStreams = this.session.getPropertySet().getBooleanProperty(PropertyKey.autoClosePStmtStreams);
    protected RuntimeProperty<Boolean> useStreamLengthsInPrepStmts = this.session.getPropertySet().getBooleanProperty(PropertyKey.useStreamLengthsInPrepStmts);

    public ClientPreparedQuery(NativeSession sess) {
        super(sess);
    }

    @Override
    public void closeQuery() {
        super.closeQuery();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    @Override
    public void setQueryInfo(QueryInfo queryInfo) {
        this.queryInfo = queryInfo;
    }

    @Override
    public String getOriginalSql() {
        return this.originalSql;
    }

    @Override
    public void setOriginalSql(String originalSql) {
        this.originalSql = originalSql;
    }

    @Override
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public void setParameterCount(int parameterCount) {
        this.parameterCount = parameterCount;
    }

    @Override
    public QueryBindings getQueryBindings() {
        return this.queryBindings;
    }

    @Override
    public void setQueryBindings(QueryBindings queryBindings) {
        this.queryBindings = queryBindings;
    }

    @Override
    public int getBatchCommandIndex() {
        return this.batchCommandIndex;
    }

    @Override
    public void setBatchCommandIndex(int batchCommandIndex) {
        this.batchCommandIndex = batchCommandIndex;
    }

    @Override
    public int computeBatchSize(int numBatchedArgs) {
        long[] combinedValues = this.computeMaxParameterSetSizeAndBatchSize(numBatchedArgs);
        long maxSizeOfParameterSet = combinedValues[0];
        long sizeOfEntireBatch = combinedValues[1];
        if (sizeOfEntireBatch < (long)((Integer)this.maxAllowedPacket.getValue() - this.originalSql.length())) {
            return numBatchedArgs;
        }
        return (int)Math.max(1L, (long)((Integer)this.maxAllowedPacket.getValue() - this.originalSql.length()) / maxSizeOfParameterSet);
    }

    @Override
    public void checkNullOrEmptyQuery(String sql) {
        if (sql == null) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedQuery.0"), this.session.getExceptionInterceptor());
        }
        if (sql.length() == 0) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedQuery.1"), this.session.getExceptionInterceptor());
        }
    }

    @Override
    public String asSql() {
        StringBuilder buf = new StringBuilder();
        Object batchArg = null;
        if (this.batchCommandIndex != -1) {
            batchArg = this.batchedArgs.get(this.batchCommandIndex);
        }
        byte[][] staticSqlStrings = this.queryInfo.getStaticSqlParts();
        for (int i2 = 0; i2 < this.parameterCount; ++i2) {
            buf.append(this.charEncoding != null ? StringUtils.toString(staticSqlStrings[i2], this.charEncoding) : StringUtils.toString(staticSqlStrings[i2]));
            String val = null;
            if (batchArg != null && batchArg instanceof String) {
                buf.append((String)batchArg);
                continue;
            }
            val = this.batchCommandIndex == -1 ? (this.queryBindings == null ? null : this.queryBindings.getBindValues()[i2].getString()) : ((QueryBindings)batchArg).getBindValues()[i2].getString();
            buf.append(val == null ? "** NOT SPECIFIED **" : val);
        }
        buf.append(this.charEncoding != null ? StringUtils.toString(staticSqlStrings[this.parameterCount], this.charEncoding) : StringUtils.toAsciiString(staticSqlStrings[this.parameterCount]));
        return buf.toString();
    }

    protected long[] computeMaxParameterSetSizeAndBatchSize(int numBatchedArgs) {
        int i2;
        long sizeOfEntireBatch = 1L;
        long maxSizeOfParameterSet = 0L;
        if (this.session.getServerSession().supportsQueryAttributes()) {
            sizeOfEntireBatch += 10L;
            sizeOfEntireBatch += (long)((this.queryAttributesBindings.getCount() + 7) / 8 + 1);
            for (i2 = 0; i2 < this.queryAttributesBindings.getCount(); ++i2) {
                BindValue queryAttribute = this.queryAttributesBindings.getAttributeValue(i2);
                sizeOfEntireBatch += (long)(2 + queryAttribute.getName().length()) + queryAttribute.getBinaryLength();
            }
        }
        for (i2 = 0; i2 < numBatchedArgs; ++i2) {
            long sizeOfParameterSet = 0L;
            BindValue[] bindValues = ((QueryBindings)this.batchedArgs.get(i2)).getBindValues();
            for (int j = 0; j < bindValues.length; ++j) {
                sizeOfParameterSet += bindValues[j].getTextLength();
            }
            sizeOfEntireBatch += (sizeOfParameterSet += this.queryInfo.getValuesClauseLength() != -1 ? (long)(this.queryInfo.getValuesClauseLength() + 1) : (long)(this.originalSql.length() + 1));
            if (sizeOfParameterSet <= maxSizeOfParameterSet) continue;
            maxSizeOfParameterSet = sizeOfParameterSet;
        }
        return new long[]{maxSizeOfParameterSet, sizeOfEntireBatch};
    }

    @Override
    public <M extends Message> M fillSendPacket(QueryBindings bindings) {
        return (M)this.session.getProtocol().getMessageBuilder().buildComQuery(this.session.getSharedSendPacket(), this.session, this, bindings, this.charEncoding);
    }
}

