/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.numbers;

import java.util.Date;
import java.util.Random;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class WeightedInteger
extends Number
implements Comparable<WeightedInteger> {
    private Random RNG;
    private WeightedInteger min;
    private WeightedInteger max;
    private Date separator;
    private int absoluteMin;
    private int absoluteMax;

    public WeightedInteger(int min2, int max, Random RNG) {
        this.setSeparator(new Date());
        this.setAbsoluteMin(min2);
        this.setAbsoluteMax(max);
        this.setRNG(RNG);
    }

    public WeightedInteger(int min2, int max, long seed) {
        this(min2, max, new Random(seed));
    }

    public WeightedInteger(int min2, int max) {
        this(min2, max, new Random());
    }

    public WeightedInteger(WeightedInteger min2, WeightedInteger max, Random RNG) {
        this.setSeparator(new Date());
        this.setMin(min2);
        this.setMax(max);
        this.setRNG(RNG);
    }

    public WeightedInteger(WeightedInteger min2, WeightedInteger max, long seed) {
        this(min2, max, new Random(seed));
    }

    public WeightedInteger(WeightedInteger min2, WeightedInteger max) {
        this(min2, max, new Random());
    }

    public WeightedInteger(int min2, WeightedInteger max, Random RNG) {
        this.setSeparator(new Date());
        this.setAbsoluteMin(min2);
        this.setMax(max);
        this.setRNG(RNG);
    }

    public WeightedInteger(int min2, WeightedInteger max, long seed) {
        this(min2, max, new Random(seed));
    }

    public WeightedInteger(int min2, WeightedInteger max) {
        this(min2, max, new Random());
    }

    public WeightedInteger(WeightedInteger min2, int max, Random RNG) {
        this.setSeparator(new Date());
        this.setMin(min2);
        this.setAbsoluteMax(max);
        this.setRNG(RNG);
    }

    public WeightedInteger(WeightedInteger min2, int max, long seed) {
        this(min2, max, new Random(seed));
    }

    public WeightedInteger(WeightedInteger min2, int max) {
        this(min2, max, new Random());
    }

    public int roll() {
        if (this.getMin() != null) {
            this.setAbsoluteMin(this.getMin().roll());
        }
        if (this.getMax() != null) {
            this.setAbsoluteMax(this.getMax().roll());
        }
        if (this.getAbsoluteMin() >= this.getAbsoluteMax()) {
            return this.getAbsoluteMin();
        }
        return this.getRNG().nextInt(this.getAbsoluteMax() + 1 - this.getAbsoluteMin()) + this.getAbsoluteMin();
    }

    @Override
    public int compareTo(@NotNull WeightedInteger o) {
        return Long.compare(this.getSeparator().getTime(), o.getSeparator().getTime());
    }

    @Override
    public int intValue() {
        return this.roll();
    }

    @Override
    public long longValue() {
        return this.roll();
    }

    @Override
    public float floatValue() {
        return this.roll();
    }

    @Override
    public double doubleValue() {
        return this.roll();
    }

    @Generated
    public void setRNG(Random RNG) {
        this.RNG = RNG;
    }

    @Generated
    public void setMin(WeightedInteger min2) {
        this.min = min2;
    }

    @Generated
    public void setMax(WeightedInteger max) {
        this.max = max;
    }

    @Generated
    public void setSeparator(Date separator) {
        this.separator = separator;
    }

    @Generated
    public void setAbsoluteMin(int absoluteMin) {
        this.absoluteMin = absoluteMin;
    }

    @Generated
    public void setAbsoluteMax(int absoluteMax) {
        this.absoluteMax = absoluteMax;
    }

    @Generated
    public Random getRNG() {
        return this.RNG;
    }

    @Generated
    public WeightedInteger getMin() {
        return this.min;
    }

    @Generated
    public WeightedInteger getMax() {
        return this.max;
    }

    @Generated
    public Date getSeparator() {
        return this.separator;
    }

    @Generated
    public int getAbsoluteMin() {
        return this.absoluteMin;
    }

    @Generated
    public int getAbsoluteMax() {
        return this.absoluteMax;
    }
}

