/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.commands;

import gg.drak.thebase.objects.Identifiable;
import gg.drak.thebase.utils.StringUtils;
import host.plas.bou.BetterPlugin;
import host.plas.bou.BukkitOfUtils;
import host.plas.bou.commands.BuildableCommand;
import host.plas.bou.commands.CommandContext;
import host.plas.bou.commands.CommandHandler;
import host.plas.bou.utils.SenderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Consumer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BetterCommand
extends TabExecutor,
Identifiable {
    public String getCommandName();

    public void setCommandName(String var1);

    public String getLabel();

    public boolean setLabel(String var1);

    public String getDescription();

    public Command setDescription(String var1);

    public String getUsage();

    public Command setUsage(String var1);

    public String getBasePermission();

    public void setBasePermission(String var1);

    public List<String> getAliases();

    public Command setAliases(List<String> var1);

    default public ConcurrentSkipListSet<String> getConcurrentAliases() {
        return new ConcurrentSkipListSet<String>(this.getAliases());
    }

    default public Command setAliases(ConcurrentSkipListSet<String> aliases) {
        return this.setAliases(new ArrayList<String>(aliases));
    }

    default public String[] getSelfAliasesArray() {
        return this.getConcurrentAliases().toArray(new String[0]);
    }

    default public void setAliases(String ... aliases) {
        this.setAliases(Arrays.asList(aliases));
    }

    default public void addSelfAliases(String ... aliases) {
        ConcurrentSkipListSet<String> current = this.getConcurrentAliases();
        if (current == null) {
            current = new ConcurrentSkipListSet();
        }
        current.addAll(Arrays.asList(aliases));
        this.setAliases(current);
    }

    default public void removeSelfAliases(String ... aliases) {
        ConcurrentSkipListSet<String> current = this.getConcurrentAliases();
        if (current == null) {
            current = new ConcurrentSkipListSet();
        }
        Arrays.asList(aliases).forEach(current::remove);
        this.setAliases(current);
    }

    public JavaPlugin getProvider();

    public void setProvider(JavaPlugin var1);

    public boolean isRegistered();

    public void setRegistered(boolean var1);

    default public BetterPlugin getPlugin() {
        try {
            return (BetterPlugin)this.getProvider();
        }
        catch (Exception e) {
            return null;
        }
    }

    default public Optional<BetterPlugin> getPluginOptional() {
        return Optional.ofNullable(this.getPlugin());
    }

    default public boolean isBOUPlugin() {
        return this.getPluginOptional().isPresent();
    }

    default public void executeWithPlugin(Consumer<BetterPlugin> consumer) {
        this.getPluginOptional().ifPresent(consumer);
    }

    default public void unregister() {
        if (this.isBuildable()) {
            this.unregisterBuildable();
            return;
        }
        CommandHandler.unregisterCommands(this.getCommandName());
    }

    default public void unregisterBuildable() {
        if (this.isBuildable() && !(this instanceof BuildableCommand)) {
            BukkitOfUtils.getInstance().logWarning("Command '" + this.getIdentifier() + "' is marked as buildable, but does not extend BuildableCommand! This may cause issues.");
            return;
        }
        BuildableCommand bc = (BuildableCommand)this;
        CommandHandler.unregisterCommands(bc.getName());
    }

    default public void registerBuildable() {
        if (this.isBuildable() && !(this instanceof BuildableCommand)) {
            BukkitOfUtils.getInstance().logWarning("Command '" + this.getIdentifier() + "' is marked as buildable, but does not extend BuildableCommand! This may cause issues.");
            return;
        }
        BuildableCommand bc = (BuildableCommand)this;
        CommandHandler.registerCommands((BuildableCommand[])new BuildableCommand[]{bc});
    }

    default public boolean registerWithBukkit() {
        try {
            if (this.isBuildable()) {
                this.registerBuildable();
                return true;
            }
            Objects.requireNonNull(this.getProvider().getCommand(this.getIdentifier())).setExecutor((CommandExecutor)this);
            return true;
        }
        catch (Exception e) {
            BukkitOfUtils.getInstance().logWarning("Failed to register command '" + this.getIdentifier() + "'! --> No command found in plugin.yml!");
            return false;
        }
    }

    default public void registerWithBOU() {
        CommandHandler.registerCommand(this);
    }

    default public void unregisterWithBOU() {
        CommandHandler.unregisterCommand(this);
    }

    default public void unregisterAndSet() {
        if (this.isRegistered()) {
            this.unregisterWithBOU();
            this.unregister();
            this.setRegistered(false);
        }
    }

    @Deprecated
    default public boolean register() {
        return true;
    }

    default public void registerAndSet() {
        if (this.registerWithBukkit()) {
            this.registerWithBOU();
            this.setRegistered(true);
        }
    }

    @Deprecated(since="BOU 1.16.0. Use useCommandContext instead!", forRemoval=true)
    default public boolean useNewCommandContext() {
        return true;
    }

    default public boolean useCommandContext() {
        return this.useNewCommandContext();
    }

    default public boolean isBuildable() {
        return false;
    }

    default public boolean alwaysProcessTabCompletes() {
        return true;
    }

    default public boolean isPermissionValid() {
        return this.getBasePermission() != null && !this.getBasePermission().isBlank() && !this.getBasePermission().equalsIgnoreCase("--NULL--");
    }

    default public boolean hasPermission(CommandSender sender) {
        if (!this.isPermissionValid()) {
            return this.defaultPermissionFallback();
        }
        return sender.hasPermission(this.getBasePermission());
    }

    default public boolean defaultPermissionFallback() {
        return true;
    }

    default public boolean success() {
        return true;
    }

    default public boolean failure() {
        return false;
    }

    default public boolean error() {
        return false;
    }

    default public boolean defaultNoPermission() {
        return this.failure();
    }

    default public boolean handleNoPermission(CommandSender sender) {
        SenderUtils.getSender(sender).sendMessage("&cYou do not have permission to execute this command.");
        return this.defaultNoPermission();
    }

    default public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (!(this instanceof Command)) {
            return false;
        }
        Command cmd = (Command)this;
        return this.onCommand(sender, cmd, label, args);
    }

    default public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.hasPermission(sender)) {
            return this.handleNoPermission(sender);
        }
        if (this.useNewCommandContext()) {
            return this.command(new CommandContext(sender, command, label, args));
        }
        return this.command(sender, command, label, args);
    }

    default public boolean command(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return this.command(new CommandContext(sender, command, label, args));
    }

    public boolean command(CommandContext var1);

    @Nullable
    default public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String lastArg;
        List<String> list = this.useNewCommandContext() ? new ArrayList<String>(this.tabComplete(new CommandContext(sender, command, label, args))) : new ArrayList<String>(this.tabComplete(sender, command, label, args));
        if (list.isEmpty()) {
            return new ArrayList<String>();
        }
        try {
            lastArg = args[args.length - 1];
        }
        catch (Exception e) {
            lastArg = "";
        }
        if (this.alwaysProcessTabCompletes()) {
            list = StringUtils.getAsCompletionList(lastArg, list);
        }
        return list;
    }

    public ConcurrentSkipListSet<String> tabComplete(CommandContext var1);

    default public ConcurrentSkipListSet<String> tabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return this.tabComplete(new CommandContext(sender, command, label, args));
    }
}

