/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.commands;

import host.plas.bou.commands.BetterCommand;
import host.plas.bou.commands.CommandBuilder;
import host.plas.bou.commands.CommandContext;
import host.plas.bou.commands.CommandExecution;
import host.plas.bou.commands.CommandHandler;
import host.plas.bou.commands.CommandTabCompleter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentSkipListSet;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BuildableCommand
extends BukkitCommand
implements BetterCommand {
    private String identifier;
    private String commandName;
    private JavaPlugin provider;
    private boolean registered;
    private CommandExecution executionHandler;
    private CommandTabCompleter tabCompleter;
    private String basePermission;

    public BuildableCommand(String commandName, String label, JavaPlugin provider, CommandExecution executionHandler, CommandTabCompleter tabCompleter, String basePermission, String description, String usage, ConcurrentSkipListSet<String> aliases) {
        super(commandName, description, usage, new ArrayList<String>(aliases));
        this.identifier = CommandHandler.getIdentifier(commandName, provider);
        this.commandName = commandName;
        this.provider = provider;
        this.executionHandler = executionHandler;
        this.tabCompleter = tabCompleter;
        this.basePermission = basePermission;
        this.setLabel(label);
        this.registerAndSet();
    }

    public BuildableCommand(String commandName, String label, JavaPlugin provider, CommandExecution executionHandler, CommandTabCompleter tabCompleter, String basePermission, String description, String usage, String ... aliases) {
        this(commandName, label, provider, executionHandler, tabCompleter, basePermission, description, usage, new ConcurrentSkipListSet<String>(Arrays.asList(aliases)));
    }

    public BuildableCommand(String commandName, JavaPlugin provider, CommandExecution executionHandler, CommandTabCompleter tabCompleter, String basePermission, String description, String usage, String ... aliases) {
        this(commandName, provider.getName().toLowerCase(), provider, executionHandler, tabCompleter, basePermission, description, usage, aliases);
    }

    public BuildableCommand(String commandName, String label, JavaPlugin provider, CommandExecution executionHandler, CommandTabCompleter tabCompleter, String basePermission, String description, String usage) {
        this(commandName, label, provider, executionHandler, tabCompleter, basePermission, description, usage, new ConcurrentSkipListSet<String>());
    }

    public BuildableCommand(String commandName, JavaPlugin provider, CommandExecution executionHandler, CommandTabCompleter tabCompleter, String basePermission, String description, String usage) {
        this(commandName, provider.getName().toLowerCase(), provider, executionHandler, tabCompleter, basePermission, description, usage);
    }

    public BuildableCommand(String commandName, String label, JavaPlugin provider, CommandExecution executionHandler, CommandTabCompleter tabCompleter, String basePermission, String description) {
        this(commandName, label, provider, executionHandler, tabCompleter, basePermission, description, "Not defined.");
    }

    public BuildableCommand(String commandName, JavaPlugin provider, CommandExecution executionHandler, CommandTabCompleter tabCompleter, String basePermission, String description) {
        this(commandName, provider.getName().toLowerCase(), provider, executionHandler, tabCompleter, basePermission, description);
    }

    public BuildableCommand(String commandName, String label, JavaPlugin provider, CommandExecution executionHandler, CommandTabCompleter tabCompleter, String basePermission) {
        this(commandName, label, provider, executionHandler, tabCompleter, basePermission, "Not defined.");
    }

    public BuildableCommand(String commandName, JavaPlugin provider, CommandExecution executionHandler, CommandTabCompleter tabCompleter, String basePermission) {
        this(commandName, provider.getName().toLowerCase(), provider, executionHandler, tabCompleter, basePermission);
    }

    public BuildableCommand(String commandName, String label, JavaPlugin provider, CommandExecution executionHandler, String basePermission) {
        this(commandName, label, provider, executionHandler, CommandTabCompleter.empty(), basePermission);
    }

    public BuildableCommand(String commandName, JavaPlugin provider, CommandExecution executionHandler, String basePermission) {
        this(commandName, provider.getName().toLowerCase(), provider, executionHandler, CommandTabCompleter.empty(), basePermission);
    }

    public BuildableCommand(String commandName, String label, JavaPlugin provider, boolean bool, CommandTabCompleter tabCompleter, String basePermission) {
        this(commandName, label, provider, bool ? CommandExecution.emptyTrue() : CommandExecution.emptyFalse(), tabCompleter, basePermission);
    }

    public BuildableCommand(String commandName, JavaPlugin provider, boolean bool, CommandTabCompleter tabCompleter, String basePermission) {
        this(commandName, provider.getName().toLowerCase(), provider, bool ? CommandExecution.emptyTrue() : CommandExecution.emptyFalse(), tabCompleter, basePermission);
    }

    public BuildableCommand(String commandName, String label, JavaPlugin provider, CommandTabCompleter tabCompleter, String basePermission) {
        this(commandName, label, provider, true, tabCompleter, basePermission);
    }

    public BuildableCommand(String commandName, JavaPlugin provider, CommandTabCompleter tabCompleter, String basePermission) {
        this(commandName, provider.getName().toLowerCase(), provider, true, tabCompleter, basePermission);
    }

    public BuildableCommand(String commandName, String label, JavaPlugin provider, String basePermission) {
        this(commandName, label, provider, true, CommandTabCompleter.empty(), basePermission);
    }

    public BuildableCommand(String commandName, JavaPlugin provider, String basePermission) {
        this(commandName, provider.getName().toLowerCase(), provider, true, CommandTabCompleter.empty(), basePermission);
    }

    public BuildableCommand(String commandName, JavaPlugin provider) {
        this(commandName, provider, "--NULL--");
    }

    public BuildableCommand(CommandBuilder builder) {
        this(builder.getCommandName(), builder.getLabel(), builder.getProvider(), builder.getExecutionHandler(), builder.getTabCompleter(), builder.getBasePermission(), builder.getDescription(), builder.getUsage(), builder.getAliases());
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        return BetterCommand.super.execute(sender, label, args);
    }

    @Override
    public boolean command(CommandContext ctx) {
        return (Boolean)this.executionHandler.apply(ctx);
    }

    @Override
    public ConcurrentSkipListSet<String> tabComplete(CommandContext ctx) {
        return (ConcurrentSkipListSet)this.tabCompleter.apply(ctx);
    }

    @Override
    public boolean isBuildable() {
        return true;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public JavaPlugin getProvider() {
        return this.provider;
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    public CommandExecution getExecutionHandler() {
        return this.executionHandler;
    }

    public CommandTabCompleter getTabCompleter() {
        return this.tabCompleter;
    }

    @Override
    public String getBasePermission() {
        return this.basePermission;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    @Override
    public void setProvider(JavaPlugin provider) {
        this.provider = provider;
    }

    @Override
    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public void setExecutionHandler(CommandExecution executionHandler) {
        this.executionHandler = executionHandler;
    }

    public void setTabCompleter(CommandTabCompleter tabCompleter) {
        this.tabCompleter = tabCompleter;
    }

    @Override
    public void setBasePermission(String basePermission) {
        this.basePermission = basePermission;
    }
}

