/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.commands;

import host.plas.bou.commands.CommandArgument;
import host.plas.bou.commands.Sender;
import host.plas.bou.utils.obj.ContextedString;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandContext
extends ContextedString<CommandArgument> {
    public static final Supplier<CommandArgument> ARGUMENT_CREATOR = CommandArgument::new;
    public static final BiFunction<Integer, String[], CommandArgument> ARGUMENT_CREATOR_INDEXED = (i2, args) -> new CommandArgument((int)i2, args[i2]);
    private Command command;
    private String label;
    private Sender sender;
    private CommandSender commandSender;

    public CommandContext(CommandSender sender, Command command, String label, String ... args) {
        super(ARGUMENT_CREATOR, ARGUMENT_CREATOR_INDEXED, args);
        this.command = command;
        this.label = label;
        this.sender = new Sender(sender);
        this.commandSender = sender;
    }

    public Optional<Player> getPlayer() {
        if (this.isPlayer()) {
            return Optional.of((Player)this.commandSender);
        }
        return Optional.empty();
    }

    public boolean isConsole() {
        return this.sender.isConsole();
    }

    public boolean isPlayer() {
        return !this.isConsole();
    }

    public boolean sendMessage(String message, boolean format) {
        return this.sender.sendMessage(message, format);
    }

    public boolean sendMessage(String message) {
        return this.sender.sendMessage(message);
    }

    public boolean sendMessage(BaseComponent ... messages) {
        return this.sender.sendMessage(messages);
    }

    public boolean sendMessage(String alternate, BaseComponent ... messages) {
        return this.sender.sendMessage(alternate, messages);
    }

    public boolean sendMessage(ComponentBuilder builder) {
        return this.sender.sendMessage(builder);
    }

    public boolean sendMessage(String alternate, ComponentBuilder builder) {
        return this.sender.sendMessage(alternate, builder);
    }

    public boolean sendTitle(String toParse) {
        return this.sender.sendTitle(toParse);
    }

    public boolean sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        return this.sender.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }

    public Player getPlayerOrNull() {
        return this.getPlayer().orElse(null);
    }

    public String getFullCommand() {
        return this.command.getName() + " " + this.getArgsAsString();
    }

    public String getArgsAsString() {
        return String.join((CharSequence)" ", this.getArgsAsStringArray());
    }

    public String[] getArgsAsStringArray() {
        String[] args = new String[this.getArgs().size()];
        for (int i2 = 0; i2 < this.getArgs().size(); ++i2) {
            args[i2] = ((CommandArgument)this.getArg(i2)).getContent();
        }
        return args;
    }

    public static ConcurrentSkipListSet<CommandArgument> getArgsFrom(String ... args) {
        return ContextedString.getArgsFrom(ARGUMENT_CREATOR_INDEXED, args);
    }

    public static ConcurrentSkipListSet<CommandArgument> getArgsFrom(String string, String separator) {
        return ContextedString.getArgsFrom(ARGUMENT_CREATOR_INDEXED, string, separator);
    }

    public Command getCommand() {
        return this.command;
    }

    public String getLabel() {
        return this.label;
    }

    public Sender getSender() {
        return this.sender;
    }

    public CommandSender getCommandSender() {
        return this.commandSender;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setSender(Sender sender) {
        this.sender = sender;
    }

    public void setCommandSender(CommandSender commandSender) {
        this.commandSender = commandSender;
    }
}

