/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.commands;

import host.plas.bou.BukkitOfUtils;
import host.plas.bou.commands.BetterCommand;
import host.plas.bou.commands.BuildableCommand;
import host.plas.bou.utils.VersionTool;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandHandler {
    private static ConcurrentSkipListSet<BetterCommand> loadedCommands = new ConcurrentSkipListSet();
    private static CommandMap COMMAND_MAP = null;

    private static void setupCommandMap() {
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            COMMAND_MAP = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static CommandMap getCommandMap() {
        if (COMMAND_MAP == null) {
            CommandHandler.setupCommandMap();
        }
        return COMMAND_MAP;
    }

    public static void init() {
        CommandHandler.getCommandMap();
    }

    public static boolean registerCommand(BetterCommand command) {
        if (CommandHandler.isCommandRegistered(command.getIdentifier())) {
            CommandHandler.unregisterCommand(command);
        }
        return CommandHandler.getLoadedCommands().add(command);
    }

    public static boolean unregisterCommand(BetterCommand command) {
        if (!CommandHandler.isCommandRegistered(command.getIdentifier())) {
            return false;
        }
        return CommandHandler.getLoadedCommands().removeIf(loadedCommand -> loadedCommand.getIdentifier().equalsIgnoreCase(command.getIdentifier()));
    }

    public static Optional<BetterCommand> getCommand(String identifier) {
        return CommandHandler.getLoadedCommands().stream().filter(command -> command.getIdentifier().equalsIgnoreCase(identifier)).findFirst();
    }

    public static Optional<BetterCommand> getCommand(String commandName, JavaPlugin provider) {
        return CommandHandler.getCommand(CommandHandler.getIdentifier(commandName, provider));
    }

    public static boolean isCommandRegistered(String identifier) {
        return CommandHandler.getCommand(identifier).isPresent();
    }

    public static boolean isCommandRegistered(String commandName, JavaPlugin provider) {
        return CommandHandler.getCommand(commandName, provider).isPresent();
    }

    public static String getIdentifier(String commandName, JavaPlugin provider) {
        return provider.getName() + ":" + commandName;
    }

    public static <C extends BuildableCommand> void registerCommands(C ... commands) {
        try {
            for (C command : commands) {
                try {
                    CommandHandler.getCommandMap().register(((BuildableCommand)command).getCommandName(), command.getLabel(), command);
                }
                catch (Throwable e) {
                    BukkitOfUtils.getInstance().logDebugWithInfo("Failed to register command: " + command.getLabel(), e);
                }
            }
            CompletableFuture.runAsync(CommandHandler::syncCommands);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void unregisterCommands(String ... commands) {
        try {
            for (String command : commands) {
                Command com = CommandHandler.getCommandMap().getCommand(command);
                if (com == null) {
                    BukkitOfUtils.getInstance().logDebug("Tried to unregister a command that does not exist: " + command);
                    continue;
                }
                try {
                    com.unregister(CommandHandler.getCommandMap());
                }
                catch (Throwable e) {
                    BukkitOfUtils.getInstance().logDebugWithInfo("Failed to unregister command: " + command, e);
                }
                try {
                    VersionTool.unregisterKnownCommand(com);
                }
                catch (Throwable e) {
                    BukkitOfUtils.getInstance().logDebugWithInfo("Failed to unregister command: " + command, e);
                }
            }
            CompletableFuture.runAsync(CommandHandler::syncCommands);
        }
        catch (Exception e) {
            BukkitOfUtils.getInstance().logWarningWithInfo("Failed to unregister commands: ", e);
        }
    }

    public static void syncCommands() {
        try {
            VersionTool.syncCommands();
        }
        catch (Exception e) {
            BukkitOfUtils.getInstance().logDebugWithInfo("An unknown error occurred while syncing commands: ", e);
        }
    }

    public static ConcurrentSkipListSet<BetterCommand> getLoadedCommands() {
        return loadedCommands;
    }

    public static void setLoadedCommands(ConcurrentSkipListSet<BetterCommand> loadedCommands) {
        CommandHandler.loadedCommands = loadedCommands;
    }
}

