/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.commands;

import host.plas.bou.commands.BetterCommand;
import host.plas.bou.commands.CommandExecution;
import host.plas.bou.commands.CommandHandler;
import host.plas.bou.commands.CommandTabCompleter;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class ComplexCommand
extends BukkitCommand
implements BetterCommand {
    private String identifier;
    private String commandName;
    private JavaPlugin provider;
    private boolean registered;
    private CommandExecution executionHandler;
    private CommandTabCompleter tabCompleter;
    private String basePermission;

    public ComplexCommand(String commandName, String label, JavaPlugin provider, String basePermission) {
        super(commandName);
        this.identifier = CommandHandler.getIdentifier(commandName, provider);
        this.commandName = commandName;
        this.setLabel(label);
        this.provider = provider;
        this.executionHandler = CommandExecution.emptyFalse();
        this.tabCompleter = CommandTabCompleter.empty();
        this.basePermission = basePermission;
        this.registerAndSet();
    }

    public ComplexCommand(String commandName, JavaPlugin provider, String basePermission) {
        this(commandName, provider.getName().toLowerCase(), provider, basePermission);
    }

    public ComplexCommand(String commandName, String label, JavaPlugin provider) {
        this(commandName, label, provider, "--NULL--");
    }

    public ComplexCommand(String commandName, JavaPlugin provider) {
        this(commandName, provider, "--NULL--");
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        return BetterCommand.super.execute(sender, label, args);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public JavaPlugin getProvider() {
        return this.provider;
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    public CommandExecution getExecutionHandler() {
        return this.executionHandler;
    }

    public CommandTabCompleter getTabCompleter() {
        return this.tabCompleter;
    }

    @Override
    public String getBasePermission() {
        return this.basePermission;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    @Override
    public void setProvider(JavaPlugin provider) {
        this.provider = provider;
    }

    @Override
    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public void setExecutionHandler(CommandExecution executionHandler) {
        this.executionHandler = executionHandler;
    }

    public void setTabCompleter(CommandTabCompleter tabCompleter) {
        this.tabCompleter = tabCompleter;
    }

    @Override
    public void setBasePermission(String basePermission) {
        this.basePermission = basePermission;
    }
}

