/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.commands;

import gg.drak.thebase.objects.AtomicString;
import host.plas.bou.BukkitOfUtils;
import host.plas.bou.instances.BaseManager;
import host.plas.bou.utils.ColorUtils;
import host.plas.bou.utils.SenderUtils;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class Sender {
    private String uuid;
    private String name;
    private CommandSender commandSender;

    public Sender(String uuid, String name, CommandSender sender) {
        this.uuid = uuid;
        this.name = name;
        this.commandSender = sender;
    }

    public Sender(String name, CommandSender sender, boolean isConsole) {
        this(SenderUtils.formatUuid(name, isConsole), SenderUtils.formatName(name, isConsole), sender);
    }

    public Sender(CommandSender sender) {
        this(sender.getName(), sender, Bukkit.getConsoleSender().equals(sender));
    }

    public boolean isConsole() {
        return Bukkit.getConsoleSender().equals(this.commandSender) || this.uuid.equals(BaseManager.getBaseConfig().getConsoleUUID());
    }

    public boolean isPlayer() {
        return !this.isConsole();
    }

    public boolean sendMessage(String message, boolean format) {
        AtomicBoolean success = new AtomicBoolean(false);
        AtomicString finalMessage = new AtomicString(message);
        if (format) {
            finalMessage.set(ColorUtils.colorizeHard(message));
        }
        this.getCommandSender().ifPresent(sender -> {
            sender.sendMessage((String)finalMessage.get());
            success.set(true);
        });
        return success.get();
    }

    public boolean sendMessage(String message) {
        return this.sendMessage(message, true);
    }

    public boolean sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        AtomicBoolean success = new AtomicBoolean(false);
        this.getCommandSender().ifPresent(sender -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                player.sendTitle(ColorUtils.colorizeHard(title), ColorUtils.colorizeHard(subtitle), fadeIn, stay, fadeOut);
                success.set(true);
            }
        });
        return success.get();
    }

    public boolean sendTitle(String string) {
        int fadeIn = 10;
        int stay = 70;
        int fadeOut = 20;
        ConcurrentSkipListSet<Integer> remove = new ConcurrentSkipListSet<Integer>();
        String[] split = string.split(" ");
        int i2 = 0;
        for (String s2 : split) {
            if (s2.startsWith("-fadeIn=")) {
                try {
                    fadeIn = Integer.parseInt(s2.replace("-fadeIn=", ""));
                    remove.add(i2);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            } else if (s2.startsWith("-stay=")) {
                try {
                    stay = Integer.parseInt(s2.replace("-stay=", ""));
                    remove.add(i2);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            } else if (s2.startsWith("-fadeOut=")) {
                try {
                    fadeOut = Integer.parseInt(s2.replace("-fadeOut=", ""));
                    remove.add(i2);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            ++i2;
        }
        StringBuilder title = new StringBuilder();
        int n = 0;
        for (String s3 : split) {
            if (!remove.contains(n)) {
                title.append(s3).append(" ");
            }
            ++n;
        }
        String t2 = title.toString().trim();
        String[] splitTitle = t2.split("\\\\n", 2);
        String titleString = splitTitle[0];
        String subtitleString = splitTitle.length > 1 ? splitTitle[1] : "";
        return this.sendTitle(titleString, subtitleString, fadeIn, stay, fadeOut);
    }

    public Optional<OfflinePlayer> getOfflinePlayer() {
        return SenderUtils.getOfflinePlayer(this.uuid);
    }

    public Optional<Player> getPlayer() {
        return this.getOfflinePlayer().map(OfflinePlayer::getPlayer);
    }

    public Optional<CommandSender> getCommandSender() {
        if (this.isConsole()) {
            return Optional.of(Bukkit.getConsoleSender());
        }
        return this.getPlayer().map(p -> p);
    }

    public void executeCommand(String command) {
        if (this.isConsole()) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        } else {
            this.getPlayer().ifPresent(player -> Bukkit.dispatchCommand((CommandSender)player, (String)command));
        }
    }

    public void chatAs(String message) {
        if (this.isConsole()) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)message);
        } else {
            this.getPlayer().ifPresent(player -> player.chat(message));
        }
    }

    public boolean sendMessage(@Nullable String alternate, BaseComponent ... components) {
        AtomicBoolean success = new AtomicBoolean(false);
        this.getCommandSender().ifPresent(sender -> {
            try {
                sender.spigot().sendMessage(components);
                success.set(true);
            }
            catch (Throwable e) {
                BukkitOfUtils.getInstance().logWarning("Failed to send Component message: " + e.getMessage(), e);
                if (alternate != null) {
                    this.sendMessage(alternate);
                    success.set(true);
                }
                success.set(false);
            }
        });
        return success.get();
    }

    public boolean sendMessage(BaseComponent ... components) {
        return this.sendMessage((String)null, components);
    }

    public boolean sendMessage(String alternate, ComponentBuilder builder) {
        return this.sendMessage(alternate, builder.create());
    }

    public boolean sendMessage(ComponentBuilder builder) {
        return this.sendMessage(builder.create());
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCommandSender(CommandSender commandSender) {
        this.commandSender = commandSender;
    }
}

