/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.compat;

import gg.drak.thebase.objects.Identifiable;
import java.util.Optional;
import java.util.function.Function;

public abstract class ApiHolder<A>
implements Identifiable {
    private String identifier;
    private Optional<A> api;
    private Function<Void, A> getter;

    public ApiHolder(String identifier, Function<Void, A> getter) {
        this.identifier = identifier;
        this.getter = getter;
        this.tryEnable();
    }

    public A checkApi() {
        try {
            return this.getter.apply(null);
        }
        catch (Throwable t2) {
            return null;
        }
    }

    public void tryEnable() {
        A api = this.checkApi();
        this.api = api != null ? Optional.of(api) : Optional.empty();
    }

    public boolean isEnabled() {
        return this.api.isPresent();
    }

    public A api() {
        return this.api.orElse(null);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public Optional<A> getApi() {
        return this.api;
    }

    public Function<Void, A> getGetter() {
        return this.getter;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setApi(Optional<A> api) {
        this.api = api;
    }

    public void setGetter(Function<Void, A> getter) {
        this.getter = getter;
    }

    public static enum ApiTristate {
        TRUE,
        FALSE,
        NULL;

    }
}

