/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.compat;

import host.plas.bou.BukkitOfUtils;
import host.plas.bou.compat.ApiHolder;
import host.plas.bou.compat.CompatibilityManager;
import host.plas.bou.compat.EmptyHolder;
import host.plas.bou.compat.HeldHolder;
import host.plas.bou.compat.luckperms.LPHeld;
import host.plas.bou.compat.luckperms.LPHolder;
import host.plas.bou.compat.papi.PAPIHeld;
import host.plas.bou.compat.papi.PAPIHolder;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class CompatManager {
    public static final String PAPI_IDENTIFIER = "PlaceholderAPI";
    public static final String LP_IDENTIFIER = "LuckPerms";
    private static ConcurrentSkipListMap<String, HeldHolder> holders = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<Integer, CompatibilityManager> managers = new ConcurrentSkipListMap();

    public static void init() {
        CompatManager.registerHolder(PAPI_IDENTIFIER, PAPIHeld::new);
        CompatManager.registerHolder(LP_IDENTIFIER, LPHeld::new);
    }

    public static int registerManager(CompatibilityManager manager) {
        int id = 0;
        try {
            id = managers.lastKey() + 1;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        managers.put(id, manager);
        return id;
    }

    public static void unregisterManager(int id) {
        managers.remove(id);
    }

    public static CompatibilityManager getManager(int id) {
        return managers.get(id);
    }

    public static void putHolderRaw(String identifier, HeldHolder holder) {
        CompatManager.getHolders().put(identifier, holder);
    }

    public static void registerHolder(String identifier, Function<String, HeldHolder> creationFunction) {
        HeldHolder holder = new EmptyHolder(identifier);
        try {
            holder = creationFunction.apply(identifier);
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logInfo(identifier + " not found, skipping...");
        }
        holders.put(identifier, holder);
    }

    public static void registerHolder(String identifier, Supplier<HeldHolder> creationFunction) {
        HeldHolder holder = new EmptyHolder(identifier);
        try {
            holder = creationFunction.get();
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logInfo(identifier + " not found, skipping...");
        }
        holders.put(identifier, holder);
    }

    public static void unregisterHolder(String identifier) {
        CompatManager.getHolders().remove(identifier);
    }

    public static HeldHolder getHolder(String identifier) {
        return CompatManager.getHolders().get(identifier);
    }

    public static boolean isEnabled(String identifier) {
        return CompatManager.getHolder(identifier) != null && CompatManager.getHolder(identifier).isEnabled();
    }

    public static Optional<PAPIHeld> getPAPIHeld() {
        HeldHolder holder = CompatManager.getHolder(PAPI_IDENTIFIER);
        try {
            return Optional.of((PAPIHeld)holder);
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    public static Optional<LPHeld> getLPHeld() {
        HeldHolder holder = CompatManager.getHolder(LP_IDENTIFIER);
        try {
            return Optional.of((LPHeld)holder);
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    public static Optional<PAPIHolder> getPAPIHolder() {
        Optional<PAPIHeld> held = CompatManager.getPAPIHeld();
        if (held.isEmpty()) {
            return Optional.empty();
        }
        PAPIHeld h2 = held.get();
        ApiHolder<?> holder = h2.getHolder();
        try {
            return Optional.of((PAPIHolder)holder);
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    public static Optional<LPHolder> getLPHolder() {
        Optional<LPHeld> held = CompatManager.getLPHeld();
        if (held.isEmpty()) {
            return Optional.empty();
        }
        LPHeld h2 = held.get();
        ApiHolder<?> holder = h2.getHolder();
        try {
            return Optional.of((LPHolder)holder);
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    public static boolean isPAPIEnabled() {
        return CompatManager.isEnabled(PAPI_IDENTIFIER);
    }

    public static boolean isLPEnabled() {
        return CompatManager.isEnabled(LP_IDENTIFIER);
    }

    public static ConcurrentSkipListMap<String, HeldHolder> getHolders() {
        return holders;
    }

    public static void setHolders(ConcurrentSkipListMap<String, HeldHolder> holders) {
        CompatManager.holders = holders;
    }

    public static ConcurrentSkipListMap<Integer, CompatibilityManager> getManagers() {
        return managers;
    }

    public static void setManagers(ConcurrentSkipListMap<Integer, CompatibilityManager> managers) {
        CompatManager.managers = managers;
    }
}

