/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.compat.papi;

import host.plas.bou.BetterPlugin;
import host.plas.bou.BukkitOfUtils;
import host.plas.bou.compat.ApiHolder;
import host.plas.bou.compat.papi.expansion.BetterExpansion;
import host.plas.bou.compat.papi.expansion.own.BouExpansion;
import host.plas.bou.utils.EntityUtils;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;

public class PAPIHolder
extends ApiHolder<PlaceholderAPIPlugin> {
    private static ConcurrentSkipListSet<BetterExpansion> loadedExpansions = new ConcurrentSkipListSet();
    private static BouExpansion ownExpansion;
    private int enableOverride;

    public static void loadExpansion(BetterExpansion expansion) {
        PAPIHolder.unloadExpansion(expansion);
        loadedExpansions.add(expansion);
    }

    public static void unloadExpansion(String identifier) {
        loadedExpansions.removeIf(expansion -> expansion.getIdentifier().equalsIgnoreCase(identifier));
    }

    public static void unloadExpansion(BetterExpansion expansion) {
        PAPIHolder.unloadExpansion(expansion.getIdentifier());
    }

    public static Optional<BetterExpansion> getExpansion(String identifier) {
        return loadedExpansions.stream().filter(expansion -> expansion.getIdentifier().equalsIgnoreCase(identifier)).findFirst();
    }

    public static boolean isExpansionLoaded(String identifier) {
        return PAPIHolder.getExpansion(identifier).isPresent();
    }

    public PAPIHolder() {
        super("PlaceholderAPI", v -> PlaceholderAPIPlugin.getInstance());
        try {
            this.init();
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logWarning("Failed to initialize PlaceholderAPI holder.");
        }
        this.enableOverride = -1;
    }

    public void register(PlaceholderExpansion expansion) {
        expansion.register();
    }

    public void register(BetterExpansion expansion) {
        expansion.register();
    }

    public void unregister(PlaceholderExpansion expansion) {
        expansion.unregister();
    }

    public void unregister(BetterExpansion expansion) {
        expansion.unregister();
    }

    public void unregisterAll() {
        loadedExpansions.forEach(this::unregister);
    }

    public void registerAll() {
        loadedExpansions.forEach(this::register);
    }

    public void init() {
        if (this.isEnabled()) {
            ownExpansion = new BouExpansion();
        }
    }

    public ConcurrentSkipListSet<BetterExpansion> getOfPlugin(BetterPlugin plugin) {
        ConcurrentSkipListSet<BetterExpansion> expansions = new ConcurrentSkipListSet<BetterExpansion>();
        PAPIHolder.getLoadedExpansions().forEach(expansion -> {
            if (expansion.getBetterPlugin().getIdentifier().equals(plugin.getIdentifier())) {
                expansions.add((BetterExpansion)expansion);
            }
        });
        return expansions;
    }

    public void flush(BetterPlugin plugin) {
        this.getOfPlugin(plugin).forEach(expansion -> {
            try {
                this.unregister((BetterExpansion)expansion);
                if (expansion.unregister()) return;
            }
            catch (Throwable e) {
                BukkitOfUtils.getInstance().logWarning("Failed to unregister expansion " + expansion.getIdentifier() + " from PlaceholderAPI.", e);
            }
        });
    }

    public void flushAll() {
        PAPIHolder.getLoadedExpansions().forEach(expansion -> {
            try {
                this.unregister((BetterExpansion)expansion);
                if (expansion.unregister()) return;
            }
            catch (Throwable e) {
                BukkitOfUtils.getInstance().logWarning("Failed to unregister expansion " + expansion.getIdentifier() + " from PlaceholderAPI.", e);
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && (this.getEnableOverride() == -1 || this.getEnableOverride() == 1);
    }

    public void shutdown() {
        if (!this.isEnabledRaw()) {
            return;
        }
        this.flushAll();
        ownExpansion.unregister();
        loadedExpansions.clear();
        this.enableOverride = 0;
        BukkitOfUtils.getInstance().logInfo("&cPlaceholderAPI &fholder has been shut down.");
    }

    public boolean isEnabledRaw() {
        return super.isEnabled();
    }

    public String replace(OfflinePlayer player, String from) {
        if (!this.isEnabled()) {
            return from;
        }
        return PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)from);
    }

    public String replace(String from) {
        return this.replace(EntityUtils.getDummyOfflinePlayer(), from);
    }

    public static ConcurrentSkipListSet<BetterExpansion> getLoadedExpansions() {
        return loadedExpansions;
    }

    public static void setLoadedExpansions(ConcurrentSkipListSet<BetterExpansion> loadedExpansions) {
        PAPIHolder.loadedExpansions = loadedExpansions;
    }

    public static BouExpansion getOwnExpansion() {
        return ownExpansion;
    }

    public static void setOwnExpansion(BouExpansion ownExpansion) {
        PAPIHolder.ownExpansion = ownExpansion;
    }

    public int getEnableOverride() {
        return this.enableOverride;
    }

    public void setEnableOverride(int enableOverride) {
        this.enableOverride = enableOverride;
    }
}

